/*
 * Decompiled with CFR 0.152.
 */
package com.jozufozu.flywheel.vanilla;

import com.jozufozu.flywheel.api.MaterialManager;
import com.jozufozu.flywheel.api.instance.DynamicInstance;
import com.jozufozu.flywheel.api.instance.TickableInstance;
import com.jozufozu.flywheel.backend.instancing.entity.EntityInstance;
import com.jozufozu.flywheel.core.Materials;
import com.jozufozu.flywheel.core.hardcoded.ModelPart;
import com.jozufozu.flywheel.core.materials.model.ModelData;
import com.jozufozu.flywheel.core.model.Model;
import com.jozufozu.flywheel.util.AnimationTickHolder;
import com.jozufozu.flywheel.util.transform.TransformStack;
import net.minecraft.class_1160;
import net.minecraft.class_1688;
import net.minecraft.class_1921;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2464;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3532;
import net.minecraft.class_4587;

public class MinecartInstance<T extends class_1688>
extends EntityInstance<T>
implements DynamicInstance,
TickableInstance {
    private static final class_2960 MINECART_LOCATION = new class_2960("textures/entity/minecart.png");
    private final class_4587 stack = new class_4587();
    private final ModelData body;
    private ModelData contents;
    private class_2680 blockstate;

    public MinecartInstance(MaterialManager materialManager, T entity) {
        super(materialManager, entity);
        this.blockstate = entity.method_7519();
        this.contents = this.getContents();
        this.body = this.getBody();
    }

    @Override
    public void tick() {
        class_2680 displayBlockState = ((class_1688)this.entity).method_7519();
        if (displayBlockState != this.blockstate) {
            this.blockstate = displayBlockState;
            this.contents.delete();
            this.contents = this.getContents();
            this.updateLight();
        }
    }

    @Override
    public void beginFrame() {
        TransformStack tstack = TransformStack.cast(this.stack);
        this.stack.method_34426();
        float pt = AnimationTickHolder.getPartialTicks();
        class_2382 originCoordinate = this.materialManager.getOriginCoordinate();
        tstack.translate(class_3532.method_16436((double)pt, (double)((class_1688)this.entity).field_6038, (double)((class_1688)this.entity).method_23317()) - (double)originCoordinate.method_10263(), class_3532.method_16436((double)pt, (double)((class_1688)this.entity).field_5971, (double)((class_1688)this.entity).method_23318()) - (double)originCoordinate.method_10264(), class_3532.method_16436((double)pt, (double)((class_1688)this.entity).field_5989, (double)((class_1688)this.entity).method_23321()) - (double)originCoordinate.method_10260());
        float yaw = class_3532.method_16439((float)pt, (float)((class_1688)this.entity).field_5982, (float)((class_1688)this.entity).method_36454());
        long i = (long)((class_1688)this.entity).method_5628() * 493286711L;
        i = i * i * 4392167121L + i * 98761L;
        float f = (((float)(i >> 16 & 7L) + 0.5f) / 8.0f - 0.5f) * 0.004f;
        float f1 = (((float)(i >> 20 & 7L) + 0.5f) / 8.0f - 0.5f) * 0.004f;
        float f2 = (((float)(i >> 24 & 7L) + 0.5f) / 8.0f - 0.5f) * 0.004f;
        tstack.translate(f, f1, f2);
        tstack.nudge(((class_1688)this.entity).method_5628());
        double d0 = class_3532.method_16436((double)pt, (double)((class_1688)this.entity).field_6038, (double)((class_1688)this.entity).method_23317());
        double d1 = class_3532.method_16436((double)pt, (double)((class_1688)this.entity).field_5971, (double)((class_1688)this.entity).method_23318());
        double d2 = class_3532.method_16436((double)pt, (double)((class_1688)this.entity).field_5989, (double)((class_1688)this.entity).method_23321());
        class_243 vector3d = ((class_1688)this.entity).method_7508(d0, d1, d2);
        float f3 = class_3532.method_16439((float)pt, (float)((class_1688)this.entity).field_6004, (float)((class_1688)this.entity).method_36455());
        if (vector3d != null) {
            class_243 vector3d1 = ((class_1688)this.entity).method_7505(d0, d1, d2, (double)0.3f);
            class_243 vector3d2 = ((class_1688)this.entity).method_7505(d0, d1, d2, (double)-0.3f);
            if (vector3d1 == null) {
                vector3d1 = vector3d;
            }
            if (vector3d2 == null) {
                vector3d2 = vector3d;
            }
            tstack.translate(vector3d.field_1352 - d0, (vector3d1.field_1351 + vector3d2.field_1351) / 2.0 - d1, vector3d.field_1350 - d2);
            class_243 vector3d3 = vector3d2.method_1031(-vector3d1.field_1352, -vector3d1.field_1351, -vector3d1.field_1350);
            if (vector3d3.method_1033() != 0.0) {
                vector3d3 = vector3d3.method_1029();
                yaw = (float)(Math.atan2(vector3d3.field_1350, vector3d3.field_1352) * 180.0 / Math.PI);
                f3 = (float)(Math.atan(vector3d3.field_1351) * 73.0);
            }
        }
        tstack.translate(0.0, 0.375, 0.0);
        tstack.multiply(class_1160.field_20705.method_23214(180.0f - yaw));
        tstack.multiply(class_1160.field_20707.method_23214(-f3));
        float f5 = (float)((class_1688)this.entity).method_7507() - pt;
        float f6 = ((class_1688)this.entity).method_7521() - pt;
        if (f6 < 0.0f) {
            f6 = 0.0f;
        }
        if (f5 > 0.0f) {
            tstack.multiply(class_1160.field_20703.method_23214(class_3532.method_15374((float)f5) * f5 * f6 / 10.0f * (float)((class_1688)this.entity).method_7522()));
        }
        int j = ((class_1688)this.entity).method_7514();
        if (this.contents != null) {
            tstack.pushPose();
            tstack.scale(0.75f);
            tstack.translate(-0.5, (float)(j - 8) / 16.0f, 0.5);
            tstack.multiply(class_1160.field_20705.method_23214(90.0f));
            this.contents.setTransform(this.stack);
            tstack.popPose();
        }
        this.body.setTransform(this.stack);
    }

    @Override
    public void updateLight() {
        if (this.contents == null) {
            this.relight(this.getWorldPosition(), this.body);
        } else {
            this.relight(this.getWorldPosition(), this.body, this.contents);
        }
    }

    @Override
    public void remove() {
        this.body.delete();
        if (this.contents != null) {
            this.contents.delete();
        }
    }

    private ModelData getContents() {
        if (this.blockstate.method_26217() == class_2464.field_11455) {
            return null;
        }
        return this.materialManager.defaultSolid().material(Materials.TRANSFORMED).getModel(this.blockstate).createInstance();
    }

    private ModelData getBody() {
        return this.materialManager.solid(class_1921.method_23572((class_2960)MINECART_LOCATION)).material(Materials.TRANSFORMED).model(((class_1688)this.entity).method_5864(), this::getBodyModel).createInstance();
    }

    private Model getBodyModel() {
        int y = -3;
        return ModelPart.builder("minecart", 64, 32).cuboid().invertYZ().start(-10.0f, -8.0f, -y).size(20.0f, 16.0f, 2.0f).textureOffset(0, 10).rotateZ((float)Math.PI).rotateX(1.5707964f).endCuboid().cuboid().invertYZ().start(-8.0f, y, -10.0f).size(16.0f, 8.0f, 2.0f).rotateY(4.712389f).endCuboid().cuboid().invertYZ().start(-8.0f, y, -10.0f).size(16.0f, 8.0f, 2.0f).rotateY(1.5707964f).endCuboid().cuboid().invertYZ().start(-8.0f, y, -8.0f).size(16.0f, 8.0f, 2.0f).rotateY((float)Math.PI).endCuboid().cuboid().invertYZ().start(-8.0f, y, -8.0f).size(16.0f, 8.0f, 2.0f).endCuboid().build();
    }
}

