/*
 * Decompiled with CFR 0.152.
 */
package com.jozufozu.flywheel.vanilla;

import com.jozufozu.flywheel.api.MaterialManager;
import com.jozufozu.flywheel.api.instance.DynamicInstance;
import com.jozufozu.flywheel.backend.instancing.blockentity.BlockEntityInstance;
import com.jozufozu.flywheel.core.Materials;
import com.jozufozu.flywheel.core.hardcoded.ModelPart;
import com.jozufozu.flywheel.core.materials.model.ModelData;
import com.jozufozu.flywheel.core.materials.oriented.OrientedData;
import com.jozufozu.flywheel.util.AnimationTickHolder;
import it.unimi.dsi.fastutil.floats.Float2FloatFunction;
import java.util.Calendar;
import javax.annotation.Nonnull;
import net.minecraft.class_1158;
import net.minecraft.class_1160;
import net.minecraft.class_1921;
import net.minecraft.class_2248;
import net.minecraft.class_2281;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2586;
import net.minecraft.class_2618;
import net.minecraft.class_2745;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_4722;
import net.minecraft.class_4730;
import net.minecraft.class_4732;
import net.minecraft.class_4739;

public class ChestInstance<T extends class_2586>
extends BlockEntityInstance<T>
implements DynamicInstance {
    private final OrientedData body;
    private final ModelData lid;
    private final Float2FloatFunction lidProgress;
    private final class_4730 renderMaterial;
    @Nonnull
    private final class_2745 chestType;
    private final class_1158 baseRotation;
    private float lastProgress = Float.NaN;

    public ChestInstance(MaterialManager materialManager, T blockEntity) {
        super(materialManager, blockEntity);
        class_2248 block = this.blockState.method_26204();
        this.chestType = this.blockState.method_28498((class_2769)class_2281.field_10770) ? (class_2745)this.blockState.method_11654((class_2769)class_2281.field_10770) : class_2745.field_12569;
        this.renderMaterial = class_4722.method_24062(blockEntity, (class_2745)this.chestType, (boolean)ChestInstance.isChristmas());
        this.body = this.baseInstance().setPosition(this.getInstancePosition());
        this.lid = this.lidInstance();
        if (block instanceof class_4739) {
            class_4739 chestBlock = (class_4739)block;
            float horizontalAngle = ((class_2350)this.blockState.method_11654((class_2769)class_2281.field_10768)).method_10144();
            this.baseRotation = class_1160.field_20705.method_23214(-horizontalAngle);
            this.body.setRotation(this.baseRotation);
            class_4732.class_4734 wrapper = chestBlock.method_24167(this.blockState, this.world, this.getWorldPosition(), true);
            this.lidProgress = (Float2FloatFunction)wrapper.apply(class_2281.method_24166((class_2618)((class_2618)blockEntity)));
        } else {
            this.baseRotation = class_1158.field_21493;
            this.lidProgress = $ -> 0.0f;
        }
    }

    @Override
    public void beginFrame() {
        float progress = this.lidProgress.get(AnimationTickHolder.getPartialTicks());
        if (this.lastProgress == progress) {
            return;
        }
        this.lastProgress = progress;
        progress = 1.0f - progress;
        progress = 1.0f - progress * progress * progress;
        float angleX = -(progress * 1.5707964f);
        ((ModelData)((ModelData)((ModelData)this.lid.loadIdentity().translate((class_2382)this.getInstancePosition())).translate(0.0, 0.5625, 0.0).centre()).multiply(this.baseRotation).unCentre()).translate(0.0, 0.0, 0.0625).multiply(class_1160.field_20703.method_23626(angleX)).translate(0.0, 0.0, -0.0625);
    }

    @Override
    public void updateLight() {
        this.relight(this.getWorldPosition(), this.body, this.lid);
    }

    @Override
    public void remove() {
        this.body.delete();
        this.lid.delete();
    }

    private OrientedData baseInstance() {
        return this.materialManager.solid(class_1921.method_23572((class_2960)this.renderMaterial.method_24144())).material(Materials.ORIENTED).model("base_" + this.renderMaterial.method_24147(), this::getBaseModel).createInstance();
    }

    private ModelData lidInstance() {
        return this.materialManager.solid(class_1921.method_23572((class_2960)this.renderMaterial.method_24144())).material(Materials.TRANSFORMED).model("lid_" + this.renderMaterial.method_24147(), this::getLidModel).createInstance();
    }

    private ModelPart getBaseModel() {
        return switch (this.chestType) {
            case class_2745.field_12574 -> ModelPart.builder("chest_base_left", 64, 64).sprite(this.renderMaterial.method_24148()).cuboid().textureOffset(0, 19).start(0.0f, 0.0f, 1.0f).size(15.0f, 10.0f, 14.0f).endCuboid().build();
            case class_2745.field_12571 -> ModelPart.builder("chest_base_right", 64, 64).sprite(this.renderMaterial.method_24148()).cuboid().textureOffset(0, 19).start(1.0f, 0.0f, 1.0f).size(15.0f, 10.0f, 14.0f).endCuboid().build();
            default -> ModelPart.builder("chest_base", 64, 64).sprite(this.renderMaterial.method_24148()).cuboid().textureOffset(0, 19).start(1.0f, 0.0f, 1.0f).end(15.0f, 10.0f, 15.0f).endCuboid().build();
        };
    }

    private ModelPart getLidModel() {
        return switch (this.chestType) {
            case class_2745.field_12574 -> ModelPart.builder("chest_lid_left", 64, 64).sprite(this.renderMaterial.method_24148()).cuboid().textureOffset(0, 0).start(0.0f, 0.0f, 1.0f).size(15.0f, 5.0f, 14.0f).endCuboid().cuboid().start(0.0f, -2.0f, 15.0f).size(1.0f, 4.0f, 1.0f).endCuboid().build();
            case class_2745.field_12571 -> ModelPart.builder("chest_lid_right", 64, 64).sprite(this.renderMaterial.method_24148()).cuboid().textureOffset(0, 0).start(1.0f, 0.0f, 1.0f).size(15.0f, 5.0f, 14.0f).endCuboid().cuboid().start(15.0f, -2.0f, 15.0f).size(1.0f, 4.0f, 1.0f).endCuboid().build();
            default -> ModelPart.builder("chest_lid", 64, 64).sprite(this.renderMaterial.method_24148()).cuboid().textureOffset(0, 0).start(1.0f, 0.0f, 1.0f).size(14.0f, 5.0f, 14.0f).endCuboid().cuboid().start(7.0f, -2.0f, 15.0f).size(2.0f, 4.0f, 1.0f).endCuboid().build();
        };
    }

    public static boolean isChristmas() {
        Calendar calendar = Calendar.getInstance();
        return calendar.get(2) + 1 == 12 && calendar.get(5) >= 24 && calendar.get(5) <= 26;
    }
}

