/*
 * Decompiled with CFR 0.152.
 */
package com.jozufozu.flywheel.util.box;

import com.jozufozu.flywheel.util.RenderMath;
import com.jozufozu.flywheel.util.box.CoordinateConsumer;
import com.jozufozu.flywheel.util.box.ImmutableBox;
import java.util.Collection;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_4076;

public class GridAlignedBB
implements ImmutableBox {
    private int minX;
    private int minY;
    private int minZ;
    private int maxX;
    private int maxY;
    private int maxZ;

    public GridAlignedBB() {
    }

    public GridAlignedBB(int minX, int minY, int minZ, int maxX, int maxY, int maxZ) {
        this.minX = minX;
        this.minY = minY;
        this.minZ = minZ;
        this.maxX = maxX;
        this.maxY = maxY;
        this.maxZ = maxZ;
    }

    public static GridAlignedBB ofRadius(int radius) {
        return new GridAlignedBB(-radius, -radius, -radius, radius + 1, radius + 1, radius + 1);
    }

    public static GridAlignedBB from(class_238 aabb) {
        int minX = (int)Math.floor(aabb.field_1323);
        int minY = (int)Math.floor(aabb.field_1322);
        int minZ = (int)Math.floor(aabb.field_1321);
        int maxX = (int)Math.ceil(aabb.field_1320);
        int maxY = (int)Math.ceil(aabb.field_1325);
        int maxZ = (int)Math.ceil(aabb.field_1324);
        return new GridAlignedBB(minX, minY, minZ, maxX, maxY, maxZ);
    }

    public static GridAlignedBB from(class_4076 pos) {
        return new GridAlignedBB(pos.method_19527(), pos.method_19528(), pos.method_19529(), pos.method_19530() + 1, pos.method_19531() + 1, pos.method_19532() + 1);
    }

    public static GridAlignedBB from(class_2338 start, class_2338 end) {
        return new GridAlignedBB(start.method_10263(), start.method_10264(), start.method_10260(), end.method_10263() + 1, end.method_10264() + 1, end.method_10260() + 1);
    }

    public static GridAlignedBB from(class_2338 pos) {
        return new GridAlignedBB(pos.method_10263(), pos.method_10264(), pos.method_10260(), pos.method_10263() + 1, pos.method_10264() + 1, pos.method_10260() + 1);
    }

    public static GridAlignedBB from(int sectionX, int sectionZ) {
        int startX = sectionX << 4;
        int startZ = sectionZ << 4;
        return new GridAlignedBB(startX, 0, startZ, startX + 16, 256, startZ + 16);
    }

    public static ImmutableBox containingAll(Collection<class_2338> positions) {
        if (positions.isEmpty()) {
            return new GridAlignedBB();
        }
        int minX = Integer.MAX_VALUE;
        int minY = Integer.MAX_VALUE;
        int minZ = Integer.MAX_VALUE;
        int maxX = Integer.MIN_VALUE;
        int maxY = Integer.MIN_VALUE;
        int maxZ = Integer.MIN_VALUE;
        for (class_2338 pos : positions) {
            minX = Math.min(minX, pos.method_10263());
            minY = Math.min(minY, pos.method_10264());
            minZ = Math.min(minZ, pos.method_10260());
            maxX = Math.max(maxX, pos.method_10263());
            maxY = Math.max(maxY, pos.method_10264());
            maxZ = Math.max(maxZ, pos.method_10260());
        }
        return new GridAlignedBB(minX, minY, minZ, maxX, maxY, maxZ);
    }

    public void fixMinMax() {
        int minX = Math.min(this.minX, this.maxX);
        int minY = Math.min(this.minY, this.maxY);
        int minZ = Math.min(this.minZ, this.maxZ);
        int maxX = Math.max(this.minX, this.maxX);
        int maxY = Math.max(this.minY, this.maxY);
        int maxZ = Math.max(this.minZ, this.maxZ);
        this.minX = minX;
        this.minY = minY;
        this.minZ = minZ;
        this.maxX = maxX;
        this.maxY = maxY;
        this.maxZ = maxZ;
    }

    public void translate(class_2382 by) {
        this.translate(by.method_10263(), by.method_10264(), by.method_10260());
    }

    public void translate(int x, int y, int z) {
        this.minX += x;
        this.maxX += x;
        this.minY += y;
        this.maxY += y;
        this.minZ += z;
        this.maxZ += z;
    }

    public void mirrorAbout(class_2350.class_2351 axis) {
        class_2382 axisVec = class_2350.method_10156((class_2350.class_2352)class_2350.class_2352.field_11056, (class_2350.class_2351)axis).method_10163();
        int flipX = axisVec.method_10263() - 1;
        int flipY = axisVec.method_10264() - 1;
        int flipZ = axisVec.method_10260() - 1;
        int maxX = this.maxX * flipX;
        int maxY = this.maxY * flipY;
        int maxZ = this.maxZ * flipZ;
        this.maxX = this.minX * flipX;
        this.maxY = this.minY * flipY;
        this.maxZ = this.minZ * flipZ;
        this.minX = maxX;
        this.minY = maxY;
        this.minZ = maxZ;
    }

    public void nextPowerOf2Centered() {
        int sizeX = this.sizeX();
        int sizeY = this.sizeY();
        int sizeZ = this.sizeZ();
        int newSizeX = RenderMath.nextPowerOf2(sizeX);
        int newSizeY = RenderMath.nextPowerOf2(sizeY);
        int newSizeZ = RenderMath.nextPowerOf2(sizeZ);
        int diffX = newSizeX - sizeX;
        int diffY = newSizeY - sizeY;
        int diffZ = newSizeZ - sizeZ;
        this.minX -= diffX / 2;
        this.minY -= diffY / 2;
        this.minZ -= diffZ / 2;
        this.maxX += (diffX + 1) / 2;
        this.maxY += (diffY + 1) / 2;
        this.maxZ += (diffZ + 1) / 2;
    }

    public void nextPowerOf2() {
        int sizeX = RenderMath.nextPowerOf2(this.sizeX());
        int sizeY = RenderMath.nextPowerOf2(this.sizeY());
        int sizeZ = RenderMath.nextPowerOf2(this.sizeZ());
        this.maxX = this.minX + sizeX;
        this.maxY = this.minY + sizeY;
        this.maxZ = this.minZ + sizeZ;
    }

    public void grow(int s) {
        this.grow(s, s, s);
    }

    public void grow(int x, int y, int z) {
        this.minX -= x;
        this.minY -= y;
        this.minZ -= z;
        this.maxX += x;
        this.maxY += y;
        this.maxZ += z;
    }

    public void intersectAssign(ImmutableBox other) {
        this.minX = Math.max(this.minX, other.getMinX());
        this.minY = Math.max(this.minY, other.getMinY());
        this.minZ = Math.max(this.minZ, other.getMinZ());
        this.maxX = Math.min(this.maxX, other.getMaxX());
        this.maxY = Math.min(this.maxY, other.getMaxY());
        this.maxZ = Math.min(this.maxZ, other.getMaxZ());
    }

    public void unionAssign(ImmutableBox other) {
        this.minX = Math.min(this.minX, other.getMinX());
        this.minY = Math.min(this.minY, other.getMinY());
        this.minZ = Math.min(this.minZ, other.getMinZ());
        this.maxX = Math.max(this.maxX, other.getMaxX());
        this.maxY = Math.max(this.maxY, other.getMaxY());
        this.maxZ = Math.max(this.maxZ, other.getMaxZ());
    }

    public void unionAssign(class_238 other) {
        this.minX = Math.min(this.minX, (int)Math.floor(other.field_1323));
        this.minY = Math.min(this.minY, (int)Math.floor(other.field_1322));
        this.minZ = Math.min(this.minZ, (int)Math.floor(other.field_1321));
        this.maxX = Math.max(this.maxX, (int)Math.ceil(other.field_1320));
        this.maxY = Math.max(this.maxY, (int)Math.ceil(other.field_1325));
        this.maxZ = Math.max(this.maxZ, (int)Math.ceil(other.field_1324));
    }

    public void assign(class_238 other) {
        this.minX = (int)Math.floor(other.field_1323);
        this.minY = (int)Math.floor(other.field_1322);
        this.minZ = (int)Math.floor(other.field_1321);
        this.maxX = (int)Math.ceil(other.field_1320);
        this.maxY = (int)Math.ceil(other.field_1325);
        this.maxZ = (int)Math.ceil(other.field_1324);
    }

    public void assign(ImmutableBox other) {
        this.minX = other.getMinX();
        this.minY = other.getMinY();
        this.minZ = other.getMinZ();
        this.maxX = other.getMaxX();
        this.maxY = other.getMaxY();
        this.maxZ = other.getMaxZ();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ImmutableBox that = (ImmutableBox)o;
        return this.sameAs(that);
    }

    public int hashCode() {
        int result = this.getMinX();
        result = 31 * result + this.getMinY();
        result = 31 * result + this.getMinZ();
        result = 31 * result + this.getMaxX();
        result = 31 * result + this.getMaxY();
        result = 31 * result + this.getMaxZ();
        return result;
    }

    @Override
    public int getMinX() {
        return this.minX;
    }

    @Override
    public int getMinY() {
        return this.minY;
    }

    @Override
    public int getMinZ() {
        return this.minZ;
    }

    @Override
    public int getMaxX() {
        return this.maxX;
    }

    @Override
    public int getMaxY() {
        return this.maxY;
    }

    @Override
    public int getMaxZ() {
        return this.maxZ;
    }

    public GridAlignedBB setMinX(int minX) {
        this.minX = minX;
        return this;
    }

    public GridAlignedBB setMinY(int minY) {
        this.minY = minY;
        return this;
    }

    public GridAlignedBB setMinZ(int minZ) {
        this.minZ = minZ;
        return this;
    }

    public GridAlignedBB setMaxX(int maxX) {
        this.maxX = maxX;
        return this;
    }

    public GridAlignedBB setMaxY(int maxY) {
        this.maxY = maxY;
        return this;
    }

    public GridAlignedBB setMaxZ(int maxZ) {
        this.maxZ = maxZ;
        return this;
    }

    public GridAlignedBB assign(class_2338 start, class_2338 end) {
        this.minX = start.method_10263();
        this.minY = start.method_10264();
        this.minZ = start.method_10260();
        this.maxX = end.method_10263() + 1;
        this.maxY = end.method_10264() + 1;
        this.maxZ = end.method_10260() + 1;
        return this;
    }

    public GridAlignedBB setMax(class_2382 v) {
        return this.setMax(v.method_10263(), v.method_10264(), v.method_10260());
    }

    public GridAlignedBB setMin(class_2382 v) {
        return this.setMin(v.method_10263(), v.method_10264(), v.method_10260());
    }

    public GridAlignedBB setMax(int x, int y, int z) {
        this.maxX = x;
        this.maxY = y;
        this.maxZ = z;
        return this;
    }

    public GridAlignedBB setMin(int x, int y, int z) {
        this.minX = x;
        this.minY = y;
        this.minZ = z;
        return this;
    }

    @Override
    public int sizeX() {
        return this.maxX - this.minX;
    }

    @Override
    public int sizeY() {
        return this.maxY - this.minY;
    }

    @Override
    public int sizeZ() {
        return this.maxZ - this.minZ;
    }

    @Override
    public boolean empty() {
        return this.minX == this.maxX || this.minY == this.maxY || this.minZ == this.maxZ;
    }

    @Override
    public boolean sameAs(ImmutableBox other) {
        return this.minX == other.getMinX() && this.minY == other.getMinY() && this.minZ == other.getMinZ() && this.maxX == other.getMaxX() && this.maxY == other.getMaxY() && this.maxZ == other.getMaxZ();
    }

    @Override
    public boolean sameAs(class_238 other) {
        return (double)this.minX == Math.floor(other.field_1323) && (double)this.minY == Math.floor(other.field_1322) && (double)this.minZ == Math.floor(other.field_1321) && (double)this.maxX == Math.ceil(other.field_1320) && (double)this.maxY == Math.ceil(other.field_1325) && (double)this.maxZ == Math.ceil(other.field_1324);
    }

    @Override
    public GridAlignedBB intersect(ImmutableBox other) {
        int minX = Math.max(this.minX, other.getMinX());
        int minY = Math.max(this.minY, other.getMinY());
        int minZ = Math.max(this.minZ, other.getMinZ());
        int maxX = Math.min(this.maxX, other.getMaxX());
        int maxY = Math.min(this.maxY, other.getMaxY());
        int maxZ = Math.min(this.maxZ, other.getMaxZ());
        return new GridAlignedBB(minX, minY, minZ, maxX, maxY, maxZ);
    }

    @Override
    public ImmutableBox union(ImmutableBox other) {
        int minX = Math.min(this.minX, other.getMinX());
        int minY = Math.min(this.minY, other.getMinY());
        int minZ = Math.min(this.minZ, other.getMinZ());
        int maxX = Math.max(this.maxX, other.getMaxX());
        int maxY = Math.max(this.maxY, other.getMaxY());
        int maxZ = Math.max(this.maxZ, other.getMaxZ());
        return new GridAlignedBB(minX, minY, minZ, maxX, maxY, maxZ);
    }

    @Override
    public boolean contains(ImmutableBox other) {
        return other.getMinX() >= this.minX && other.getMaxX() <= this.maxX && other.getMinY() >= this.minY && other.getMaxY() <= this.maxY && other.getMinZ() >= this.minZ && other.getMaxZ() <= this.maxZ;
    }

    @Override
    public boolean intersects(int minX, int minY, int minZ, int maxX, int maxY, int maxZ) {
        return this.minX < maxX && this.maxX > minX && this.minY < maxY && this.maxY > minY && this.minZ < maxZ && this.maxZ > minZ;
    }

    @Override
    public void forEachContained(CoordinateConsumer func) {
        if (this.empty()) {
            return;
        }
        for (int x = this.minX; x < this.maxX; ++x) {
            for (int y = this.minY; y < this.maxY; ++y) {
                for (int z = this.minZ; z < this.maxZ; ++z) {
                    func.consume(x, y, z);
                }
            }
        }
    }

    @Override
    public class_238 toAABB() {
        return new class_238((double)this.minX, (double)this.minY, (double)this.minZ, (double)this.maxX, (double)this.maxY, (double)this.maxZ);
    }

    @Override
    public GridAlignedBB copy() {
        return new GridAlignedBB(this.minX, this.minY, this.minZ, this.maxX, this.maxY, this.maxZ);
    }

    public String toString() {
        return "(" + this.minX + ", " + this.minY + ", " + this.minZ + ")->(" + this.maxX + ", " + this.maxY + ", " + this.maxZ + ")";
    }
}

