/*
 * Decompiled with CFR 0.152.
 */
package com.jozufozu.flywheel.mixin;

import com.jozufozu.flywheel.backend.Backend;
import com.jozufozu.flywheel.backend.gl.GlStateTracker;
import com.jozufozu.flywheel.backend.instancing.InstancedRenderDispatcher;
import com.jozufozu.flywheel.core.crumbling.CrumblingRenderer;
import com.jozufozu.flywheel.event.BeginFrameEvent;
import com.jozufozu.flywheel.event.ReloadRenderersEvent;
import com.jozufozu.flywheel.event.RenderLayerEvent;
import com.jozufozu.flywheel.fabric.event.EventContext;
import com.jozufozu.flywheel.fabric.event.FlywheelEvents;
import net.minecraft.class_1159;
import net.minecraft.class_1921;
import net.minecraft.class_1936;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_286;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_4599;
import net.minecraft.class_4604;
import net.minecraft.class_638;
import net.minecraft.class_757;
import net.minecraft.class_761;
import net.minecraft.class_765;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Group;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_761.class}, priority=1001)
public class LevelRendererMixin {
    @Shadow
    private class_638 field_4085;
    @Shadow
    @Final
    private class_4599 field_20951;
    @Unique
    private boolean flywheel$LayerRendered;

    @Inject(at={@At(value="HEAD")}, method={"setupRender"})
    private void setupRender(class_4184 camera, class_4604 frustum, boolean queue, boolean isSpectator, CallbackInfo ci) {
        ((EventContext.Listener)FlywheelEvents.BEGIN_FRAME.invoker()).handleEvent(new BeginFrameEvent(this.field_4085, camera, frustum));
    }

    @Inject(at={@At(value="INVOKE", target="Lnet/minecraft/client/renderer/ShaderInstance;clear()V")}, method={"renderChunkLayer"})
    @Group(name="flywheel$renderLayer", min=1, max=2)
    private void renderLayer(class_1921 type, class_4587 stack, double camX, double camY, double camZ, class_1159 p_172999_, CallbackInfo ci) {
        this.flywheel$renderLayer(type, stack, camX, camY, camZ);
        this.flywheel$LayerRendered = true;
    }

    @Inject(at={@At(value="TAIL")}, method={"renderChunkLayer"})
    @Group(name="flywheel$renderLayer")
    private void renderLayerSodium(class_1921 type, class_4587 stack, double camX, double camY, double camZ, class_1159 p_172999_, CallbackInfo ci) {
        if (!this.flywheel$LayerRendered) {
            this.flywheel$renderLayer(type, stack, camX, camY, camZ);
        }
        this.flywheel$LayerRendered = false;
        class_286.method_34420();
    }

    @Unique
    private void flywheel$renderLayer(class_1921 type, class_4587 stack, double camX, double camY, double camZ) {
        class_4599 renderBuffers = this.field_20951;
        GlStateTracker.State restoreState = GlStateTracker.getRestoreState();
        ((EventContext.Listener)FlywheelEvents.RENDER_LAYER.invoker()).handleEvent(new RenderLayerEvent(this.field_4085, type, stack, renderBuffers, camX, camY, camZ));
        restoreState.restore();
    }

    @Inject(at={@At(value="TAIL")}, method={"allChanged"})
    private void refresh(CallbackInfo ci) {
        Backend.refresh();
        ((EventContext.Listener)FlywheelEvents.RELOAD_RENDERERS.invoker()).handleEvent(new ReloadRenderersEvent(this.field_4085));
    }

    @Inject(at={@At(value="INVOKE", target="Lnet/minecraft/client/renderer/LevelRenderer;checkPoseStack(Lcom/mojang/blaze3d/vertex/PoseStack;)V", ordinal=2)}, method={"renderLevel"})
    private void renderBlockBreaking(class_4587 stack, float p_228426_2_, long p_228426_3_, boolean p_228426_5_, class_4184 info, class_757 gameRenderer, class_765 lightTexture, class_1159 p_228426_9_, CallbackInfo ci) {
        if (!Backend.isOn()) {
            return;
        }
        class_243 cameraPos = info.method_19326();
        GlStateTracker.State restoreState = GlStateTracker.getRestoreState();
        CrumblingRenderer.renderBreaking(new RenderLayerEvent(this.field_4085, null, stack, null, cameraPos.field_1352, cameraPos.field_1351, cameraPos.field_1350));
        restoreState.restore();
    }

    @Inject(at={@At(value="TAIL")}, method={"setBlockDirty(Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/world/level/block/state/BlockState;)V"})
    private void checkUpdate(class_2338 pos, class_2680 lastState, class_2680 newState, CallbackInfo ci) {
        if (Backend.isOn()) {
            InstancedRenderDispatcher.getBlockEntities((class_1936)this.field_4085).update(this.field_4085.method_8321(pos));
        }
    }
}

