/*
 * Decompiled with CFR 0.152.
 */
package com.jozufozu.flywheel.light;

import com.jozufozu.flywheel.light.LightListener;
import com.jozufozu.flywheel.util.box.GridAlignedBB;
import com.jozufozu.flywheel.util.box.ImmutableBox;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import net.minecraft.class_1920;
import net.minecraft.class_1944;
import net.minecraft.class_2338;
import org.lwjgl.system.MemoryUtil;

public class LightVolume
implements ImmutableBox,
LightListener {
    protected final class_1920 level;
    protected final GridAlignedBB box = new GridAlignedBB();
    protected ByteBuffer lightData;

    public LightVolume(class_1920 level, ImmutableBox sampleVolume) {
        this.level = level;
        this.setBox(sampleVolume);
        this.lightData = MemoryUtil.memAlloc((int)(this.box.volume() * 2));
    }

    protected void setBox(ImmutableBox box) {
        this.box.assign(box);
    }

    public short getPackedLight(int x, int y, int z) {
        if (this.box.contains(x, y, z)) {
            return this.lightData.getShort(this.worldPosToBufferIndex(x, y, z));
        }
        return 0;
    }

    @Override
    public int getMinX() {
        return this.box.getMinX();
    }

    @Override
    public int getMinY() {
        return this.box.getMinY();
    }

    @Override
    public int getMinZ() {
        return this.box.getMinZ();
    }

    @Override
    public int getMaxX() {
        return this.box.getMaxX();
    }

    @Override
    public int getMaxY() {
        return this.box.getMaxY();
    }

    @Override
    public int getMaxZ() {
        return this.box.getMaxZ();
    }

    public void move(ImmutableBox newSampleVolume) {
        if (this.lightData == null) {
            return;
        }
        this.setBox(newSampleVolume);
        int neededCapacity = this.box.volume() * 2;
        if (neededCapacity > this.lightData.capacity()) {
            this.lightData = MemoryUtil.memRealloc((ByteBuffer)this.lightData, (int)neededCapacity);
        }
        this.initialize();
    }

    @Override
    public void onLightUpdate(class_1944 type, ImmutableBox changedVolume) {
        if (this.lightData == null) {
            return;
        }
        GridAlignedBB vol = changedVolume.copy();
        if (!vol.intersects(this.getVolume())) {
            return;
        }
        vol.intersectAssign(this.getVolume());
        if (type == class_1944.field_9282) {
            this.copyBlock(vol);
        } else if (type == class_1944.field_9284) {
            this.copySky(vol);
        }
        this.markDirty();
    }

    @Override
    public void onLightPacket(int chunkX, int chunkZ) {
        if (this.lightData == null) {
            return;
        }
        GridAlignedBB changedVolume = GridAlignedBB.from(chunkX, chunkZ);
        if (!changedVolume.intersects(this.getVolume())) {
            return;
        }
        changedVolume.intersectAssign(this.getVolume());
        this.copyLight(changedVolume);
        this.markDirty();
    }

    public void initialize() {
        if (this.lightData == null) {
            return;
        }
        this.copyLight(this.getVolume());
        this.markDirty();
    }

    public void copyBlock(ImmutableBox worldVolume) {
        class_2338.class_2339 pos = new class_2338.class_2339();
        int xShift = this.box.getMinX();
        int yShift = this.box.getMinY();
        int zShift = this.box.getMinZ();
        worldVolume.forEachContained((x, y, z) -> {
            int light = this.level.method_8314(class_1944.field_9282, (class_2338)pos.method_10103(x, y, z));
            this.writeBlock(x - xShift, y - yShift, z - zShift, light);
        });
    }

    public void copySky(ImmutableBox worldVolume) {
        class_2338.class_2339 pos = new class_2338.class_2339();
        int xShift = this.box.getMinX();
        int yShift = this.box.getMinY();
        int zShift = this.box.getMinZ();
        worldVolume.forEachContained((x, y, z) -> {
            int light = this.level.method_8314(class_1944.field_9284, (class_2338)pos.method_10103(x, y, z));
            this.writeSky(x - xShift, y - yShift, z - zShift, light);
        });
    }

    public void copyLight(ImmutableBox worldVolume) {
        class_2338.class_2339 pos = new class_2338.class_2339();
        int xShift = this.box.getMinX();
        int yShift = this.box.getMinY();
        int zShift = this.box.getMinZ();
        worldVolume.forEachContained((x, y, z) -> {
            pos.method_10103(x, y, z);
            int block = this.level.method_8314(class_1944.field_9282, (class_2338)pos);
            int sky = this.level.method_8314(class_1944.field_9284, (class_2338)pos);
            this.writeLight(x - xShift, y - yShift, z - zShift, block, sky);
        });
    }

    public void delete() {
        MemoryUtil.memFree((Buffer)this.lightData);
        this.lightData = null;
    }

    protected void markDirty() {
    }

    protected void writeLight(int x, int y, int z, int block, int sky) {
        byte b = (byte)((block & 0xF) << 4);
        byte s = (byte)((sky & 0xF) << 4);
        int i = this.boxPosToBufferIndex(x, y, z);
        this.lightData.put(i, b);
        this.lightData.put(i + 1, s);
    }

    protected void writeBlock(int x, int y, int z, int block) {
        byte b = (byte)((block & 0xF) << 4);
        this.lightData.put(this.boxPosToBufferIndex(x, y, z), b);
    }

    protected void writeSky(int x, int y, int z, int sky) {
        byte b = (byte)((sky & 0xF) << 4);
        this.lightData.put(this.boxPosToBufferIndex(x, y, z) + 1, b);
    }

    protected int worldPosToBufferIndex(int x, int y, int z) {
        return this.boxPosToBufferIndex(x -= this.box.getMinX(), y -= this.box.getMinY(), z -= this.box.getMinZ());
    }

    protected int boxPosToBufferIndex(int x, int y, int z) {
        return (x + this.box.sizeX() * (y + z * this.box.sizeY())) * 2;
    }

    @Override
    public ImmutableBox getVolume() {
        return this.box;
    }

    @Override
    public boolean isListenerInvalid() {
        return this.lightData == null;
    }
}

