/*
 * Decompiled with CFR 0.152.
 */
package com.jozufozu.flywheel.light;

import com.jozufozu.flywheel.backend.gl.GlTexture;
import com.jozufozu.flywheel.backend.gl.GlTextureUnit;
import com.jozufozu.flywheel.light.LightVolume;
import com.jozufozu.flywheel.util.box.GridAlignedBB;
import com.jozufozu.flywheel.util.box.ImmutableBox;
import java.nio.ByteBuffer;
import net.minecraft.class_1920;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL12;

public class GPULightVolume
extends LightVolume {
    protected final GridAlignedBB sampleVolume = new GridAlignedBB();
    private final GlTexture glTexture;
    private final GlTextureUnit textureUnit = GlTextureUnit.T4;
    protected boolean bufferDirty;

    public GPULightVolume(class_1920 level, ImmutableBox sampleVolume) {
        super(level, sampleVolume);
        this.sampleVolume.assign(sampleVolume);
        this.glTexture = new GlTexture(32879);
        GlTextureUnit oldState = GlTextureUnit.getActive();
        this.textureUnit.makeActive();
        this.glTexture.bind();
        int sizeX = this.box.sizeX();
        int sizeY = this.box.sizeY();
        int sizeZ = this.box.sizeZ();
        GL12.glTexImage3D((int)32879, (int)0, (int)33323, (int)sizeX, (int)sizeY, (int)sizeZ, (int)0, (int)33319, (int)5121, (long)0L);
        this.glTexture.setParameteri(10241, 9729);
        this.glTexture.setParameteri(10240, 9729);
        this.glTexture.setParameteri(10242, 33648);
        this.glTexture.setParameteri(32882, 33648);
        this.glTexture.setParameteri(10243, 33648);
        this.glTexture.unbind();
        oldState.makeActive();
    }

    @Override
    protected void setBox(ImmutableBox box) {
        this.box.assign(box);
        this.box.nextPowerOf2Centered();
        if (this.sampleVolume != null) {
            this.sampleVolume.assign(box);
        }
    }

    public void bind() {
        if (this.lightData == null || this.lightData.capacity() == 0) {
            return;
        }
        this.textureUnit.makeActive();
        this.glTexture.bind();
        this.uploadTexture();
    }

    private void uploadTexture() {
        if (this.bufferDirty) {
            GL11.glPixelStorei((int)3314, (int)0);
            GL11.glPixelStorei((int)3316, (int)0);
            GL11.glPixelStorei((int)3315, (int)0);
            GL11.glPixelStorei((int)32877, (int)0);
            GL11.glPixelStorei((int)32878, (int)0);
            GL11.glPixelStorei((int)3317, (int)2);
            int sizeX = this.box.sizeX();
            int sizeY = this.box.sizeY();
            int sizeZ = this.box.sizeZ();
            GL12.glTexSubImage3D((int)32879, (int)0, (int)0, (int)0, (int)0, (int)sizeX, (int)sizeY, (int)sizeZ, (int)33319, (int)5121, (ByteBuffer)this.lightData);
            GL11.glPixelStorei((int)3317, (int)4);
            this.bufferDirty = false;
        }
    }

    public void unbind() {
        this.glTexture.unbind();
    }

    @Override
    public void delete() {
        super.delete();
        this.glTexture.delete();
    }

    @Override
    public void move(ImmutableBox newSampleVolume) {
        if (this.lightData == null) {
            return;
        }
        if (this.box.contains(newSampleVolume)) {
            this.sampleVolume.assign(newSampleVolume);
            this.initialize();
        } else {
            super.move(newSampleVolume);
        }
    }

    @Override
    public ImmutableBox getVolume() {
        return this.sampleVolume;
    }

    @Override
    protected void markDirty() {
        this.bufferDirty = true;
    }
}

