/*
 * Decompiled with CFR 0.152.
 */
package com.jozufozu.flywheel.core.virtual;

import com.jozufozu.flywheel.api.FlywheelWorld;
import com.jozufozu.flywheel.core.virtual.VirtualChunkSource;
import com.jozufozu.flywheel.core.virtual.VirtualLevelEntityGetter;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1863;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_22;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_269;
import net.minecraft.class_2791;
import net.minecraft.class_2802;
import net.minecraft.class_2818;
import net.minecraft.class_2823;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_3568;
import net.minecraft.class_3611;
import net.minecraft.class_4076;
import net.minecraft.class_4543;
import net.minecraft.class_5269;
import net.minecraft.class_5455;
import net.minecraft.class_5577;
import net.minecraft.class_5712;
import net.minecraft.class_6756;
import net.minecraft.class_6880;

public class VirtualRenderWorld
extends class_1937
implements FlywheelWorld {
    public final Map<class_2338, class_2680> blocksAdded = new HashMap<class_2338, class_2680>();
    public final Map<class_2338, class_2586> besAdded = new HashMap<class_2338, class_2586>();
    public final Set<class_4076> spannedSections = new HashSet<class_4076>();
    private final class_2338.class_2339 scratch = new class_2338.class_2339();
    protected final class_1937 level;
    protected final class_3568 lighter;
    protected final VirtualChunkSource chunkSource;
    protected final class_5577<class_1297> entityGetter = new VirtualLevelEntityGetter<class_1297>();
    protected final int height;
    protected final int minBuildHeight;
    protected final class_2382 biomeOffset;

    public VirtualRenderWorld(class_1937 level) {
        this(level, class_2382.field_11176, level.method_31605(), level.method_31607());
    }

    public VirtualRenderWorld(class_1937 level, class_2382 biomeOffset) {
        this(level, biomeOffset, level.method_31605(), level.method_31607());
    }

    public VirtualRenderWorld(class_1937 level, class_2382 biomeOffset, int height, int minBuildHeight) {
        super((class_5269)level.method_8401(), level.method_27983(), level.method_40134(), () -> ((class_1937)level).method_16107(), true, false, 0L);
        this.biomeOffset = biomeOffset;
        this.level = level;
        this.height = VirtualRenderWorld.nextMultipleOf16(height);
        this.minBuildHeight = VirtualRenderWorld.nextMultipleOf16(minBuildHeight);
        this.chunkSource = new VirtualChunkSource(this);
        this.lighter = new class_3568((class_2823)this.chunkSource, true, false);
    }

    public static int nextMultipleOf16(int a) {
        if (a < 0) {
            return -((Math.abs(a) - 1 | 0xF) + 1);
        }
        return (a - 1 | 0xF) + 1;
    }

    public void runLightingEngine() {
        for (Map.Entry<class_2338, class_2680> entry : this.blocksAdded.entrySet()) {
            class_2338 pos = entry.getKey();
            class_2680 state = entry.getValue();
            int light = state.method_26213();
            if (light <= 0) continue;
            this.lighter.method_15514(pos, light);
        }
        this.lighter.method_15516(Integer.MAX_VALUE, false, false);
    }

    public void setBlockEntities(Collection<class_2586> blockEntities) {
        this.besAdded.clear();
        blockEntities.forEach(be -> this.besAdded.put(be.method_11016(), (class_2586)be));
    }

    public void clear() {
        this.blocksAdded.clear();
    }

    public boolean method_8652(class_2338 pos, class_2680 newState, int flags) {
        this.blocksAdded.put(pos, newState);
        class_4076 sectionPos = class_4076.method_18682((class_2338)pos);
        if (this.spannedSections.add(sectionPos)) {
            this.lighter.method_15551(sectionPos, false);
        }
        if ((flags & 0x80) == 0) {
            this.lighter.method_15513(pos);
        }
        return true;
    }

    public int method_31605() {
        return this.height;
    }

    public int method_31607() {
        return this.minBuildHeight;
    }

    public class_2802 method_8398() {
        return this.chunkSource;
    }

    public class_3568 method_22336() {
        return this.lighter;
    }

    protected class_5577<class_1297> method_31592() {
        return this.entityGetter;
    }

    public class_2680 method_8320(@Nullable class_2338 pos) {
        class_2680 state = this.blocksAdded.get(pos);
        if (state != null) {
            return state;
        }
        return class_2246.field_10124.method_9564();
    }

    public boolean method_8501(class_2338 pos, class_2680 state) {
        return this.method_8652(pos, state, 0);
    }

    @Nullable
    public class_2586 method_8321(class_2338 pos) {
        return this.besAdded.get(pos);
    }

    public boolean method_16358(class_2338 pos, Predicate<class_2680> condition) {
        return condition.test(this.method_8320(pos));
    }

    public class_2680 getBlockState(int x, int y, int z) {
        return this.method_8320((class_2338)this.scratch.method_10103(x, y, z));
    }

    public class_6880<class_1959> method_23753(class_2338 pPos) {
        return super.method_23753(pPos.method_10081(this.biomeOffset));
    }

    public class_6880<class_1959> method_22387(int pX, int pY, int pZ) {
        return this.level.method_22387(pX + this.biomeOffset.method_10263(), pY + this.biomeOffset.method_10264(), pZ + this.biomeOffset.method_10260());
    }

    public class_6880<class_1959> method_16359(int pX, int pY, int pZ) {
        return this.level.method_16359(pX + this.biomeOffset.method_10263(), pY + this.biomeOffset.method_10264(), pZ + this.biomeOffset.method_10260());
    }

    public int method_22339(class_2338 pos) {
        return 15;
    }

    public float method_24852(class_2350 p_230487_1_, boolean p_230487_2_) {
        return 1.0f;
    }

    public class_4543 method_22385() {
        return this.level.method_22385();
    }

    public class_5455 method_30349() {
        return this.level.method_30349();
    }

    public class_6756<class_2248> method_8397() {
        return this.level.method_8397();
    }

    public class_6756<class_3611> method_8405() {
        return this.level.method_8405();
    }

    public class_1863 method_8433() {
        return this.level.method_8433();
    }

    public int method_17889() {
        return this.level.method_17889();
    }

    public class_269 method_8428() {
        return this.level.method_8428();
    }

    @Nullable
    public class_1297 method_8469(int id) {
        return null;
    }

    @Nullable
    public class_22 method_17891(String mapName) {
        return null;
    }

    public boolean method_8477(class_2338 pos) {
        return true;
    }

    public List<? extends class_1657> method_18456() {
        return Collections.emptyList();
    }

    public String method_31419() {
        return "";
    }

    public void method_8444(@Nullable class_1657 player, int type, class_2338 pos, int data) {
    }

    public void method_8465(@Nullable class_1657 player, double x, double y, double z, class_3414 soundIn, class_3419 category, float volume, float pitch) {
    }

    public void method_8449(@Nullable class_1657 p_217384_1_, class_1297 p_217384_2_, class_3414 p_217384_3_, class_3419 p_217384_4_, float p_217384_5_, float p_217384_6_) {
    }

    public void method_17890(String pMapId, class_22 pData) {
    }

    public void method_8517(int breakerId, class_2338 pos, int progress) {
    }

    public void method_8455(class_2338 p_175666_1_, class_2248 p_175666_2_) {
    }

    public void method_32888(@Nullable class_1297 pEntity, class_5712 pEvent, class_2338 pPos) {
    }

    public void method_8413(class_2338 pos, class_2680 oldState, class_2680 newState, int flags) {
    }

    public class_2818 getChunkAtImmediately(int chunkX, int chunkZ) {
        return this.chunkSource.method_12126(chunkX, chunkZ, false);
    }

    public class_2791 getAnyChunkImmediately(int chunkX, int chunkZ) {
        return this.chunkSource.getChunk(chunkX, chunkZ);
    }

    public int method_31600() {
        return this.method_31607() + this.method_31605();
    }

    public int method_32890() {
        return this.method_31597() - this.method_32891();
    }

    public int method_32891() {
        return class_4076.method_18675((int)this.method_31607());
    }

    public int method_31597() {
        return class_4076.method_18675((int)(this.method_31600() - 1)) + 1;
    }

    public boolean method_31606(class_2338 pos) {
        return this.method_31601(pos.method_10264());
    }

    public boolean method_31601(int y) {
        return y < this.method_31607() || y >= this.method_31600();
    }

    public int method_31602(int y) {
        return this.method_31603(class_4076.method_18675((int)y));
    }

    public int method_31603(int sectionY) {
        return sectionY - this.method_32891();
    }

    public int method_31604(int sectionIndex) {
        return sectionIndex + this.method_32891();
    }
}

