/*
 * Decompiled with CFR 0.152.
 */
package com.jozufozu.flywheel.core.source;

import com.google.common.collect.Lists;
import com.jozufozu.flywheel.core.source.Index;
import com.jozufozu.flywheel.core.source.SourceFile;
import com.jozufozu.flywheel.core.source.SourceFinder;
import com.jozufozu.flywheel.util.ResourceUtil;
import com.jozufozu.flywheel.util.StringUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3300;

public class ShaderSources
implements SourceFinder {
    public static final String SHADER_DIR = "flywheel/shaders/";
    public static final ArrayList<String> EXTENSIONS = Lists.newArrayList((Object[])new String[]{".vert", ".vsh", ".frag", ".fsh", ".glsl"});
    private final Map<class_2960, SourceFile> shaderSources = new HashMap<class_2960, SourceFile>();
    public final Index index;

    public ShaderSources(class_3300 manager) {
        Collection allShaders = manager.method_14488(SHADER_DIR, s -> {
            for (String ext : EXTENSIONS) {
                if (!s.endsWith(ext)) continue;
                return true;
            }
            return false;
        });
        for (class_2960 location : allShaders) {
            try {
                class_3298 resource = manager.method_14486(location);
                try {
                    String source = StringUtil.readToString(resource.method_14482());
                    class_2960 name = ResourceUtil.removePrefixUnchecked(location, SHADER_DIR);
                    this.shaderSources.put(name, new SourceFile(this, name, source));
                }
                finally {
                    if (resource == null) continue;
                    resource.close();
                }
            }
            catch (IOException iOException) {}
        }
        this.index = new Index(this.shaderSources);
    }

    @Override
    @Nullable
    public SourceFile findSource(class_2960 name) {
        return this.shaderSources.get(name);
    }
}

