/*
 * Decompiled with CFR 0.152.
 */
package com.jozufozu.flywheel.core.source;

import com.jozufozu.flywheel.core.source.FileResolution;
import com.jozufozu.flywheel.core.source.ShaderLoadingException;
import com.jozufozu.flywheel.core.source.SourceFinder;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_2960;

public class Resolver {
    public static final Resolver INSTANCE = new Resolver();
    private final Map<class_2960, FileResolution> resolutions = new HashMap<class_2960, FileResolution>();
    private boolean hasRun = false;

    public FileResolution get(class_2960 file) {
        if (!this.hasRun) {
            return this.resolutions.computeIfAbsent(file, FileResolution::new);
        }
        FileResolution fileResolution = this.resolutions.get(file);
        if (fileResolution == null) {
            throw new RuntimeException("could not find source for file: " + file);
        }
        return fileResolution;
    }

    public void run(SourceFinder sources) {
        boolean needsCrash = false;
        for (FileResolution resolution : this.resolutions.values()) {
            if (resolution.resolve(sources)) continue;
            needsCrash = true;
        }
        if (needsCrash) {
            throw new ShaderLoadingException("Failed to resolve all source files, see log for details");
        }
        this.hasRun = true;
    }

    public void invalidate() {
        this.resolutions.values().forEach(FileResolution::invalidate);
        this.hasRun = false;
    }
}

