/*
 * Decompiled with CFR 0.152.
 */
package com.jozufozu.flywheel.core.shader;

import com.jozufozu.flywheel.backend.gl.shader.GlProgram;
import com.jozufozu.flywheel.core.shader.WorldFog;
import com.jozufozu.flywheel.util.AnimationTickHolder;
import net.minecraft.class_1041;
import net.minecraft.class_1159;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import org.lwjgl.opengl.GL20;

public class WorldProgram
extends GlProgram {
    protected final int uTime = this.getUniformLocation("uTime");
    protected final int uViewProjection = this.getUniformLocation("uViewProjection");
    protected final int uCameraPos = this.getUniformLocation("uCameraPos");
    protected final int uWindowSize = this.getUniformLocation("uWindowSize");
    private final WorldFog fog = new WorldFog(this);
    protected int uBlockAtlas;
    protected int uLightMap;

    public WorldProgram(class_2960 name, int handle) {
        super(name, handle);
        super.bind();
        this.registerSamplers();
        WorldProgram.unbind();
    }

    protected void registerSamplers() {
        this.uBlockAtlas = this.setSamplerBinding("uBlockAtlas", 0);
        this.uLightMap = this.setSamplerBinding("uLightMap", 2);
    }

    public void uploadViewProjection(class_1159 viewProjection) {
        if (this.uViewProjection < 0) {
            return;
        }
        WorldProgram.uploadMatrixUniform(this.uViewProjection, viewProjection);
    }

    public void uploadWindowSize() {
        if (this.uWindowSize < 0) {
            return;
        }
        class_1041 window = class_310.method_1551().method_22683();
        int height = window.method_4507();
        int width = window.method_4480();
        GL20.glUniform2f((int)this.uWindowSize, (float)width, (float)height);
    }

    public void uploadCameraPos(double camX, double camY, double camZ) {
        if (this.uCameraPos < 0) {
            return;
        }
        GL20.glUniform3f((int)this.uCameraPos, (float)((float)camX), (float)((float)camY), (float)((float)camZ));
    }

    public void uploadTime(float renderTime) {
        if (this.uTime < 0) {
            return;
        }
        GL20.glUniform1f((int)this.uTime, (float)renderTime);
    }

    @Override
    public void bind() {
        super.bind();
        this.fog.bind();
        this.uploadWindowSize();
        this.uploadTime(AnimationTickHolder.getRenderTime());
    }
}

