/*
 * Decompiled with CFR 0.152.
 */
package com.jozufozu.flywheel.core.model;

import com.jozufozu.flywheel.core.model.Bufferable;
import com.jozufozu.flywheel.core.model.ModelUtil;
import com.jozufozu.flywheel.core.model.ShadeSeparatingVertexConsumer;
import com.jozufozu.flywheel.core.model.WorldModel;
import com.jozufozu.flywheel.core.virtual.VirtualEmptyBlockGetter;
import com.jozufozu.flywheel.fabric.model.CullingBakedModel;
import com.jozufozu.flywheel.fabric.model.FabricModelUtil;
import com.jozufozu.flywheel.fabric.model.LayerFilteringBakedModel;
import java.util.Collection;
import java.util.Collections;
import java.util.Random;
import net.fabricmc.fabric.api.renderer.v1.model.FabricBakedModel;
import net.minecraft.class_1087;
import net.minecraft.class_1920;
import net.minecraft.class_1921;
import net.minecraft.class_2338;
import net.minecraft.class_2464;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_3499;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4608;
import net.minecraft.class_776;
import net.minecraft.class_778;

public final class WorldModelBuilder
implements Bufferable {
    private final class_1921 layer;
    private class_4587 poseStack = new class_4587();
    private class_1920 renderWorld = VirtualEmptyBlockGetter.INSTANCE;
    private Collection<class_3499.class_3501> blocks = Collections.emptyList();

    public WorldModelBuilder(class_1921 layer) {
        this.layer = layer;
    }

    @Override
    public void bufferInto(class_778 modelRenderer, class_4588 consumer, Random random) {
        class_776 dispatcher = class_310.method_1551().method_1541();
        class_778.method_20544();
        for (class_3499.class_3501 info : this.blocks) {
            class_2680 state = info.field_15596;
            if (state.method_26217() != class_2464.field_11458) continue;
            class_1087 model = dispatcher.method_3349(state);
            if (((FabricBakedModel)model).isVanillaAdapter()) {
                if (!FabricModelUtil.doesLayerMatch(state, this.layer)) {
                    continue;
                }
            } else {
                model = CullingBakedModel.wrap(model);
                model = LayerFilteringBakedModel.wrap(model, this.layer);
            }
            if (consumer instanceof ShadeSeparatingVertexConsumer) {
                ShadeSeparatingVertexConsumer shadeSeparatingWrapper = (ShadeSeparatingVertexConsumer)consumer;
                model = shadeSeparatingWrapper.wrapModel(model);
            }
            class_2338 pos = info.field_15597;
            this.poseStack.method_22903();
            this.poseStack.method_22904((double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260());
            modelRenderer.method_3374(this.renderWorld, model, state, pos, this.poseStack, consumer, true, random, 42L, class_4608.field_21444);
            this.poseStack.method_22909();
        }
        class_778.method_20545();
    }

    public WorldModelBuilder withRenderWorld(class_1920 renderWorld) {
        this.renderWorld = renderWorld;
        return this;
    }

    public WorldModelBuilder withBlocks(Collection<class_3499.class_3501> blocks) {
        this.blocks = blocks;
        return this;
    }

    public WorldModelBuilder withPoseStack(class_4587 poseStack) {
        this.poseStack = poseStack;
        return this;
    }

    public WorldModel intoMesh(String name) {
        return new WorldModel(ModelUtil.getBufferBuilder(this), name);
    }
}

