/*
 * Decompiled with CFR 0.152.
 */
package com.jozufozu.flywheel.core.layout;

import com.google.common.collect.ImmutableList;
import com.jozufozu.flywheel.core.layout.LayoutItem;
import java.util.List;

public class BufferLayout {
    private final List<LayoutItem> allAttributes;
    private final int numAttributes;
    private final int stride;

    public BufferLayout(List<LayoutItem> allAttributes) {
        this.allAttributes = allAttributes;
        int numAttributes = 0;
        int stride = 0;
        for (LayoutItem spec : allAttributes) {
            numAttributes += spec.attributeCount();
            stride += spec.size();
        }
        this.numAttributes = numAttributes;
        this.stride = stride;
    }

    public List<LayoutItem> getLayoutItems() {
        return this.allAttributes;
    }

    public int getAttributeCount() {
        return this.numAttributes;
    }

    public int getStride() {
        return this.stride;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private final ImmutableList.Builder<LayoutItem> allItems = ImmutableList.builder();

        public Builder addItems(LayoutItem ... attributes) {
            this.allItems.add((Object[])attributes);
            return this;
        }

        public BufferLayout build() {
            return new BufferLayout((List<LayoutItem>)this.allItems.build());
        }
    }
}

