/*
 * Decompiled with CFR 0.152.
 */
package com.jozufozu.flywheel.core.compile;

import com.google.common.collect.ImmutableList;
import com.jozufozu.flywheel.core.compile.FragmentData;
import com.jozufozu.flywheel.core.source.SourceFile;
import com.jozufozu.flywheel.core.source.error.ErrorReporter;
import com.jozufozu.flywheel.core.source.parse.ShaderFunction;
import com.jozufozu.flywheel.core.source.parse.ShaderStruct;
import com.jozufozu.flywheel.core.source.parse.StructField;
import com.jozufozu.flywheel.core.source.parse.Variable;
import com.jozufozu.flywheel.core.source.span.Span;
import java.util.Optional;

public class FragmentTemplateData
implements FragmentData {
    public final SourceFile file;
    public final Span interpolantName;
    public final ShaderStruct interpolant;
    public final ShaderFunction fragmentMain;

    public FragmentTemplateData(SourceFile file) {
        this.file = file;
        Optional<ShaderFunction> maybeFragmentMain = file.findFunction("fragment");
        if (maybeFragmentMain.isEmpty()) {
            ErrorReporter.generateMissingFunction(file, "fragment", "\"fragment\" function not defined");
            throw new RuntimeException();
        }
        this.fragmentMain = maybeFragmentMain.get();
        ImmutableList<Variable> fragmentParameters = this.fragmentMain.getParameters();
        if (fragmentParameters.size() != 1) {
            ErrorReporter.generateSpanError(this.fragmentMain.getArgs(), "fragment function must have exactly one argument");
            throw new RuntimeException();
        }
        this.interpolantName = ((Variable)this.fragmentMain.getParameters().get((int)0)).type;
        Optional<ShaderStruct> maybeInterpolant = file.findStruct(this.interpolantName);
        if (maybeInterpolant.isEmpty()) {
            ErrorReporter.generateMissingStruct(file, this.interpolantName, "struct not defined");
            throw new RuntimeException();
        }
        this.interpolant = maybeInterpolant.get();
    }

    @Override
    public String generateFooter() {
        StringBuilder builder = new StringBuilder();
        FragmentTemplateData.prefixFields(builder, this.interpolant, "in", "v2f_");
        builder.append(String.format("void main() {\n    Fragment o;\n\to.color = v2f_color;\n\to.texCoords = v2f_texCoords;\n\to.light = v2f_light;\n\to.diffuse = v2f_diffuse;\n\n    vec4 color = %s;\n    FLWFinalizeColor(color);\n}\n", this.fragmentMain.call("o")));
        return builder.toString();
    }

    public static void prefixFields(StringBuilder builder, ShaderStruct struct, String qualifier, String prefix) {
        ImmutableList<StructField> fields = struct.getFields();
        for (StructField field : fields) {
            builder.append(qualifier).append(' ').append(field.type).append(' ').append(prefix).append(field.name).append(";\n");
        }
    }
}

