/*
 * Decompiled with CFR 0.152.
 */
package com.jozufozu.flywheel.core.compile;

import com.jozufozu.flywheel.backend.gl.shader.GlShader;
import com.jozufozu.flywheel.backend.gl.shader.ShaderType;
import com.jozufozu.flywheel.core.compile.CompileUtil;
import com.jozufozu.flywheel.core.compile.FragmentTemplateData;
import com.jozufozu.flywheel.core.compile.Memoizer;
import com.jozufozu.flywheel.core.compile.Template;
import com.jozufozu.flywheel.core.shader.ShaderConstants;
import com.jozufozu.flywheel.core.shader.StateSnapshot;
import com.jozufozu.flywheel.core.source.FileIndexImpl;
import com.jozufozu.flywheel.core.source.FileResolution;
import com.jozufozu.flywheel.core.source.SourceFile;
import java.util.Objects;

public class FragmentCompiler
extends Memoizer<Context, GlShader> {
    private final FileResolution header;
    private final Template<FragmentTemplateData> fragment;

    public FragmentCompiler(Template<FragmentTemplateData> fragment, FileResolution header) {
        this.header = header;
        this.fragment = fragment;
    }

    @Override
    protected GlShader _create(Context key) {
        SourceFile fragmentFile = key.file;
        FragmentTemplateData appliedTemplate = this.fragment.apply(fragmentFile);
        StringBuilder builder = new StringBuilder();
        builder.append(CompileUtil.generateHeader(this.fragment.getVersion(), ShaderType.FRAGMENT));
        key.getShaderConstants().writeInto(builder);
        FileIndexImpl index = new FileIndexImpl();
        this.header.getFile().generateFinalSource(index, builder);
        fragmentFile.generateFinalSource(index, builder);
        builder.append(appliedTemplate.generateFooter());
        return new GlShader(fragmentFile.name, ShaderType.FRAGMENT, builder.toString());
    }

    @Override
    protected void _destroy(GlShader value) {
        value.delete();
    }

    public static final class Context {
        private final SourceFile file;
        private final StateSnapshot ctx;
        private final float alphaDiscard;

        public Context(SourceFile file, StateSnapshot ctx, float alphaDiscard) {
            this.file = file;
            this.ctx = ctx;
            this.alphaDiscard = alphaDiscard;
        }

        public ShaderConstants getShaderConstants() {
            ShaderConstants shaderConstants = this.ctx.getShaderConstants();
            if (this.alphaDiscard > 0.0f) {
                shaderConstants.define("ALPHA_DISCARD", this.alphaDiscard);
            }
            return shaderConstants;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || obj.getClass() != this.getClass()) {
                return false;
            }
            Context that = (Context)obj;
            return this.file == that.file && Objects.equals(this.ctx, that.ctx) && Float.floatToIntBits(this.alphaDiscard) == Float.floatToIntBits(that.alphaDiscard);
        }

        public int hashCode() {
            return Objects.hash(this.file, this.ctx, Float.valueOf(this.alphaDiscard));
        }

        public String toString() {
            return "Context[file=" + this.file + ", ctx=" + this.ctx + ", alphaDiscard=" + this.alphaDiscard + "]";
        }
    }
}

