/*
 * Decompiled with CFR 0.152.
 */
package com.jozufozu.flywheel.config;

import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;

public interface Option<T> {
    public String getKey();

    public T get();

    public void set(T var1);

    public JsonElement toJson();

    public void fromJson(JsonElement var1) throws JsonParseException;

    public static class EnumOption<E extends Enum<E>>
    extends BaseOption<E> {
        protected final Class<E> enumType;

        public EnumOption(String id, E defaultValue) {
            super(id, defaultValue);
            this.enumType = defaultValue.getClass();
        }

        @Override
        public JsonElement toJson() {
            return new JsonPrimitive(((Enum)this.get()).name());
        }

        @Override
        public void fromJson(JsonElement json) throws JsonParseException {
            String constantName = json.getAsString();
            for (Enum constant : (Enum[])this.enumType.getEnumConstants()) {
                if (!constant.name().equals(constantName)) continue;
                this.set(constant);
                break;
            }
        }

        public Class<E> getEnumType() {
            return this.enumType;
        }
    }

    public static class BooleanOption
    extends BaseOption<Boolean> {
        public BooleanOption(String id, Boolean defaultValue) {
            super(id, defaultValue);
        }

        @Override
        public JsonElement toJson() {
            return new JsonPrimitive((Boolean)this.get());
        }

        @Override
        public void fromJson(JsonElement json) throws JsonParseException {
            this.set(json.getAsBoolean());
        }
    }

    public static abstract class BaseOption<T>
    implements Option<T> {
        protected String key;
        protected T value;

        public BaseOption(String key, T defaultValue) {
            this.key = key;
            this.value = defaultValue;
        }

        @Override
        public String getKey() {
            return this.key;
        }

        @Override
        public T get() {
            return this.value;
        }

        @Override
        public void set(T value) {
            this.value = value;
        }
    }
}

