/*
 * Decompiled with CFR 0.152.
 */
package com.jozufozu.flywheel.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import com.jozufozu.flywheel.config.BackendType;
import com.jozufozu.flywheel.config.FlwCommands;
import com.jozufozu.flywheel.config.Option;
import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.ObjectBidirectionalIterator;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import java.util.Collections;
import java.util.Map;
import net.fabricmc.loader.api.FabricLoader;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class FlwConfig {
    protected static final Logger LOGGER = LogManager.getLogger((String)"Flywheel Config");
    protected static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final FlwConfig INSTANCE = new FlwConfig(FabricLoader.getInstance().getConfigDir().resolve("flywheel.json").toFile());
    protected final File file;
    protected final Object2ObjectLinkedOpenHashMap<String, Option<?>> optionMap = new Object2ObjectLinkedOpenHashMap();
    protected final Map<String, Option<?>> optionMapView = Collections.unmodifiableMap(this.optionMap);
    public final Option.EnumOption<BackendType> backend = this.addOption(new Option.EnumOption<BackendType>("engine", BackendType.INSTANCING));
    public final Option.BooleanOption debugNormals = this.addOption(new Option.BooleanOption("debugNormals", false));
    public final Option.BooleanOption limitUpdates = this.addOption(new Option.BooleanOption("limitUpdates", true));

    public FlwConfig(File file) {
        this.file = file;
    }

    public static FlwConfig get() {
        return INSTANCE;
    }

    public static void init() {
        INSTANCE.load();
        FlwCommands.init(INSTANCE);
    }

    public BackendType getBackendType() {
        return (BackendType)((Object)this.backend.get());
    }

    public boolean debugNormals() {
        return (Boolean)this.debugNormals.get();
    }

    public boolean limitUpdates() {
        return (Boolean)this.limitUpdates.get();
    }

    public void load() {
        if (this.file.exists()) {
            try (FileReader reader = new FileReader(this.file);){
                this.fromJson(JsonParser.parseReader((Reader)reader));
            }
            catch (Exception e) {
                LOGGER.error("Could not load config from file '" + this.file.getAbsolutePath() + "'", (Throwable)e);
            }
        }
        this.save();
    }

    public void save() {
        try (FileWriter writer = new FileWriter(this.file);){
            GSON.toJson(this.toJson(), (Appendable)writer);
        }
        catch (Exception e) {
            LOGGER.error("Could not save config to file '" + this.file.getAbsolutePath() + "'", (Throwable)e);
        }
    }

    protected void fromJson(JsonElement json) throws JsonParseException {
        if (json.isJsonObject()) {
            JsonObject object = json.getAsJsonObject();
            ObjectBidirectionalIterator iterator = this.optionMap.object2ObjectEntrySet().fastIterator();
            while (iterator.hasNext()) {
                Object2ObjectMap.Entry entry = (Object2ObjectMap.Entry)iterator.next();
                JsonElement element = object.get((String)entry.getKey());
                if (element == null) continue;
                ((Option)entry.getValue()).fromJson(element);
            }
        } else {
            throw new JsonParseException("Json must be an object");
        }
    }

    protected JsonElement toJson() {
        JsonObject object = new JsonObject();
        ObjectBidirectionalIterator iterator = this.optionMap.object2ObjectEntrySet().fastIterator();
        while (iterator.hasNext()) {
            Object2ObjectMap.Entry entry = (Object2ObjectMap.Entry)iterator.next();
            object.add((String)entry.getKey(), ((Option)entry.getValue()).toJson());
        }
        return object;
    }

    protected <T extends Option<?>> T addOption(T option) {
        Option old = (Option)this.optionMap.put((Object)option.getKey(), option);
        if (old != null) {
            LOGGER.warn("Option with key '" + old.getKey() + "' was overridden");
        }
        return option;
    }

    @Nullable
    public Option<?> getOption(String key) {
        return (Option)this.optionMap.get((Object)key);
    }

    public Map<String, Option<?>> getOptionMapView() {
        return this.optionMapView;
    }
}

