/*
 * Decompiled with CFR 0.152.
 */
package com.jozufozu.flywheel.backend.model;

import com.jozufozu.flywheel.util.RenderMath;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import net.minecraft.class_293;
import net.minecraft.class_296;
import net.minecraft.class_4588;
import org.lwjgl.system.MemoryUtil;

public class DirectVertexConsumer
implements class_4588 {
    public final class_293 format;
    private final int stride;
    public final int startPos;
    private int position = -1;
    private int normal = -1;
    private int color = -1;
    private int uv = -1;
    private int uv1 = -1;
    private int uv2 = -1;
    private long vertexBase;
    private final long end;

    public DirectVertexConsumer(ByteBuffer buffer, class_293 format, int maxVertices) {
        this.format = format;
        this.startPos = buffer.position();
        this.stride = format.method_1362();
        int offset = 0;
        for (class_296 element : format.method_1357()) {
            block0 : switch (element.method_1382()) {
                case field_1633: {
                    this.position = offset;
                    break;
                }
                case field_1635: {
                    this.normal = offset;
                    break;
                }
                case field_1632: {
                    this.color = offset;
                    break;
                }
                case field_1636: {
                    switch (element.method_1385()) {
                        case 0: {
                            this.uv = offset;
                            break block0;
                        }
                        case 1: {
                            this.uv1 = offset;
                            break block0;
                        }
                        case 2: {
                            this.uv2 = offset;
                        }
                    }
                }
            }
            offset += element.method_1387();
        }
        this.vertexBase = MemoryUtil.memAddress((ByteBuffer)buffer, (int)this.startPos);
        this.end = this.vertexBase + (long)maxVertices * (long)this.stride;
    }

    private DirectVertexConsumer(DirectVertexConsumer parent, int maxVertices) {
        this.format = parent.format;
        this.stride = parent.stride;
        this.startPos = parent.startPos;
        this.position = parent.position;
        this.normal = parent.normal;
        this.color = parent.color;
        this.uv = parent.uv;
        this.uv1 = parent.uv1;
        this.uv2 = parent.uv2;
        this.vertexBase = parent.vertexBase;
        this.end = parent.vertexBase + (long)maxVertices * (long)this.stride;
    }

    public void memSetZero() {
        MemoryUtil.memSet((long)this.vertexBase, (int)0, (long)(this.end - this.vertexBase));
    }

    public boolean hasOverlay() {
        return this.uv1 >= 0;
    }

    public DirectVertexConsumer split(int vertexCount) {
        int bytes = vertexCount * this.stride;
        DirectVertexConsumer head = new DirectVertexConsumer(this, vertexCount);
        this.vertexBase += (long)bytes;
        return head;
    }

    public class_4588 method_22912(double x, double y, double z) {
        this.checkOverflow();
        if (this.position < 0) {
            return this;
        }
        long base = this.vertexBase + (long)this.position;
        MemoryUtil.memPutFloat((long)base, (float)((float)x));
        MemoryUtil.memPutFloat((long)(base + 4L), (float)((float)y));
        MemoryUtil.memPutFloat((long)(base + 8L), (float)((float)z));
        return this;
    }

    public class_4588 method_1336(int r, int g, int b, int a) {
        if (this.color < 0) {
            return this;
        }
        long base = this.vertexBase + (long)this.color;
        MemoryUtil.memPutByte((long)base, (byte)((byte)r));
        MemoryUtil.memPutByte((long)(base + 1L), (byte)((byte)g));
        MemoryUtil.memPutByte((long)(base + 2L), (byte)((byte)b));
        MemoryUtil.memPutByte((long)(base + 3L), (byte)((byte)a));
        return this;
    }

    public class_4588 method_22913(float u, float v) {
        if (this.uv < 0) {
            return this;
        }
        long base = this.vertexBase + (long)this.uv;
        MemoryUtil.memPutFloat((long)base, (float)u);
        MemoryUtil.memPutFloat((long)(base + 4L), (float)v);
        return this;
    }

    public class_4588 method_22917(int u, int v) {
        if (this.uv1 < 0) {
            return this;
        }
        long base = this.vertexBase + (long)this.uv1;
        MemoryUtil.memPutShort((long)base, (short)((short)u));
        MemoryUtil.memPutShort((long)(base + 2L), (short)((short)v));
        return this;
    }

    public class_4588 method_22921(int u, int v) {
        if (this.uv2 < 0) {
            return this;
        }
        long base = this.vertexBase + (long)this.uv2;
        MemoryUtil.memPutShort((long)base, (short)((short)u));
        MemoryUtil.memPutShort((long)(base + 2L), (short)((short)v));
        return this;
    }

    public class_4588 method_22914(float x, float y, float z) {
        if (this.normal < 0) {
            return this;
        }
        long base = this.vertexBase + (long)this.normal;
        MemoryUtil.memPutByte((long)base, (byte)RenderMath.nb(x));
        MemoryUtil.memPutByte((long)(base + 1L), (byte)RenderMath.nb(y));
        MemoryUtil.memPutByte((long)(base + 2L), (byte)RenderMath.nb(z));
        return this;
    }

    public void method_1344() {
        this.vertexBase += (long)this.stride;
    }

    public void method_22901(int r, int g, int b, int a) {
    }

    public void method_35666() {
    }

    private void checkOverflow() {
        if (this.vertexBase >= this.end) {
            throw new BufferOverflowException();
        }
    }
}

