/*
 * Decompiled with CFR 0.152.
 */
package com.jozufozu.flywheel.backend.instancing;

import com.jozufozu.flywheel.api.MaterialManager;
import com.jozufozu.flywheel.backend.instancing.blockentity.BlockEntityInstance;
import com.jozufozu.flywheel.backend.instancing.blockentity.BlockEntityInstancingController;
import com.jozufozu.flywheel.backend.instancing.blockentity.BlockEntityTypeExtension;
import com.jozufozu.flywheel.backend.instancing.blockentity.SimpleBlockEntityInstancingController;
import com.jozufozu.flywheel.backend.instancing.entity.EntityInstance;
import com.jozufozu.flywheel.backend.instancing.entity.EntityInstancingController;
import com.jozufozu.flywheel.backend.instancing.entity.EntityTypeExtension;
import com.jozufozu.flywheel.backend.instancing.entity.SimpleEntityInstancingController;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_2586;
import net.minecraft.class_2591;

public class InstancedRenderRegistry {
    public static <T extends class_2586> boolean canInstance(class_2591<? extends T> type) {
        return InstancedRenderRegistry.getController(type) != null;
    }

    public static <T extends class_1297> boolean canInstance(class_1299<? extends T> type) {
        return InstancedRenderRegistry.getController(type) != null;
    }

    @Nullable
    public static <T extends class_2586> BlockEntityInstance<? super T> createInstance(MaterialManager materialManager, T blockEntity) {
        BlockEntityInstancingController<T> controller = InstancedRenderRegistry.getController(InstancedRenderRegistry.getType(blockEntity));
        if (controller == null) {
            return null;
        }
        return controller.createInstance(materialManager, blockEntity);
    }

    @Nullable
    public static <T extends class_1297> EntityInstance<? super T> createInstance(MaterialManager materialManager, T entity) {
        EntityInstancingController<T> controller = InstancedRenderRegistry.getController(InstancedRenderRegistry.getType(entity));
        if (controller == null) {
            return null;
        }
        return controller.createInstance(materialManager, entity);
    }

    public static <T extends class_2586> boolean shouldSkipRender(T blockEntity) {
        BlockEntityInstancingController<T> controller = InstancedRenderRegistry.getController(InstancedRenderRegistry.getType(blockEntity));
        if (controller == null) {
            return false;
        }
        return controller.shouldSkipRender(blockEntity);
    }

    public static <T extends class_1297> boolean shouldSkipRender(T entity) {
        EntityInstancingController<T> controller = InstancedRenderRegistry.getController(InstancedRenderRegistry.getType(entity));
        if (controller == null) {
            return false;
        }
        return controller.shouldSkipRender(entity);
    }

    public static <T extends class_2586> BlockEntityConfig<T> configure(class_2591<T> type) {
        return new BlockEntityConfig<T>(type);
    }

    public static <T extends class_1297> EntityConfig<T> configure(class_1299<T> type) {
        return new EntityConfig<T>(type);
    }

    @Nullable
    public static <T extends class_2586> BlockEntityInstancingController<? super T> getController(class_2591<T> type) {
        return ((BlockEntityTypeExtension)type).flywheel$getInstancingController();
    }

    @Nullable
    public static <T extends class_1297> EntityInstancingController<? super T> getController(class_1299<T> type) {
        return ((EntityTypeExtension)type).flywheel$getInstancingController();
    }

    public static <T extends class_2586> void setController(class_2591<T> type, BlockEntityInstancingController<? super T> instancingController) {
        ((BlockEntityTypeExtension)type).flywheel$setInstancingController(instancingController);
    }

    public static <T extends class_1297> void setController(class_1299<T> type, EntityInstancingController<? super T> instancingController) {
        ((EntityTypeExtension)type).flywheel$setInstancingController(instancingController);
    }

    public static <T extends class_2586> class_2591<? super T> getType(T blockEntity) {
        return blockEntity.method_11017();
    }

    public static <T extends class_1297> class_1299<? super T> getType(T entity) {
        return entity.method_5864();
    }

    public static class BlockEntityConfig<T extends class_2586> {
        protected class_2591<T> type;
        protected BiFunction<MaterialManager, T, BlockEntityInstance<? super T>> instanceFactory;
        protected Predicate<T> skipRender;

        public BlockEntityConfig(class_2591<T> type) {
            this.type = type;
        }

        public BlockEntityConfig<T> factory(BiFunction<MaterialManager, T, BlockEntityInstance<? super T>> instanceFactory) {
            this.instanceFactory = instanceFactory;
            return this;
        }

        public BlockEntityConfig<T> skipRender(Predicate<T> skipRender) {
            this.skipRender = skipRender;
            return this;
        }

        public BlockEntityConfig<T> alwaysSkipRender() {
            this.skipRender = be -> true;
            return this;
        }

        public SimpleBlockEntityInstancingController<T> apply() {
            Objects.requireNonNull(this.instanceFactory, "Instance factory cannot be null!");
            if (this.skipRender == null) {
                this.skipRender = be -> false;
            }
            SimpleBlockEntityInstancingController<? super T> controller = new SimpleBlockEntityInstancingController<T>(this.instanceFactory, this.skipRender);
            InstancedRenderRegistry.setController(this.type, controller);
            return controller;
        }
    }

    public static class EntityConfig<T extends class_1297> {
        protected class_1299<T> type;
        protected BiFunction<MaterialManager, T, EntityInstance<? super T>> instanceFactory;
        protected Predicate<T> skipRender;

        public EntityConfig(class_1299<T> type) {
            this.type = type;
        }

        public EntityConfig<T> factory(BiFunction<MaterialManager, T, EntityInstance<? super T>> instanceFactory) {
            this.instanceFactory = instanceFactory;
            return this;
        }

        public EntityConfig<T> skipRender(Predicate<T> skipRender) {
            this.skipRender = skipRender;
            return this;
        }

        public EntityConfig<T> alwaysSkipRender() {
            this.skipRender = entity -> true;
            return this;
        }

        public SimpleEntityInstancingController<T> apply() {
            Objects.requireNonNull(this.instanceFactory, "Instance factory cannot be null!");
            if (this.skipRender == null) {
                this.skipRender = entity -> false;
            }
            SimpleEntityInstancingController<? super T> controller = new SimpleEntityInstancingController<T>(this.instanceFactory, this.skipRender);
            InstancedRenderRegistry.setController(this.type, controller);
            return controller;
        }
    }
}

