/*
 * Decompiled with CFR 0.152.
 */
package com.jozufozu.flywheel.backend.gl;

import com.jozufozu.flywheel.backend.gl.GlObject;
import com.jozufozu.flywheel.core.layout.BufferLayout;
import com.jozufozu.flywheel.core.layout.LayoutItem;
import com.mojang.blaze3d.platform.GlStateManager;
import org.lwjgl.opengl.GL20;

public class GlVertexArray
extends GlObject {
    public GlVertexArray() {
        this.setHandle(GlStateManager._glGenVertexArrays());
    }

    public static void bind(int vao) {
        GlStateManager._glBindVertexArray((int)vao);
    }

    public void bind() {
        GlVertexArray.bind(this.handle());
    }

    public static void unbind() {
        GlStateManager._glBindVertexArray((int)0);
    }

    public void enableArrays(int count) {
        for (int i = 0; i < count; ++i) {
            GL20.glEnableVertexAttribArray((int)i);
        }
    }

    public void disableArrays(int count) {
        for (int i = 0; i < count; ++i) {
            GL20.glDisableVertexAttribArray((int)i);
        }
    }

    public void bindAttributes(int startIndex, BufferLayout type) {
        int offset = 0;
        for (LayoutItem spec : type.getLayoutItems()) {
            spec.vertexAttribPointer(type.getStride(), startIndex, offset);
            startIndex += spec.attributeCount();
            offset += spec.size();
        }
    }

    @Override
    protected void deleteInternal(int handle) {
        GlStateManager._glDeleteVertexArrays((int)handle);
    }
}

