/*
 * Decompiled with CFR 0.152.
 */
package com.jozufozu.flywheel.backend;

import com.jozufozu.flywheel.api.FlywheelWorld;
import com.jozufozu.flywheel.backend.Loader;
import com.jozufozu.flywheel.backend.RenderWork;
import com.jozufozu.flywheel.backend.ShadersModHandler;
import com.jozufozu.flywheel.backend.gl.versioned.GlCompat;
import com.jozufozu.flywheel.backend.instancing.ParallelTaskEngine;
import com.jozufozu.flywheel.config.BackendType;
import com.jozufozu.flywheel.config.FlwConfig;
import com.jozufozu.flywheel.core.shader.ProgramSpec;
import com.mojang.logging.LogUtils;
import javax.annotation.Nullable;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_761;
import org.slf4j.Logger;

public class Backend {
    public static final Logger LOGGER = LogUtils.getLogger();
    private static BackendType backendType;
    private static ParallelTaskEngine taskEngine;
    private static final Loader loader;

    public static BackendType getBackendType() {
        return backendType;
    }

    public static ParallelTaskEngine getTaskEngine() {
        if (taskEngine == null) {
            taskEngine = new ParallelTaskEngine("Flywheel");
            taskEngine.startWorkers();
        }
        return taskEngine;
    }

    public static String getBackendDescriptor() {
        return backendType == null ? "Uninitialized" : backendType.getProperName();
    }

    @Nullable
    public static ProgramSpec getSpec(class_2960 name) {
        return loader.get(name);
    }

    public static void refresh() {
        backendType = Backend.chooseEngine();
    }

    public static boolean isOn() {
        return backendType != BackendType.OFF;
    }

    public static boolean canUseInstancing(@Nullable class_1937 world) {
        return Backend.isOn() && Backend.isFlywheelWorld((class_1936)world);
    }

    public static boolean isFlywheelWorld(@Nullable class_1936 world) {
        if (world == null) {
            return false;
        }
        if (!world.method_8608()) {
            return false;
        }
        if (world instanceof FlywheelWorld && ((FlywheelWorld)world).supportsFlywheel()) {
            return true;
        }
        return world == class_310.method_1551().field_1687;
    }

    public static boolean isGameActive() {
        return class_310.method_1551().field_1687 != null && class_310.method_1551().field_1724 != null;
    }

    public static void reloadWorldRenderers() {
        RenderWork.enqueue(() -> ((class_761)class_310.method_1551().field_1769).method_3279());
    }

    private static BackendType chooseEngine() {
        BackendType preferredChoice = FlwConfig.get().getBackendType();
        boolean usingShaders = ShadersModHandler.isShaderPackInUse();
        boolean canUseEngine = switch (preferredChoice) {
            default -> throw new IncompatibleClassChangeError();
            case BackendType.OFF -> true;
            case BackendType.BATCHING -> {
                if (!usingShaders) {
                    yield true;
                }
                yield false;
            }
            case BackendType.INSTANCING -> !usingShaders && GlCompat.getInstance().instancedArraysSupported();
        };
        return canUseEngine ? preferredChoice : BackendType.OFF;
    }

    public static void init() {
    }

    private Backend() {
        throw new UnsupportedOperationException("Backend is a static class!");
    }

    static {
        loader = new Loader();
    }
}

