/*
 * Decompiled with CFR 0.152.
 */
package com.jozufozu.flywheel;

import com.jozufozu.flywheel.backend.Backend;
import com.jozufozu.flywheel.backend.Loader;
import com.jozufozu.flywheel.backend.RenderWork;
import com.jozufozu.flywheel.backend.ShadersModHandler;
import com.jozufozu.flywheel.backend.instancing.InstancedRenderDispatcher;
import com.jozufozu.flywheel.config.FlwConfig;
import com.jozufozu.flywheel.core.Contexts;
import com.jozufozu.flywheel.core.PartialModel;
import com.jozufozu.flywheel.core.QuadConverter;
import com.jozufozu.flywheel.core.compile.ProgramCompiler;
import com.jozufozu.flywheel.core.crumbling.CrumblingRenderer;
import com.jozufozu.flywheel.event.EntityWorldHandler;
import com.jozufozu.flywheel.event.ForgeEvents;
import com.jozufozu.flywheel.fabric.event.FlywheelEvents;
import com.jozufozu.flywheel.mixin.PausedPartialTickAccessor;
import com.jozufozu.flywheel.vanilla.VanillaInstances;
import com.mojang.logging.LogUtils;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientEntityEvents;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.model.ModelLoadingRegistry;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderEvents;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.fabricmc.loader.api.SemanticVersion;
import net.fabricmc.loader.api.Version;
import net.minecraft.class_2960;
import net.minecraft.class_3264;
import org.slf4j.Logger;

public class Flywheel
implements ClientModInitializer {
    public static final String ID = "flywheel";
    public static final Logger LOGGER = LogUtils.getLogger();
    private static SemanticVersion version;

    public void onInitializeClient() {
        Version version = ((ModContainer)FabricLoader.getInstance().getModContainer(ID).orElseThrow(() -> new IllegalStateException("Could not get the mod container for Flywheel!"))).getMetadata().getVersion();
        if (!(version instanceof SemanticVersion)) {
            throw new IllegalStateException("Got non-semantic version for Flywheel!");
        }
        SemanticVersion semver = (SemanticVersion)version;
        Flywheel.version = semver;
        FlwConfig.init();
        ShadersModHandler.init();
        Backend.init();
        FlywheelEvents.RELOAD_RENDERERS.register(ProgramCompiler::invalidateAll);
        FlywheelEvents.GATHER_CONTEXT.register(Contexts::flwInit);
        ModelLoadingRegistry.INSTANCE.registerModelProvider(PartialModel::onModelRegistry);
        ResourceManagerHelper.get((class_3264)class_3264.field_14188).registerReloadListener((IdentifiableResourceReloadListener)PartialModel.ResourceReloadListener.INSTANCE);
        ResourceManagerHelper.get((class_3264)class_3264.field_14188).registerReloadListener((IdentifiableResourceReloadListener)Loader.ResourceReloadListener.INSTANCE);
        WorldRenderEvents.END.register(RenderWork::onRenderWorldLast);
        ClientTickEvents.END_CLIENT_TICK.register(InstancedRenderDispatcher::tick);
        FlywheelEvents.BEGIN_FRAME.register(InstancedRenderDispatcher::onBeginFrame);
        FlywheelEvents.RENDER_LAYER.register(InstancedRenderDispatcher::renderLayer);
        FlywheelEvents.RELOAD_RENDERERS.register(InstancedRenderDispatcher::onReloadRenderers);
        FlywheelEvents.RELOAD_RENDERERS.register(QuadConverter::onRendererReload);
        FlywheelEvents.RELOAD_RENDERERS.register(CrumblingRenderer::onReloadRenderers);
        ClientEntityEvents.ENTITY_LOAD.register(EntityWorldHandler::onEntityJoinWorld);
        ClientEntityEvents.ENTITY_UNLOAD.register(EntityWorldHandler::onEntityLeaveWorld);
        ClientTickEvents.END_CLIENT_TICK.register(ForgeEvents::tickLight);
        VanillaInstances.init();
        LOGGER.debug("Successfully loaded {}", (Object)PausedPartialTickAccessor.class.getName());
    }

    public static SemanticVersion getVersion() {
        return version;
    }

    public static class_2960 rl(String path) {
        return new class_2960(ID, path);
    }
}

