/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.api.networking.v1;

import java.util.Objects;
import java.util.Set;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.fabricmc.fabric.impl.networking.server.ServerNetworkingImpl;
import net.minecraft.class_2540;
import net.minecraft.class_2596;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3244;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;

public final class ServerPlayNetworking {
    public static boolean registerGlobalReceiver(class_2960 channelName, PlayChannelHandler channelHandler) {
        return ServerNetworkingImpl.PLAY.registerGlobalReceiver(channelName, channelHandler);
    }

    @Nullable
    public static PlayChannelHandler unregisterGlobalReceiver(class_2960 channelName) {
        return ServerNetworkingImpl.PLAY.unregisterGlobalReceiver(channelName);
    }

    public static Set<class_2960> getGlobalReceivers() {
        return ServerNetworkingImpl.PLAY.getChannels();
    }

    public static boolean registerReceiver(class_3244 networkHandler, class_2960 channelName, PlayChannelHandler channelHandler) {
        Objects.requireNonNull(networkHandler, "Network handler cannot be null");
        return ServerNetworkingImpl.getAddon(networkHandler).registerChannel(channelName, channelHandler);
    }

    @Nullable
    public static PlayChannelHandler unregisterReceiver(class_3244 networkHandler, class_2960 channelName) {
        Objects.requireNonNull(networkHandler, "Network handler cannot be null");
        return (PlayChannelHandler)ServerNetworkingImpl.getAddon(networkHandler).unregisterChannel(channelName);
    }

    public static Set<class_2960> getReceived(class_3222 player) {
        Objects.requireNonNull(player, "Server player entity cannot be null");
        return ServerPlayNetworking.getReceived(player.field_13987);
    }

    public static Set<class_2960> getReceived(class_3244 handler) {
        Objects.requireNonNull(handler, "Server play network handler cannot be null");
        return ServerNetworkingImpl.getAddon(handler).getReceivableChannels();
    }

    public static Set<class_2960> getSendable(class_3222 player) {
        Objects.requireNonNull(player, "Server player entity cannot be null");
        return ServerPlayNetworking.getSendable(player.field_13987);
    }

    public static Set<class_2960> getSendable(class_3244 handler) {
        Objects.requireNonNull(handler, "Server play network handler cannot be null");
        return ServerNetworkingImpl.getAddon(handler).getSendableChannels();
    }

    public static boolean canSend(class_3222 player, class_2960 channelName) {
        Objects.requireNonNull(player, "Server player entity cannot be null");
        return ServerPlayNetworking.canSend(player.field_13987, channelName);
    }

    public static boolean canSend(class_3244 handler, class_2960 channelName) {
        Objects.requireNonNull(handler, "Server play network handler cannot be null");
        Objects.requireNonNull(channelName, "Channel name cannot be null");
        return ServerNetworkingImpl.getAddon(handler).getSendableChannels().contains(channelName);
    }

    public static class_2596<?> createS2CPacket(class_2960 channelName, class_2540 buf) {
        Objects.requireNonNull(channelName, "Channel cannot be null");
        Objects.requireNonNull(buf, "Buf cannot be null");
        return ServerNetworkingImpl.createPlayC2SPacket(channelName, buf);
    }

    public static PacketSender getSender(class_3222 player) {
        Objects.requireNonNull(player, "Server player entity cannot be null");
        return ServerPlayNetworking.getSender(player.field_13987);
    }

    public static PacketSender getSender(class_3244 handler) {
        Objects.requireNonNull(handler, "Server play network handler cannot be null");
        return ServerNetworkingImpl.getAddon(handler);
    }

    public static void send(class_3222 player, class_2960 channelName, class_2540 buf) {
        Objects.requireNonNull(player, "Server player entity cannot be null");
        Objects.requireNonNull(channelName, "Channel name cannot be null");
        Objects.requireNonNull(buf, "Packet byte buf cannot be null");
        player.field_13987.method_14364(ServerPlayNetworking.createS2CPacket(channelName, buf));
    }

    public static MinecraftServer getServer(class_3244 handler) {
        Objects.requireNonNull(handler, "Network handler cannot be null");
        return handler.field_14140.field_13995;
    }

    private ServerPlayNetworking() {
    }

    @FunctionalInterface
    public static interface PlayChannelHandler {
        public void receive(MinecraftServer var1, class_3222 var2, class_3244 var3, class_2540 var4, PacketSender var5);
    }
}

