/*
 * Decompiled with CFR 0.152.
 */
package team.reborn.energy.api.base;

import net.fabricmc.fabric.api.transfer.v1.storage.StoragePreconditions;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.fabricmc.fabric.api.transfer.v1.transaction.base.SnapshotParticipant;
import team.reborn.energy.api.EnergyStorage;

public class SimpleEnergyStorage
extends SnapshotParticipant<Long>
implements EnergyStorage {
    public long amount = 0L;
    public final long capacity;
    public final long maxInsert;
    public final long maxExtract;

    public SimpleEnergyStorage(long capacity, long maxInsert, long maxExtract) {
        StoragePreconditions.notNegative((long)capacity);
        StoragePreconditions.notNegative((long)maxInsert);
        StoragePreconditions.notNegative((long)maxExtract);
        this.capacity = capacity;
        this.maxInsert = maxInsert;
        this.maxExtract = maxExtract;
    }

    protected Long createSnapshot() {
        return this.amount;
    }

    protected void readSnapshot(Long snapshot) {
        this.amount = snapshot;
    }

    @Override
    public boolean supportsInsertion() {
        return this.maxInsert > 0L;
    }

    @Override
    public long insert(long maxAmount, TransactionContext transaction) {
        StoragePreconditions.notNegative((long)maxAmount);
        long inserted = Math.min(this.maxInsert, Math.min(maxAmount, this.capacity - this.amount));
        if (inserted > 0L) {
            this.updateSnapshots(transaction);
            this.amount += inserted;
            return inserted;
        }
        return 0L;
    }

    @Override
    public boolean supportsExtraction() {
        return this.maxExtract > 0L;
    }

    @Override
    public long extract(long maxAmount, TransactionContext transaction) {
        StoragePreconditions.notNegative((long)maxAmount);
        long extracted = Math.min(this.maxExtract, Math.min(maxAmount, this.amount));
        if (extracted > 0L) {
            this.updateSnapshots(transaction);
            this.amount -= extracted;
            return extracted;
        }
        return 0L;
    }

    @Override
    public long getAmount() {
        return this.amount;
    }

    @Override
    public long getCapacity() {
        return this.capacity;
    }
}

