/*
 * Decompiled with CFR 0.152.
 */
package team.reborn.energy.api.base;

import java.util.Objects;
import net.fabricmc.fabric.api.transfer.v1.storage.StoragePreconditions;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import team.reborn.energy.api.EnergyStorage;

public class LimitingEnergyStorage
implements EnergyStorage {
    protected final EnergyStorage backingStorage;
    protected final long maxInsert;
    protected final long maxExtract;

    public LimitingEnergyStorage(EnergyStorage backingStorage, long maxInsert, long maxExtract) {
        Objects.requireNonNull(backingStorage);
        StoragePreconditions.notNegative((long)maxInsert);
        StoragePreconditions.notNegative((long)maxExtract);
        this.backingStorage = backingStorage;
        this.maxInsert = maxInsert;
        this.maxExtract = maxExtract;
    }

    @Override
    public boolean supportsInsertion() {
        return this.maxInsert > 0L && this.backingStorage.supportsInsertion();
    }

    @Override
    public long insert(long maxAmount, TransactionContext transaction) {
        return this.backingStorage.insert(Math.min(maxAmount, this.maxInsert), transaction);
    }

    @Override
    public boolean supportsExtraction() {
        return this.maxExtract > 0L && this.backingStorage.supportsExtraction();
    }

    @Override
    public long extract(long maxAmount, TransactionContext transaction) {
        return this.backingStorage.extract(Math.min(maxAmount, this.maxExtract), transaction);
    }

    @Override
    public long getAmount() {
        return this.backingStorage.getAmount();
    }

    @Override
    public long getCapacity() {
        return this.backingStorage.getCapacity();
    }
}

