/*
 * Decompiled with CFR 0.152.
 */
package com.github.legoatoom.connectiblechains.config;

import com.github.legoatoom.connectiblechains.util.NetworkingPackets;
import io.netty.buffer.Unpooled;
import me.shedaniel.autoconfig.ConfigData;
import me.shedaniel.autoconfig.annotation.Config;
import me.shedaniel.autoconfig.annotation.ConfigEntry;
import net.fabricmc.fabric.api.networking.v1.PlayerLookup;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;

@Config(name="connectiblechains")
public class ModConfig
implements ConfigData {
    @ConfigEntry.Gui.Excluded
    private static final transient boolean IS_DEBUG_ENV = FabricLoader.getInstance().isDevelopmentEnvironment();
    @ConfigEntry.Gui.Tooltip(count=3)
    private float chainHangAmount = 9.0f;
    @ConfigEntry.BoundedDiscrete(max=32L)
    @ConfigEntry.Gui.Tooltip(count=3)
    private int maxChainRange = 7;
    @ConfigEntry.BoundedDiscrete(min=1L, max=8L)
    @ConfigEntry.Gui.Tooltip
    private int quality = 4;

    public float getChainHangAmount() {
        return this.chainHangAmount;
    }

    public void setChainHangAmount(float chainHangAmount) {
        this.chainHangAmount = chainHangAmount;
    }

    public int getMaxChainRange() {
        return this.maxChainRange;
    }

    public void setMaxChainRange(int maxChainRange) {
        this.maxChainRange = maxChainRange;
    }

    public int getQuality() {
        return this.quality;
    }

    public void setQuality(int quality) {
        this.quality = quality;
    }

    public boolean doDebugDraw() {
        return IS_DEBUG_ENV && class_310.method_1551().field_1690.field_1866;
    }

    public void syncToClients(MinecraftServer server) {
        for (class_3222 player : PlayerLookup.all((MinecraftServer)server)) {
            this.syncToClient(player);
        }
    }

    public void syncToClient(class_3222 player) {
        ServerPlayNetworking.send((class_3222)player, (class_2960)NetworkingPackets.S2C_CONFIG_SYNC_PACKET, (class_2540)this.writePacket());
    }

    public class_2540 writePacket() {
        class_2540 buf = new class_2540(Unpooled.buffer());
        buf.writeFloat(this.chainHangAmount);
        return buf;
    }

    public void readPacket(class_2540 buf) {
        this.chainHangAmount = buf.readFloat();
    }

    public ModConfig copyFrom(ModConfig config) {
        this.chainHangAmount = config.chainHangAmount;
        this.maxChainRange = config.maxChainRange;
        this.quality = config.quality;
        return this;
    }
}

