/*
 * Decompiled with CFR 0.152.
 */
package com.github.legoatoom.connectiblechains.compat;

import com.github.legoatoom.connectiblechains.ConnectibleChains;
import com.github.legoatoom.connectiblechains.chain.ChainTypesRegistry;
import com.github.legoatoom.connectiblechains.util.Helper;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.fabricmc.fabric.api.resource.SimpleResourceReloadListener;
import net.minecraft.class_1792;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_3695;

public class DataDrivenCompat
implements SimpleResourceReloadListener<Set<class_2960>> {
    public static final String PATH = "connectiblechains/types.json";
    private static final Gson GSON = new GsonBuilder().setLenient().create();

    public class_2960 getFabricId() {
        return Helper.identifier("chain_types");
    }

    public CompletableFuture<Set<class_2960>> load(class_3300 manager, class_3695 profiler, Executor executor) {
        return CompletableFuture.supplyAsync(() -> {
            if (ChainTypesRegistry.isFrozen()) {
                ConnectibleChains.LOGGER.warn("Dynamic chain types are not supported, a restart is required.");
                return Set.of();
            }
            return this.load(manager);
        });
    }

    private Set<class_2960> load(class_3300 manager) {
        HashSet<class_2960> chainTypes = new HashSet<class_2960>();
        for (String ns : manager.method_14487()) {
            try {
                for (class_3298 res : manager.method_14489(new class_2960(ns, PATH))) {
                    try {
                        class_3298 class_32982 = res;
                        try {
                            String[] strings;
                            InputStreamReader reader = new InputStreamReader(res.method_14482(), StandardCharsets.UTF_8);
                            for (String string : strings = (String[])GSON.fromJson((Reader)reader, String[].class)) {
                                class_2960 id = new class_2960(string);
                                chainTypes.add(id);
                            }
                        }
                        finally {
                            if (class_32982 == null) continue;
                            class_32982.close();
                        }
                    }
                    catch (Exception e) {
                        ConnectibleChains.LOGGER.error("Failed to load {}.", (Object)res.method_14483(), (Object)e);
                    }
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
            }
            catch (IOException e) {
                ConnectibleChains.LOGGER.error("Failed to load {} for namespace {}.", (Object)PATH, (Object)ns, (Object)e);
            }
        }
        return chainTypes;
    }

    public CompletableFuture<Void> apply(Set<class_2960> ids, class_3300 manager, class_3695 profiler, Executor executor) {
        for (class_2960 id : ids) {
            Optional item = class_2378.field_11142.method_17966(id);
            if (item.isEmpty()) {
                ConnectibleChains.LOGGER.error("Cannot add type, item {} does not exist.", (Object)id);
                continue;
            }
            ChainTypesRegistry.registerDynamic((class_1792)item.get());
        }
        return CompletableFuture.completedFuture(null);
    }
}

