/*
 * Decompiled with CFR 0.152.
 */
package com.github.legoatoom.connectiblechains.client.render.entity;

import com.github.legoatoom.connectiblechains.ConnectibleChains;
import com.github.legoatoom.connectiblechains.client.render.entity.ChainModel;
import com.github.legoatoom.connectiblechains.client.render.entity.UVRect;
import com.github.legoatoom.connectiblechains.util.Helper;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1158;
import net.minecraft.class_1160;
import net.minecraft.class_243;
import net.minecraft.class_4587;
import net.minecraft.class_4588;

public class ChainRenderer {
    private static final float CHAIN_SCALE = 1.0f;
    private static final int MAX_SEGMENTS = 2048;
    private final Object2ObjectOpenHashMap<BakeKey, ChainModel> models = new Object2ObjectOpenHashMap(256);

    public void renderBaked(class_4588 buffer, class_4587 matrices, BakeKey key, class_1160 chainVec, int blockLight0, int blockLight1, int skyLight0, int skyLight1) {
        ChainModel model;
        if (this.models.containsKey((Object)key)) {
            model = (ChainModel)this.models.get((Object)key);
        } else {
            model = this.buildModel(chainVec);
            this.models.put((Object)key, (Object)model);
            if (FabricLoader.getInstance().isDevelopmentEnvironment() && this.models.size() > 10000) {
                ConnectibleChains.LOGGER.error("Chain model leak found!");
            }
        }
        model.render(buffer, matrices, blockLight0, blockLight1, skyLight0, skyLight1);
    }

    private ChainModel buildModel(class_1160 chainVec) {
        float desiredSegmentLength = 1.0f / (float)ConnectibleChains.runtimeConfig.getQuality();
        int initialCapacity = (int)(2.0f * Helper.lengthOf(chainVec) / desiredSegmentLength);
        ChainModel.Builder builder = ChainModel.builder(initialCapacity);
        if (chainVec.method_4943() == 0.0f && chainVec.method_4947() == 0.0f) {
            this.buildFaceVertical(builder, chainVec, 45.0f, UVRect.DEFAULT_SIDE_A);
            this.buildFaceVertical(builder, chainVec, -45.0f, UVRect.DEFAULT_SIDE_B);
        } else {
            this.buildFace(builder, chainVec, 45.0f, UVRect.DEFAULT_SIDE_A);
            this.buildFace(builder, chainVec, -45.0f, UVRect.DEFAULT_SIDE_B);
        }
        return builder.build();
    }

    private void buildFaceVertical(ChainModel.Builder builder, class_1160 v, float angle, UVRect uv) {
        float actualSegmentLength = 1.0f / (float)ConnectibleChains.runtimeConfig.getQuality();
        float chainWidth = (uv.x1() - uv.x0()) / 16.0f * 1.0f;
        class_1160 normal = new class_1160((float)Math.cos(Math.toRadians(angle)), 0.0f, (float)Math.sin(Math.toRadians(angle)));
        normal.method_4942(chainWidth);
        class_1160 vert00 = new class_1160(-normal.method_4943() / 2.0f, 0.0f, -normal.method_4947() / 2.0f);
        class_1160 vert01 = vert00.method_23850();
        vert01.method_23846(normal);
        class_1160 vert10 = new class_1160(-normal.method_4943() / 2.0f, 0.0f, -normal.method_4947() / 2.0f);
        class_1160 vert11 = vert10.method_23850();
        vert11.method_23846(normal);
        float uvv0 = 0.0f;
        float uvv1 = 0.0f;
        boolean lastIter = false;
        for (int segment = 0; segment < 2048; ++segment) {
            if (vert00.method_4945() + actualSegmentLength >= v.method_4945()) {
                lastIter = true;
                actualSegmentLength = v.method_4945() - vert00.method_4945();
            }
            vert10.method_4948(0.0f, actualSegmentLength, 0.0f);
            vert11.method_4948(0.0f, actualSegmentLength, 0.0f);
            builder.vertex(vert00).uv(uv.x0() / 16.0f, uvv0).next();
            builder.vertex(vert01).uv(uv.x1() / 16.0f, uvv0).next();
            builder.vertex(vert11).uv(uv.x1() / 16.0f, uvv1 += actualSegmentLength / 1.0f).next();
            builder.vertex(vert10).uv(uv.x0() / 16.0f, uvv1).next();
            if (lastIter) break;
            uvv0 = uvv1;
            vert00.method_35920(vert10);
            vert01.method_35920(vert11);
        }
    }

    private void buildFace(ChainModel.Builder builder, class_1160 v, float angle, UVRect uv) {
        float desiredSegmentLength = 1.0f / (float)ConnectibleChains.runtimeConfig.getQuality();
        float distance = Helper.lengthOf(v);
        float distanceXZ = (float)Math.sqrt(v.method_4943() * v.method_4943() + v.method_4947() * v.method_4947());
        float wrongDistanceFactor = distance / distanceXZ;
        class_1160 vert00 = new class_1160();
        class_1160 vert01 = new class_1160();
        class_1160 vert11 = new class_1160();
        class_1160 vert10 = new class_1160();
        class_1160 normal = new class_1160();
        class_1160 rotAxis = new class_1160();
        float chainWidth = (uv.x1() - uv.x0()) / 16.0f * 1.0f;
        float uvv1 = 0.0f;
        class_1160 point0 = new class_1160();
        class_1160 point1 = new class_1160();
        point0.method_4949(0.0f, (float)Helper.drip2(0.0, distance, v.method_4945()), 0.0f);
        float gradient = (float)Helper.drip2prime(0.0, distance, v.method_4945());
        normal.method_4949(-gradient, Math.abs(distanceXZ / distance), 0.0f);
        normal.method_4952();
        float x = this.estimateDeltaX(desiredSegmentLength, gradient);
        gradient = (float)Helper.drip2prime(x * wrongDistanceFactor, distance, v.method_4945());
        float y = (float)Helper.drip2(x * wrongDistanceFactor, distance, v.method_4945());
        point1.method_4949(x, y, 0.0f);
        rotAxis.method_4949(point1.method_4943() - point0.method_4943(), point1.method_4945() - point0.method_4945(), point1.method_4947() - point0.method_4947());
        rotAxis.method_4952();
        class_1158 rotator = rotAxis.method_23214(angle);
        normal.method_19262(rotator);
        normal.method_4942(chainWidth);
        vert10.method_4949(point0.method_4943() - normal.method_4943() / 2.0f, point0.method_4945() - normal.method_4945() / 2.0f, point0.method_4947() - normal.method_4947() / 2.0f);
        vert11.method_35920(vert10);
        vert11.method_23846(normal);
        float actualSegmentLength = Helper.distanceBetween(point0, point1);
        boolean lastIter = false;
        for (int segment = 0; segment < 2048; ++segment) {
            rotAxis.method_4949(point1.method_4943() - point0.method_4943(), point1.method_4945() - point0.method_4945(), point1.method_4947() - point0.method_4947());
            rotAxis.method_4952();
            rotator = rotAxis.method_23214(angle);
            normal.method_4949(-gradient, Math.abs(distanceXZ / distance), 0.0f);
            normal.method_4952();
            normal.method_19262(rotator);
            normal.method_4942(chainWidth);
            vert00.method_35920(vert10);
            vert01.method_35920(vert11);
            vert10.method_4949(point1.method_4943() - normal.method_4943() / 2.0f, point1.method_4945() - normal.method_4945() / 2.0f, point1.method_4947() - normal.method_4947() / 2.0f);
            vert11.method_35920(vert10);
            vert11.method_23846(normal);
            float uvv0 = uvv1;
            uvv1 = uvv0 + actualSegmentLength / 1.0f;
            builder.vertex(vert00).uv(uv.x0() / 16.0f, uvv0).next();
            builder.vertex(vert01).uv(uv.x1() / 16.0f, uvv0).next();
            builder.vertex(vert11).uv(uv.x1() / 16.0f, uvv1).next();
            builder.vertex(vert10).uv(uv.x0() / 16.0f, uvv1).next();
            if (lastIter) break;
            point0.method_35920(point1);
            x += this.estimateDeltaX(desiredSegmentLength, gradient);
            if (x >= distanceXZ) {
                lastIter = true;
                x = distanceXZ;
            }
            gradient = (float)Helper.drip2prime(x * wrongDistanceFactor, distance, v.method_4945());
            y = (float)Helper.drip2(x * wrongDistanceFactor, distance, v.method_4945());
            point1.method_4949(x, y, 0.0f);
            actualSegmentLength = Helper.distanceBetween(point0, point1);
        }
    }

    private float estimateDeltaX(float s, float k) {
        return (float)((double)s / Math.sqrt(1.0f + k * k));
    }

    public void render(class_4588 buffer, class_4587 matrices, class_1160 chainVec, int blockLight0, int blockLight1, int skyLight0, int skyLight1) {
        ChainModel model = this.buildModel(chainVec);
        model.render(buffer, matrices, blockLight0, blockLight1, skyLight0, skyLight1);
    }

    public void purge() {
        this.models.clear();
    }

    public static class BakeKey {
        private final int hash;

        public BakeKey(class_243 srcPos, class_243 dstPos) {
            float dY = (float)(srcPos.field_1351 - dstPos.field_1351);
            float dXZ = Helper.distanceBetween(new class_1160((float)srcPos.field_1352, 0.0f, (float)srcPos.field_1350), new class_1160((float)dstPos.field_1352, 0.0f, (float)dstPos.field_1350));
            int hash = Float.floatToIntBits(dY);
            this.hash = hash = 31 * hash + Float.floatToIntBits(dXZ);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            BakeKey bakeKey = (BakeKey)o;
            return this.hash == bakeKey.hash;
        }

        public int hashCode() {
            return this.hash;
        }
    }
}

