/*
 * Decompiled with CFR 0.152.
 */
package com.cursery.config;

import com.cursery.Cursery;
import com.cursery.config.CommonConfiguration;
import com.cursery.enchant.CurseEnchantmentHelper;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonObject;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1887;
import net.minecraft.class_2378;
import net.minecraft.class_2960;

public class Configuration {
    private final CommonConfiguration commonConfig = new CommonConfiguration();
    final Gson gson = new GsonBuilder().setPrettyPrinting().create();

    public void load() {
        Path configPath = FabricLoader.getInstance().getConfigDir().normalize().resolve("cursery.json");
        File config = configPath.toFile();
        if (!config.exists()) {
            Cursery.LOGGER.warn("Config for limited chunks not found, recreating default");
            this.save();
        } else {
            try {
                this.commonConfig.deserialize((JsonObject)this.gson.fromJson((Reader)Files.newBufferedReader(configPath), JsonObject.class));
            }
            catch (IOException e) {
                Cursery.LOGGER.error("Could not read config from:" + configPath, (Throwable)e);
            }
        }
        this.parseConfig();
    }

    public void save() {
        Path configPath = FabricLoader.getInstance().getConfigDir().normalize().resolve("cursery.json");
        try {
            BufferedWriter writer = Files.newBufferedWriter(configPath, new OpenOption[0]);
            this.gson.toJson((Object)this.commonConfig.serialize(), JsonObject.class, (Appendable)writer);
            writer.close();
        }
        catch (IOException e) {
            Cursery.LOGGER.error("Could not write config to:" + configPath, (Throwable)e);
        }
    }

    public CommonConfiguration getCommonConfig() {
        return this.commonConfig;
    }

    public void parseConfig() {
        CurseEnchantmentHelper.curseWeightMap = new HashMap<class_1887, Integer>();
        CurseEnchantmentHelper.totalCurseWeight = 0;
        HashSet<class_1887> excluded = new HashSet<class_1887>();
        for (String entry : Cursery.config.getCommonConfig().excludedCurses) {
            class_2960 id = class_2960.method_12829((String)entry);
            if (id == null) {
                Cursery.LOGGER.error("Config entry could not be parsed, not a valid resource location " + entry);
                continue;
            }
            class_1887 enchantment = (class_1887)class_2378.field_11160.method_10223(id);
            if (enchantment == null) {
                Cursery.LOGGER.error("Config entry could not be parsed, not a valid enchant" + entry);
                continue;
            }
            excluded.add(enchantment);
        }
        for (Map.Entry enchantmentEntry : class_2378.field_11160.method_29722()) {
            if (!((class_1887)enchantmentEntry.getValue()).method_8195()) continue;
            if (!excluded.contains(enchantmentEntry.getValue())) {
                int weight = CurseEnchantmentHelper.calculateWeightFor((class_1887)enchantmentEntry.getValue());
                CurseEnchantmentHelper.totalCurseWeight += weight;
                CurseEnchantmentHelper.curseWeightMap.put((class_1887)enchantmentEntry.getValue(), weight);
                continue;
            }
            Cursery.LOGGER.info("Excluding curse: " + class_2378.field_11160.method_10221((Object)((class_1887)enchantmentEntry.getValue())) + " as config disables it");
        }
    }
}

