/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.loot;

import java.io.IOException;
import net.fabricmc.fabric.api.loot.v2.LootTableSource;
import net.fabricmc.fabric.impl.resource.loader.BuiltinModResourcePackSource;
import net.fabricmc.fabric.impl.resource.loader.FabricResource;
import net.fabricmc.fabric.impl.resource.loader.ModResourcePackCreator;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_5352;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LootUtil {
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"fabric-loot-api-v2");

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static LootTableSource determineSource(class_2960 lootTableId, class_3300 resourceManager) {
        class_2960 resourceId = new class_2960(lootTableId.method_12836(), "loot_tables/%s.json".formatted(lootTableId.method_12832()));
        try (class_3298 resource = resourceManager.method_14486(resourceId);){
            class_5352 packSource = ((FabricResource)resource).getFabricPackSource();
            if (packSource == class_5352.field_25348) {
                LootTableSource lootTableSource = LootTableSource.VANILLA;
                return lootTableSource;
            }
            if (packSource != ModResourcePackCreator.RESOURCE_PACK_SOURCE) {
                if (!(packSource instanceof BuiltinModResourcePackSource)) return LootTableSource.DATA_PACK;
            }
            LootTableSource lootTableSource = LootTableSource.MOD;
            return lootTableSource;
        }
        catch (IOException e) {
            LOGGER.error("Could not open resource for loot table {} to check its source", (Object)lootTableId, (Object)e);
        }
        return LootTableSource.DATA_PACK;
    }
}

