/*
 * Decompiled with CFR 0.152.
 */
package dev.stashy.soundcategories;

import dev.stashy.soundcategories.CategoryLoader;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.entrypoint.PreLaunchEntrypoint;
import net.minecraft.class_2960;
import net.minecraft.class_3419;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SoundCategories
implements PreLaunchEntrypoint {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final Map<class_3419, class_3419> parents = new HashMap<class_3419, class_3419>();
    public static final Map<class_3419, Float> defaultLevels = new HashMap<class_3419, Float>();
    public static final class_2960 SETTINGS_ICON = new class_2960("soundcategories", "textures/gui/settings.png");

    public static Map<CategoryLoader, List<Field>> getCategories() {
        return FabricLoader.getInstance().getEntrypoints("sound-categories", CategoryLoader.class).stream().collect(Collectors.toMap(it -> it, SoundCategories::getRegistrations));
    }

    private static List<Field> getRegistrations(CategoryLoader loader) {
        return Arrays.stream(loader.getClass().getDeclaredFields()).filter(it -> it.isAnnotationPresent(CategoryLoader.Register.class)).toList();
    }

    public void onPreLaunch() {
        class_3419 init = class_3419.field_15250;
        Map<CategoryLoader, List<Field>> cats = SoundCategories.getCategories();
        for (CategoryLoader loader : cats.keySet()) {
            class_3419 master = null;
            for (Field f : cats.get(loader)) {
                CategoryLoader.Register annotation = f.getAnnotation(CategoryLoader.Register.class);
                try {
                    class_3419 category = (class_3419)f.get(loader);
                    if (annotation.master()) {
                        master = category;
                    } else if (master != null) {
                        parents.put(category, master);
                    }
                    if (annotation.defaultLevel() == 1.0f) continue;
                    defaultLevels.put(category, Float.valueOf(annotation.defaultLevel()));
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

