/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.betterdungeons.world.structure.spider_dungeon.piece;

import com.google.common.collect.Sets;
import com.yungnickyoung.minecraft.yungsapi.world.BlockStateRandomizer;
import java.util.BitSet;
import java.util.Random;
import java.util.Set;
import net.minecraft.class_1922;
import net.minecraft.class_1923;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_3341;
import net.minecraft.class_3443;
import net.minecraft.class_3773;
import net.minecraft.class_5281;

public abstract class SpiderDungeonPiece
extends class_3443 {
    protected static final Set<class_2248> BLOCK_BLACKLIST = Sets.newHashSet((Object[])new class_2248[]{class_2246.field_10201, class_2246.field_10446, class_2246.field_10260, class_2246.field_10034, class_2246.field_10098, class_2246.field_10539, class_2246.field_10503, class_2246.field_10035, class_2246.field_10335, class_2246.field_9988, class_2246.field_10479, class_2246.field_10214});

    protected SpiderDungeonPiece(class_3773 structurePieceTypeIn, int chainLength, class_3341 box) {
        super(structurePieceTypeIn, chainLength, box);
    }

    public SpiderDungeonPiece(class_3773 structurePierceTypeIn, class_2487 compoundTag) {
        super(structurePierceTypeIn, compoundTag);
    }

    protected void decorateCave(class_5281 world, Random decoRand, class_1923 chunkPos, class_3341 box, BitSet carvingMask) {
        carvingMask.stream().forEach(mask -> {
            if (decoRand.nextFloat() < 0.15f) {
                int globalZ;
                int x = mask & 0xF;
                int z = mask >> 4 & 0xF;
                int globalX = x + chunkPos.field_9181 * 16;
                int y = (mask >> 8) + world.method_31607();
                if ((this.method_14929((class_1922)world, globalX - 1, y, globalZ = z + chunkPos.field_9180 * 16, box).method_26225() || this.method_14929((class_1922)world, globalX + 1, y, globalZ, box).method_26225() || this.method_14929((class_1922)world, globalX, y, globalZ - 1, box).method_26225() || this.method_14929((class_1922)world, globalX, y, globalZ + 1, box).method_26225() || this.method_14929((class_1922)world, globalX, y - 1, globalZ, box).method_26225() || this.method_14929((class_1922)world, globalX, y + 1, globalZ, box).method_26225()) && !BLOCK_BLACKLIST.contains(this.method_14929((class_1922)world, globalX, y, globalZ, box).method_26204())) {
                    this.method_14917(world, class_2246.field_10343.method_9564(), globalX, y, globalZ, box);
                }
            }
        });
    }

    protected void placeSphereRandomized(class_5281 world, class_3341 box, class_2338 center, float radius, Random rand, float chance, BlockStateRandomizer blockSelector, boolean replaceOnlyAir) {
        for (float x = -radius; x <= radius; x += 1.0f) {
            for (float z = -radius; z <= radius; z += 1.0f) {
                for (float y = -radius; y <= radius; y += 1.0f) {
                    if (!(x * x + y * y + z * z < radius * radius) || replaceOnlyAir && !this.method_14929((class_1922)world, (int)x + center.method_10263(), (int)y + center.method_10264(), (int)z + center.method_10260(), box).method_26215() || !(rand.nextFloat() < chance)) continue;
                    this.method_14917(world, blockSelector.get(rand), (int)x + center.method_10263(), (int)y + center.method_10264(), (int)z + center.method_10260(), box);
                }
            }
        }
    }

    protected void placeSphereRandomized(class_5281 world, class_3341 box, int centerX, int centerY, int centerZ, float radius, Random rand, float chance, BlockStateRandomizer blockSelector, boolean replaceOnlyAir) {
        this.placeSphereRandomized(world, box, new class_2338(centerX, centerY, centerZ), radius, rand, chance, blockSelector, replaceOnlyAir);
    }

    protected void setBlockState(class_5281 worldIn, Random random, BlockStateRandomizer selector, int x, int y, int z, class_3341 boundingboxIn) {
        class_2680 blockState = selector.get(random);
        this.method_14917(worldIn, blockState, x, y, z, boundingboxIn);
    }

    protected static class_3341 getInitialBoundingBox(class_2338 startPos) {
        return new class_3341(startPos).method_35410(64);
    }
}

