/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.betterdungeons.world.processor.small_dungeon;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.yungnickyoung.minecraft.betterdungeons.BetterDungeonsCommon;
import com.yungnickyoung.minecraft.betterdungeons.module.StructureProcessorModule;
import com.yungnickyoung.minecraft.betterdungeons.world.DungeonContext;
import com.yungnickyoung.minecraft.betterdungeons.world.DungeonType;
import com.yungnickyoung.minecraft.yungsapi.world.banner.Banner;
import java.util.Random;
import net.minecraft.class_2185;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_3491;
import net.minecraft.class_3492;
import net.minecraft.class_3499;
import net.minecraft.class_3828;
import net.minecraft.class_4538;

public class SmallDungeonBannerProcessor
extends class_3491 {
    public static final Codec<SmallDungeonBannerProcessor> CODEC = RecordCodecBuilder.create(codecBuilder -> codecBuilder.group((App)Codec.STRING.fieldOf("dungeon_type").forGetter(smallDungeonBannerProcessor -> smallDungeonBannerProcessor.getDungeonType().getName())).apply((Applicative)codecBuilder, codecBuilder.stable(SmallDungeonBannerProcessor::new)));
    private final DungeonType dungeonType;
    public static final Banner SMALL_DUNGEON_SKELETON_BANNER = new Banner.Builder().blockState(class_2246.field_10537.method_9564()).pattern("cbo", 0).pattern("cs", 0).pattern("bs", 15).pattern("ts", 0).pattern("cre", 0).pattern("gra", 15).customName("betterdungeons.small_dungeon.banner.skeleton").customColor("dark_gray").build();
    public static final Banner SMALL_DUNGEON_ZOMBIE_BANNER = new Banner.Builder().blockState(class_2246.field_10279.method_9564()).pattern("bt", 6).pattern("mc", 7).pattern("gra", 15).pattern("tts", 0).pattern("bts", 0).pattern("bo", 13).customName("betterdungeons.small_dungeon.banner.zombie").customColor("dark_green").build();
    public static final Banner SMALL_DUNGEON_SPIDER_BANNER = new Banner.Builder().blockState(class_2246.field_10279.method_9564()).pattern("flo", 7).pattern("bo", 7).pattern("sc", 7).pattern("hh", 7).pattern("bs", 7).pattern("gra", 15).customName("betterdungeons.small_dungeon.banner.spider").customColor("dark_red").build();

    private SmallDungeonBannerProcessor(String dungeonType) {
        this.dungeonType = DungeonType.fromString(dungeonType);
    }

    public DungeonType getDungeonType() {
        return this.dungeonType;
    }

    public class_3499.class_3501 method_15110(class_4538 levelReader, class_2338 jigsawPiecePos, class_2338 jigsawPieceBottomCenterPos, class_3499.class_3501 blockInfoLocal, class_3499.class_3501 blockInfoGlobal, class_3492 structurePlacementData) {
        if (blockInfoGlobal.field_15596.method_26204() instanceof class_2185 && blockInfoGlobal.field_15596.method_26204() == class_2246.field_10279 && (blockInfoGlobal.field_15595.method_10580("Patterns") == null || blockInfoGlobal.field_15595.method_10554("Patterns", 10).size() == 0)) {
            DungeonContext context = DungeonContext.peek();
            if (context.getBannerCount() >= BetterDungeonsCommon.CONFIG.smallDungeons.bannerMaxCount) {
                return new class_3499.class_3501(blockInfoGlobal.field_15597, class_2246.field_10543.method_9564(), blockInfoGlobal.field_15595);
            }
            Random random = structurePlacementData.method_15115(blockInfoGlobal.field_15597);
            if (random.nextFloat() > 0.1f) {
                return new class_3499.class_3501(blockInfoGlobal.field_15597, class_2246.field_10543.method_9564(), blockInfoGlobal.field_15595);
            }
            Banner banner = this.getBannerForType();
            class_2350 facing = (class_2350)blockInfoGlobal.field_15596.method_11654((class_2769)class_2741.field_12481);
            class_2680 newState = (class_2680)banner.getState().method_11657((class_2769)class_2741.field_12481, (Comparable)facing);
            class_2487 newNBT = this.copyNBT(banner.getNbt());
            blockInfoGlobal = new class_3499.class_3501(blockInfoGlobal.field_15597, newState, newNBT);
            context.incrementBannerCount();
        }
        return blockInfoGlobal;
    }

    protected class_3828<?> method_16772() {
        return StructureProcessorModule.SMALL_DUNGEON_BANNER_PROCESSOR;
    }

    private Banner getBannerForType() {
        switch (this.dungeonType) {
            case SKELETON: {
                return SMALL_DUNGEON_SKELETON_BANNER;
            }
            case ZOMBIE: {
                return SMALL_DUNGEON_ZOMBIE_BANNER;
            }
            case SPIDER: {
                return SMALL_DUNGEON_SPIDER_BANNER;
            }
        }
        BetterDungeonsCommon.LOGGER.warn("Invalid DungeonType {} for BannerProcessor! This shouldn't happen!", (Object)this.dungeonType);
        return SMALL_DUNGEON_SKELETON_BANNER;
    }

    private class_2487 copyNBT(class_2487 other) {
        class_2487 nbt = new class_2487();
        nbt.method_10543(other);
        return nbt;
    }
}

