/*
 * Decompiled with CFR 0.152.
 */
package shaded.tukaani.xz.lz;

import shaded.tukaani.xz.ArrayCache;
import shaded.tukaani.xz.lz.CRC32Hash;
import shaded.tukaani.xz.lz.LZEncoder;

final class Hash234
extends CRC32Hash {
    private static final int HASH_2_SIZE = 1024;
    private static final int HASH_2_MASK = 1023;
    private static final int HASH_3_SIZE = 65536;
    private static final int HASH_3_MASK = 65535;
    private final int hash4Mask;
    private final int[] hash2Table;
    private final int[] hash3Table;
    private final int[] hash4Table;
    private final int hash4Size;
    private int hash2Value = 0;
    private int hash3Value = 0;
    private int hash4Value = 0;

    static int getHash4Size(int n) {
        int n2 = n - 1;
        n2 |= n2 >>> 1;
        n2 |= n2 >>> 2;
        n2 |= n2 >>> 4;
        n2 |= n2 >>> 8;
        n2 >>>= 1;
        if ((n2 |= 0xFFFF) > 0x1000000) {
            n2 >>>= 1;
        }
        return n2 + 1;
    }

    static int getMemoryUsage(int n) {
        return (66560 + Hash234.getHash4Size(n)) / 256 + 4;
    }

    Hash234(int n, ArrayCache arrayCache) {
        this.hash2Table = arrayCache.getIntArray(1024, true);
        this.hash3Table = arrayCache.getIntArray(65536, true);
        this.hash4Size = Hash234.getHash4Size(n);
        this.hash4Table = arrayCache.getIntArray(this.hash4Size, true);
        this.hash4Mask = this.hash4Size - 1;
    }

    void putArraysToCache(ArrayCache arrayCache) {
        arrayCache.putArray(this.hash4Table);
        arrayCache.putArray(this.hash3Table);
        arrayCache.putArray(this.hash2Table);
    }

    void calcHashes(byte[] byArray, int n) {
        int n2 = crcTable[byArray[n] & 0xFF] ^ byArray[n + 1] & 0xFF;
        this.hash2Value = n2 & 0x3FF;
        this.hash3Value = (n2 ^= (byArray[n + 2] & 0xFF) << 8) & 0xFFFF;
        this.hash4Value = (n2 ^= crcTable[byArray[n + 3] & 0xFF] << 5) & this.hash4Mask;
    }

    int getHash2Pos() {
        return this.hash2Table[this.hash2Value];
    }

    int getHash3Pos() {
        return this.hash3Table[this.hash3Value];
    }

    int getHash4Pos() {
        return this.hash4Table[this.hash4Value];
    }

    void updateTables(int n) {
        this.hash2Table[this.hash2Value] = n;
        this.hash3Table[this.hash3Value] = n;
        this.hash4Table[this.hash4Value] = n;
    }

    void normalize(int n) {
        LZEncoder.normalize(this.hash2Table, 1024, n);
        LZEncoder.normalize(this.hash3Table, 65536, n);
        LZEncoder.normalize(this.hash4Table, this.hash4Size, n);
    }
}

