/*
 * Decompiled with CFR 0.152.
 */
package shaded.tukaani.xz;

import java.io.InputStream;
import shaded.tukaani.xz.ArrayCache;
import shaded.tukaani.xz.FilterDecoder;
import shaded.tukaani.xz.LZMA2Coder;
import shaded.tukaani.xz.LZMA2InputStream;
import shaded.tukaani.xz.UnsupportedOptionsException;

class LZMA2Decoder
extends LZMA2Coder
implements FilterDecoder {
    private int dictSize;

    LZMA2Decoder(byte[] byArray) throws UnsupportedOptionsException {
        if (byArray.length != 1 || (byArray[0] & 0xFF) > 37) {
            throw new UnsupportedOptionsException("Unsupported LZMA2 properties");
        }
        this.dictSize = 2 | byArray[0] & 1;
        this.dictSize <<= (byArray[0] >>> 1) + 11;
    }

    @Override
    public int getMemoryUsage() {
        return LZMA2InputStream.getMemoryUsage(this.dictSize);
    }

    @Override
    public InputStream getInputStream(InputStream inputStream, ArrayCache arrayCache) {
        return new LZMA2InputStream(inputStream, this.dictSize, null, arrayCache);
    }
}

