/*
 * Decompiled with CFR 0.152.
 */
package forge.com.seibel.lod.common.wrappers.chunk;

import com.seibel.lod.core.util.LevelPosUtil;
import com.seibel.lod.core.wrapperInterfaces.block.AbstractBlockPosWrapper;
import com.seibel.lod.core.wrapperInterfaces.chunk.AbstractChunkPosWrapper;
import forge.com.seibel.lod.common.wrappers.block.BlockPosWrapper;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.ChunkPos;

public class ChunkPosWrapper
extends AbstractChunkPosWrapper {
    private final ChunkPos chunkPos;

    public ChunkPosWrapper() {
        this.chunkPos = new ChunkPos(0, 0);
    }

    public ChunkPosWrapper(BlockPos blockPos) {
        this.chunkPos = new ChunkPos(blockPos);
    }

    public ChunkPosWrapper(AbstractChunkPosWrapper newChunkPos) {
        this.chunkPos = ((ChunkPosWrapper)newChunkPos).chunkPos;
    }

    public ChunkPosWrapper(AbstractBlockPosWrapper blockPos) {
        this.chunkPos = new ChunkPos((BlockPos)((BlockPosWrapper)blockPos).getBlockPos());
    }

    public ChunkPosWrapper(int chunkX, int chunkZ) {
        this.chunkPos = new ChunkPos(chunkX, chunkZ);
    }

    public ChunkPosWrapper(long l) {
        this.chunkPos = new ChunkPos(l);
    }

    public ChunkPosWrapper(ChunkPos pos) {
        this.chunkPos = pos;
    }

    @Override
    public int getX() {
        return this.chunkPos.f_45578_;
    }

    @Override
    public int getZ() {
        return this.chunkPos.f_45579_;
    }

    @Override
    public int getMinBlockX() {
        return this.chunkPos.m_45604_();
    }

    @Override
    public int getMinBlockZ() {
        return this.chunkPos.m_45605_();
    }

    @Override
    public int getRegionX() {
        return LevelPosUtil.convert((byte)4, this.chunkPos.f_45578_, (byte)9);
    }

    @Override
    public int getRegionZ() {
        return LevelPosUtil.convert((byte)4, this.chunkPos.f_45579_, (byte)9);
    }

    @Override
    public long getLong() {
        return this.chunkPos.m_45588_();
    }

    public ChunkPos getChunkPos() {
        return this.chunkPos;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ChunkPosWrapper)) {
            return false;
        }
        ChunkPosWrapper c = (ChunkPosWrapper)o;
        return c.chunkPos.equals((Object)this.chunkPos);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.chunkPos);
    }

    @Override
    public AbstractBlockPosWrapper getWorldPosition() {
        BlockPos blockPos = this.chunkPos.m_151394_(0);
        return new BlockPosWrapper(blockPos.m_123341_(), blockPos.m_123342_(), blockPos.m_123343_());
    }
}

