/*
 * Decompiled with CFR 0.152.
 */
package fabric.com.seibel.lod.common;

import com.seibel.lod.core.config.ConfigAnnotations;
import com.seibel.lod.core.enums.config.BlocksToAvoid;
import com.seibel.lod.core.enums.config.BufferRebuildTimes;
import com.seibel.lod.core.enums.config.DistanceGenerationMode;
import com.seibel.lod.core.enums.config.DropoffQuality;
import com.seibel.lod.core.enums.config.GenerationPriority;
import com.seibel.lod.core.enums.config.GpuUploadMethod;
import com.seibel.lod.core.enums.config.HorizontalQuality;
import com.seibel.lod.core.enums.config.HorizontalResolution;
import com.seibel.lod.core.enums.config.LightGenerationMode;
import com.seibel.lod.core.enums.config.LoggerMode;
import com.seibel.lod.core.enums.config.ServerFolderNameMode;
import com.seibel.lod.core.enums.config.VanillaOverdraw;
import com.seibel.lod.core.enums.config.VerticalQuality;
import com.seibel.lod.core.enums.rendering.DebugMode;
import com.seibel.lod.core.enums.rendering.FogColorMode;
import com.seibel.lod.core.enums.rendering.FogDistance;
import com.seibel.lod.core.enums.rendering.FogDrawMode;
import com.seibel.lod.core.enums.rendering.FogSetting;
import com.seibel.lod.core.enums.rendering.HeightFogMixMode;
import com.seibel.lod.core.enums.rendering.HeightFogMode;
import com.seibel.lod.core.enums.rendering.RendererType;
import com.seibel.lod.core.wrapperInterfaces.config.ILodConfigWrapperSingleton;

public class Config {
    @ConfigAnnotations.ScreenEntry
    public static Client client;
    @ConfigAnnotations.FileComment
    public static String _optionsButton;
    @ConfigAnnotations.Entry
    public static boolean optionsButton;

    static {
        _optionsButton = " Show the lod button in the options screen next to fov";
        optionsButton = true;
    }

    public static class Client {
        @ConfigAnnotations.ScreenEntry
        public static Graphics graphics;
        @ConfigAnnotations.ScreenEntry
        public static WorldGenerator worldGenerator;
        @ConfigAnnotations.ScreenEntry
        public static Multiplayer multiplayer;
        @ConfigAnnotations.ScreenEntry
        public static Advanced advanced;

        public static class Advanced {
            @ConfigAnnotations.ScreenEntry
            public static Threading threading;
            @ConfigAnnotations.ScreenEntry
            public static Debugging debugging;
            @ConfigAnnotations.ScreenEntry
            public static Buffers buffers;
            @ConfigAnnotations.FileComment
            public static String _lodOnlyMode;
            @ConfigAnnotations.Entry
            public static boolean lodOnlyMode;

            static {
                _lodOnlyMode = " Due to some demand for playing without vanilla terrains, \n we decided to add this mode for fun. \n\n NOTE: Do not report any issues when this mode is on! \n   Again, this setting is only for fun, and mod \n   compatibility is not guaranteed. \n\n";
                lodOnlyMode = false;
            }

            public static class Buffers {
                @ConfigAnnotations.FileComment
                public static String _gpuUploadMethod = ILodConfigWrapperSingleton.IClient.IAdvanced.IBuffers.GPU_UPLOAD_METHOD_DESC;
                @ConfigAnnotations.Entry
                public static GpuUploadMethod gpuUploadMethod = ILodConfigWrapperSingleton.IClient.IAdvanced.IBuffers.GPU_UPLOAD_METHOD_DEFAULT;
                @ConfigAnnotations.FileComment
                public static String _gpuUploadPerMegabyteInMilliseconds = " How long should a buffer wait per Megabyte of data uploaded?\n Helpful resource for frame times: https://fpstoms.com \n\n Longer times may reduce stuttering but will make fake chunks \n transition and load slower. Change this to [0] for no timeout.\n\n NOTE:\n Before changing this config, try changing \"GPU Upload methods\"\n  and determined the best method for your hardware first. \n";
                @ConfigAnnotations.Entry(minValue=0.0, maxValue=50.0)
                public static int gpuUploadPerMegabyteInMilliseconds = (Integer)ILodConfigWrapperSingleton.IClient.IAdvanced.IBuffers.GPU_UPLOAD_PER_MEGABYTE_IN_MILLISECONDS_DEFAULT.defaultValue;
                @ConfigAnnotations.FileComment
                public static String _rebuildTimes = " How frequently should vertex buffers (geometry) be rebuilt and sent to the GPU? \n Higher settings may cause stuttering, but will prevent holes in the world \n";
                @ConfigAnnotations.Entry
                public static BufferRebuildTimes rebuildTimes = ILodConfigWrapperSingleton.IClient.IAdvanced.IBuffers.REBUILD_TIMES_DEFAULT;
            }

            public static class Debugging {
                @ConfigAnnotations.FileComment
                public static String _rendererType = ILodConfigWrapperSingleton.IClient.IAdvanced.IDebugging.RENDERER_TYPE_DESC;
                @ConfigAnnotations.Entry
                public static RendererType rendererType = ILodConfigWrapperSingleton.IClient.IAdvanced.IDebugging.RENDERER_TYPE_DEFAULT;
                @ConfigAnnotations.FileComment
                public static String _debugMode = ILodConfigWrapperSingleton.IClient.IAdvanced.IDebugging.DEBUG_MODE_DESC;
                @ConfigAnnotations.Entry
                public static DebugMode debugMode = ILodConfigWrapperSingleton.IClient.IAdvanced.IDebugging.DEBUG_MODE_DEFAULT;
                @ConfigAnnotations.FileComment
                public static String _enableDebugKeybindings = " If true the F8 key can be used to cycle through the different debug modes. \n and the F6 key can be used to enable and disable LOD rendering.";
                @ConfigAnnotations.Entry
                public static boolean enableDebugKeybindings = false;
                @ConfigAnnotations.ScreenEntry
                public static DebugSwitch debugSwitch;

                public static class DebugSwitch {
                    @ConfigAnnotations.FileComment
                    public static String _logWorldGenEvent = " If enabled, the mod will log information about the world generation process. \n This can be useful for debugging. \n";
                    @ConfigAnnotations.Entry
                    public static LoggerMode logWorldGenEvent = ILodConfigWrapperSingleton.IClient.IAdvanced.IDebugging.IDebugSwitch.LOG_WORLDGEN_EVENT_DEFAULT;
                    @ConfigAnnotations.FileComment
                    public static String _logWorldGenPerformance = " If enabled, the mod will log performance about the world generation process. \n This can be useful for debugging. \n";
                    @ConfigAnnotations.Entry
                    public static LoggerMode logWorldGenPerformance = ILodConfigWrapperSingleton.IClient.IAdvanced.IDebugging.IDebugSwitch.LOG_WORLDGEN_PERFORMANCE_DEFAULT;
                    @ConfigAnnotations.FileComment
                    public static String _logWorldGenLoadEvent = " If enabled, the mod will log information about the world generation process. \n This can be useful for debugging. \n";
                    @ConfigAnnotations.Entry
                    public static LoggerMode logWorldGenLoadEvent = ILodConfigWrapperSingleton.IClient.IAdvanced.IDebugging.IDebugSwitch.LOG_WORLDGEN_LOAD_EVENT_DEFAULT;
                    @ConfigAnnotations.FileComment
                    public static String _logLodBuilderEvent = " If enabled, the mod will log information about the LOD generation process. \n This can be useful for debugging. \n";
                    @ConfigAnnotations.Entry
                    public static LoggerMode logLodBuilderEvent = ILodConfigWrapperSingleton.IClient.IAdvanced.IDebugging.IDebugSwitch.LOG_LODBUILDER_EVENT_DEFAULT;
                    @ConfigAnnotations.FileComment
                    public static String _logRendererBufferEvent = " If enabled, the mod will log information about the renderer buffer process. \n This can be useful for debugging. \n";
                    @ConfigAnnotations.Entry
                    public static LoggerMode logRendererBufferEvent = ILodConfigWrapperSingleton.IClient.IAdvanced.IDebugging.IDebugSwitch.LOG_RENDERER_BUFFER_EVENT_DEFAULT;
                    @ConfigAnnotations.FileComment
                    public static String _logRendererGLEvent = " If enabled, the mod will log information about the renderer OpenGL process. \n This can be useful for debugging. \n";
                    @ConfigAnnotations.Entry
                    public static LoggerMode logRendererGLEvent = ILodConfigWrapperSingleton.IClient.IAdvanced.IDebugging.IDebugSwitch.LOG_RENDERER_GL_EVENT_DEFAULT;
                    @ConfigAnnotations.FileComment
                    public static String _logFileReadWriteEvent = " If enabled, the mod will log information about file read/write operations. \n This can be useful for debugging. \n";
                    @ConfigAnnotations.Entry
                    public static LoggerMode logFileReadWriteEvent = ILodConfigWrapperSingleton.IClient.IAdvanced.IDebugging.IDebugSwitch.LOG_FILE_READWRITE_EVENT_DEFAULT;
                    @ConfigAnnotations.FileComment
                    public static String _logFileSubDimEvent = " If enabled, the mod will log information about file sub-dimension operations. \n This can be useful for debugging. \n";
                    @ConfigAnnotations.Entry
                    public static LoggerMode logFileSubDimEvent = ILodConfigWrapperSingleton.IClient.IAdvanced.IDebugging.IDebugSwitch.LOG_FILE_SUB_DIM_EVENT_DEFAULT;
                    @ConfigAnnotations.FileComment
                    public static String _logNetworkEvent = " If enabled, the mod will log information about network operations. \n This can be useful for debugging. \n";
                    @ConfigAnnotations.Entry
                    public static LoggerMode logNetworkEvent = ILodConfigWrapperSingleton.IClient.IAdvanced.IDebugging.IDebugSwitch.LOG_NETWORK_EVENT_DEFAULT;
                }
            }

            public static class Threading {
                @ConfigAnnotations.FileComment
                public static String _numberOfWorldGenerationThreads = " How many threads should be used when generating fake \n chunks outside the normal render distance? \n\n If it's less than 1, it will be treated as a percentage \n of time single thread can run before going to idle. \n\n If you experience stuttering when generating distant LODs, \n decrease  this number. If you want to increase LOD \n generation speed, increase this number. \n\n This and the number of buffer builder threads are independent, \n so if they add up to more threads than your CPU has cores, \n that shouldn't cause an issue. \n";
                @ConfigAnnotations.Entry(minValue=0.1, maxValue=50.0)
                public static double numberOfWorldGenerationThreads = (Double)ILodConfigWrapperSingleton.IClient.IAdvanced.IThreading.NUMBER_OF_WORLD_GENERATION_THREADS_DEFAULT.defaultValue;
                @ConfigAnnotations.FileComment
                public static String _numberOfBufferBuilderThreads = " How many threads are used when building vertex buffers? \n (The things sent to your GPU to draw the fake chunks). \n\n If you experience high CPU usage when NOT generating distant \n fake chunks, lower this number. A higher number will make fake\n fake chunks' transition faster when moving around the world. \n\n This and the number of world generator threads are independent, \n so if they add up to more threads than your CPU has cores, \n that shouldn't cause an issue. \n\n The maximum value is the number of logical processors on your CPU. \n";
                @ConfigAnnotations.Entry(minValue=1.0, maxValue=50.0)
                public static int numberOfBufferBuilderThreads = (Integer)ILodConfigWrapperSingleton.IClient.IAdvanced.IThreading.NUMBER_OF_BUFFER_BUILDER_THREADS_MIN_DEFAULT_MAX.defaultValue;
            }
        }

        public static class Multiplayer {
            @ConfigAnnotations.FileComment
            public static String _serverFolderNameMode = ILodConfigWrapperSingleton.IClient.IMultiplayer.SERVER_FOLDER_NAME_MODE_DESC;
            @ConfigAnnotations.Entry
            public static ServerFolderNameMode serverFolderNameMode = ILodConfigWrapperSingleton.IClient.IMultiplayer.SERVER_FOLDER_NAME_MODE_DEFAULT;
            @ConfigAnnotations.FileComment
            public static String _multiDimensionRequiredSimilarity = " When matching worlds of the same dimension type the \n tested chunks must be at least this percent the same \n in order to be considered the same world. \n\n Note: If you use portals to enter a dimension at two \n different locations this system may think it is two different worlds. \n\n 1.0 (100%) the chunks must be identical. \n 0.5 (50%)  the chunks must be half the same. \n 0.0 (0%)   disables multi-dimension support, \n            only one world will be used per dimension. \n\n";
            @ConfigAnnotations.Entry(minValue=0.0, maxValue=1.0)
            public static double multiDimensionRequiredSimilarity = (Double)ILodConfigWrapperSingleton.IClient.IMultiplayer.MULTI_DIMENSION_REQUIRED_SIMILARITY_MIN_DEFAULT_MAX.defaultValue;
        }

        public static class WorldGenerator {
            @ConfigAnnotations.FileComment
            public static String _enableDistantGeneration = " Whether to enable Distant chunks generator? \n\n Turning this on allows Distant Horizons to make lods for chunks \n that are outside of vanilla view distance. \n\n Note that in server, distant generation is always off. \n";
            @ConfigAnnotations.Entry
            public static boolean enableDistantGeneration = true;
            @ConfigAnnotations.Entry
            public static DistanceGenerationMode distanceGenerationMode = ILodConfigWrapperSingleton.IClient.IWorldGenerator.DISTANCE_GENERATION_MODE_DEFAULT;
            @ConfigAnnotations.FileComment
            public static String _lightGenerationMode = ILodConfigWrapperSingleton.IClient.IWorldGenerator.LIGHT_GENERATION_MODE_DESC;
            @ConfigAnnotations.Entry
            public static LightGenerationMode lightGenerationMode = ILodConfigWrapperSingleton.IClient.IWorldGenerator.LIGHT_GENERATION_MODE_DEFAULT;
            @ConfigAnnotations.FileComment
            public static String _generationPriority = ILodConfigWrapperSingleton.IClient.IWorldGenerator.GENERATION_PRIORITY_DESC;
            @ConfigAnnotations.Entry
            public static GenerationPriority generationPriority = ILodConfigWrapperSingleton.IClient.IWorldGenerator.GENERATION_PRIORITY_DEFAULT;
            @ConfigAnnotations.FileComment
            public static String _blocksToAvoid = ILodConfigWrapperSingleton.IClient.IWorldGenerator.BLOCKS_TO_AVOID_DESC;
            @ConfigAnnotations.Entry
            public static BlocksToAvoid blocksToAvoid = ILodConfigWrapperSingleton.IClient.IWorldGenerator.BLOCKS_TO_AVOID_DEFAULT;
        }

        public static class Graphics {
            @ConfigAnnotations.ScreenEntry
            public static Quality quality;
            @ConfigAnnotations.ScreenEntry
            public static FogQuality fogQuality;
            @ConfigAnnotations.ScreenEntry
            public static AdvancedGraphics advancedGraphics;

            public static class AdvancedGraphics {
                @ConfigAnnotations.FileComment
                public static String _disableDirectionalCulling = " If false fake chunks behind the player's camera \n aren't drawn, increasing GPU performance. \n\n If true all LODs are drawn, even those behind \n the player's camera, decreasing GPU performance. \n\n Disable this if you see LODs disappearing at the corners of your vision. \n";
                @ConfigAnnotations.Entry
                public static boolean disableDirectionalCulling = false;
                @ConfigAnnotations.FileComment
                public static String _vanillaOverdraw = ILodConfigWrapperSingleton.IClient.IGraphics.IAdvancedGraphics.VANILLA_OVERDRAW_DESC;
                @ConfigAnnotations.Entry
                public static VanillaOverdraw vanillaOverdraw = ILodConfigWrapperSingleton.IClient.IGraphics.IAdvancedGraphics.VANILLA_OVERDRAW_DEFAULT;
                @ConfigAnnotations.FileComment
                public static String _overdrawOffset = " If on Vanilla Overdraw mode of NEVER, how much should should the border be offset? \n\n  '1': The start of lods will be shifted inwards by 1 chunk, causing 1 chunk of overdraw. \n '-1': The start fo lods will be shifted outwards by 1 chunk, causing 1 chunk of gap. \n\n This setting can be used to deal with gaps due to our vanilla rendered chunk \n   detection not being perfect. \n";
                @ConfigAnnotations.Entry(minValue=-16.0, maxValue=16.0)
                public static int overdrawOffset = (Integer)ILodConfigWrapperSingleton.IClient.IGraphics.IAdvancedGraphics.OVERDRAW_OFFSET_MIN_DEFAULT_MAX.defaultValue;
                @ConfigAnnotations.FileComment
                public static String _useExtendedNearClipPlane = " Will prevent some overdraw issues, but may cause nearby fake chunks to render incorrectly \n especially when in/near an ocean. \n\n This setting shouldn't affect performance. \n";
                @ConfigAnnotations.Entry
                public static boolean useExtendedNearClipPlane = true;
                @ConfigAnnotations.FileComment
                public static String _brightnessMultiplier = " How bright fake chunk colors are. \n\n 0 = black \n 1 = normal \n 2 = near white \n";
                @ConfigAnnotations.Entry
                public static double brightnessMultiplier = 1.0;
                @ConfigAnnotations.FileComment
                public static String _saturationMultiplier = " How saturated fake chunk colors are. \n\n 0 = black and white \n 1 = normal \n 2 = very saturated \n";
                @ConfigAnnotations.Entry
                public static double saturationMultiplier = 1.0;
                @ConfigAnnotations.FileComment
                public static String _enableCaveCulling = " If enabled caves will be culled \n\n NOTE: This feature is under development and \n  it is VERY experimental! Please don't report \n any issues related to this feature. \n\n Additional Info: Currently this cull all faces \n  with skylight value of 0 in dimensions that \n  does not have a ceiling. \n";
                @ConfigAnnotations.Entry
                public static boolean enableCaveCulling = true;
                @ConfigAnnotations.FileComment
                public static String _caveCullingHeight = " At what Y value should cave culling start? \n";
                @ConfigAnnotations.Entry(minValue=-4096.0, maxValue=4096.0)
                public static int caveCullingHeight = (Integer)ILodConfigWrapperSingleton.IClient.IGraphics.IAdvancedGraphics.CAVE_CULLING_HEIGHT_MIN_DEFAULT_MAX.defaultValue;
                @ConfigAnnotations.FileComment
                public static String _earthCurveRatio = " This is the earth size ratio when applying the curvature shader effect. \n\n NOTE: This feature is just for fun and is VERY experimental! \nPlease don't report any issues related to this feature. \n\n 0 = flat/disabled \n 1 = 1 to 1 (6,371,000 blocks) \n 100 = 1 to 100 (63,710 blocks) \n 10000 = 1 to 10000 (637.1 blocks) \n\n NOTE: Due to current limitations, the min value is 50 \n and the max value is 5000. Any values outside this range \n will be set to 0(disabled).";
                @ConfigAnnotations.Entry(minValue=0.0, maxValue=5000.0)
                public static int earthCurveRatio = (Integer)ILodConfigWrapperSingleton.IClient.IGraphics.IAdvancedGraphics.EARTH_CURVE_RATIO_MIN_DEFAULT_MAX.defaultValue;
            }

            public static class FogQuality {
                @ConfigAnnotations.FileComment
                public static String _fogDistance = " At what distance should Fog be drawn on the fake chunks? \n\n This setting shouldn't affect performance.";
                @ConfigAnnotations.Entry
                public static FogDistance fogDistance = ILodConfigWrapperSingleton.IClient.IGraphics.IFogQuality.FOG_DISTANCE_DEFAULT;
                @ConfigAnnotations.FileComment
                public static String _fogDrawMode = ILodConfigWrapperSingleton.IClient.IGraphics.IFogQuality.FOG_DRAW_MODE_DESC;
                @ConfigAnnotations.Entry
                public static FogDrawMode fogDrawMode = ILodConfigWrapperSingleton.IClient.IGraphics.IFogQuality.FOG_DRAW_MODE_DEFAULT;
                @ConfigAnnotations.FileComment
                public static String _fogColorMode = ILodConfigWrapperSingleton.IClient.IGraphics.IFogQuality.FOG_COLOR_MODE_DESC;
                @ConfigAnnotations.Entry
                public static FogColorMode fogColorMode = ILodConfigWrapperSingleton.IClient.IGraphics.IFogQuality.FOG_COLOR_MODE_DEFAULT;
                @ConfigAnnotations.FileComment
                public static String _disableVanillaFog = " If true disable Minecraft's fog. \n\n Experimental! Mod support is not guarantee.";
                @ConfigAnnotations.Entry
                public static boolean disableVanillaFog = true;
                @ConfigAnnotations.ScreenEntry
                public static AdvancedFog advancedFog;

                public static class AdvancedFog {
                    static final double SQRT2 = 1.4142135623730951;
                    @ConfigAnnotations.FileComment
                    public static String _farFogStart = " Where should the far fog start? \n\n   '0.0': Fog start at player's position.\n   '1.0': The fog-start's circle fit just in the lod render distance square.\n '1.414': The lod render distance square fit just in the fog-start's circle.\n";
                    @ConfigAnnotations.Entry(minValue=0.0, maxValue=1.4142135623730951)
                    public static double farFogStart = (Double)ILodConfigWrapperSingleton.IClient.IGraphics.IFogQuality.IAdvancedFog.FAR_FOG_START_MIN_DEFAULT_MAX.defaultValue;
                    @ConfigAnnotations.FileComment
                    public static String _farFogEnd = " Where should the far fog end? \n\n   '0.0': Fog end at player's position.\n   '1.0': The fog-end's circle fit just in the lod render distance square.\n '1.414': The lod render distance square fit just in the fog-end's circle.\n";
                    @ConfigAnnotations.Entry(minValue=0.0, maxValue=1.4142135623730951)
                    public static double farFogEnd = (Double)ILodConfigWrapperSingleton.IClient.IGraphics.IFogQuality.IAdvancedFog.FAR_FOG_END_MIN_DEFAULT_MAX.defaultValue;
                    @ConfigAnnotations.FileComment
                    public static String _farFogMin = " What is the minimum fog thickness? \n\n   '0.0': No fog at all.\n   '1.0': Fully fog color.\n";
                    @ConfigAnnotations.Entry(minValue=-5.0, maxValue=1.4142135623730951)
                    public static double farFogMin = (Double)ILodConfigWrapperSingleton.IClient.IGraphics.IFogQuality.IAdvancedFog.FAR_FOG_MIN_MIN_DEFAULT_MAX.defaultValue;
                    @ConfigAnnotations.FileComment
                    public static String _farFogMax = " What is the maximum fog thickness? \n\n   '0.0': No fog at all.\n   '1.0': Fully fog color.\n";
                    @ConfigAnnotations.Entry(minValue=0.0, maxValue=5.0)
                    public static double farFogMax = (Double)ILodConfigWrapperSingleton.IClient.IGraphics.IFogQuality.IAdvancedFog.FAR_FOG_MAX_MIN_DEFAULT_MAX.defaultValue;
                    @ConfigAnnotations.FileComment
                    public static String _farFogType = ILodConfigWrapperSingleton.IClient.IGraphics.IFogQuality.IAdvancedFog.FAR_FOG_TYPE_DESC;
                    @ConfigAnnotations.Entry
                    public static FogSetting.FogType farFogType = ILodConfigWrapperSingleton.IClient.IGraphics.IFogQuality.IAdvancedFog.FAR_FOG_TYPE_DEFAULT;
                    @ConfigAnnotations.FileComment
                    public static String _farFogDensity = " What is the fog density? \n";
                    @ConfigAnnotations.Entry(minValue=0.01, maxValue=50.0)
                    public static double farFogDensity = (Double)ILodConfigWrapperSingleton.IClient.IGraphics.IFogQuality.IAdvancedFog.FAR_FOG_DENSITY_MIN_DEFAULT_MAX.defaultValue;
                    @ConfigAnnotations.ScreenEntry
                    public static HeightFog heightFog;

                    public static class HeightFog {
                        @ConfigAnnotations.FileComment
                        public static String _heightFogMixMode = ILodConfigWrapperSingleton.IClient.IGraphics.IFogQuality.IAdvancedFog.IHeightFog.HEIGHT_FOG_MIX_MODE_DESC;
                        @ConfigAnnotations.Entry
                        public static HeightFogMixMode heightFogMixMode = ILodConfigWrapperSingleton.IClient.IGraphics.IFogQuality.IAdvancedFog.IHeightFog.HEIGHT_FOG_MIX_MODE_DEFAULT;
                        @ConfigAnnotations.FileComment
                        public static String _heightFogMode = ILodConfigWrapperSingleton.IClient.IGraphics.IFogQuality.IAdvancedFog.IHeightFog.HEIGHT_FOG_MODE_DESC;
                        @ConfigAnnotations.Entry
                        public static HeightFogMode heightFogMode = ILodConfigWrapperSingleton.IClient.IGraphics.IFogQuality.IAdvancedFog.IHeightFog.HEIGHT_FOG_MODE_DEFAULT;
                        @ConfigAnnotations.FileComment
                        public static String _heightFogHeight = " If the height fog is calculated around a set height, what is that height position? \n\n";
                        @ConfigAnnotations.Entry(minValue=-4096.0, maxValue=4096.0)
                        public static double heightFogHeight = (Double)ILodConfigWrapperSingleton.IClient.IGraphics.IFogQuality.IAdvancedFog.IHeightFog.HEIGHT_FOG_HEIGHT_MIN_DEFAULT_MAX.defaultValue;
                        @ConfigAnnotations.FileComment
                        public static String _heightFogStart = " How far the start of height fog should offset? \n\n   '0.0': Fog start with no offset.\n   '1.0': Fog start with offset of the entire world's height. (Include depth)\n";
                        @ConfigAnnotations.Entry(minValue=0.0, maxValue=1.4142135623730951)
                        public static double heightFogStart = (Double)ILodConfigWrapperSingleton.IClient.IGraphics.IFogQuality.IAdvancedFog.IHeightFog.HEIGHT_FOG_START_MIN_DEFAULT_MAX.defaultValue;
                        @ConfigAnnotations.FileComment
                        public static String _heightFogEnd = " How far the end of height fog should offset? \n\n   '0.0': Fog end with no offset.\n   '1.0': Fog end with offset of the entire world's height. (Include depth)\n";
                        @ConfigAnnotations.Entry(minValue=0.0, maxValue=1.4142135623730951)
                        public static double heightFogEnd = (Double)ILodConfigWrapperSingleton.IClient.IGraphics.IFogQuality.IAdvancedFog.IHeightFog.HEIGHT_FOG_END_MIN_DEFAULT_MAX.defaultValue;
                        @ConfigAnnotations.FileComment
                        public static String _heightFogMin = " What is the minimum fog thickness? \n\n   '0.0': No fog at all.\n   '1.0': Fully fog color.\n";
                        @ConfigAnnotations.Entry(minValue=-5.0, maxValue=1.4142135623730951)
                        public static double heightFogMin = (Double)ILodConfigWrapperSingleton.IClient.IGraphics.IFogQuality.IAdvancedFog.IHeightFog.HEIGHT_FOG_MIN_MIN_DEFAULT_MAX.defaultValue;
                        @ConfigAnnotations.FileComment
                        public static String _heightFogMax = " What is the maximum fog thickness? \n\n   '0.0': No fog at all.\n   '1.0': Fully fog color.\n";
                        @ConfigAnnotations.Entry(minValue=0.0, maxValue=5.0)
                        public static double heightFogMax = (Double)ILodConfigWrapperSingleton.IClient.IGraphics.IFogQuality.IAdvancedFog.IHeightFog.HEIGHT_FOG_MAX_MIN_DEFAULT_MAX.defaultValue;
                        @ConfigAnnotations.FileComment
                        public static String _heightFogType = ILodConfigWrapperSingleton.IClient.IGraphics.IFogQuality.IAdvancedFog.IHeightFog.HEIGHT_FOG_TYPE_DESC;
                        @ConfigAnnotations.Entry
                        public static FogSetting.FogType heightFogType = ILodConfigWrapperSingleton.IClient.IGraphics.IFogQuality.IAdvancedFog.IHeightFog.HEIGHT_FOG_TYPE_DEFAULT;
                        @ConfigAnnotations.FileComment
                        public static String _heightFogDensity = " What is the fog density? \n";
                        @ConfigAnnotations.Entry(minValue=0.01, maxValue=50.0)
                        public static double heightFogDensity = (Double)ILodConfigWrapperSingleton.IClient.IGraphics.IFogQuality.IAdvancedFog.IHeightFog.HEIGHT_FOG_DENSITY_MIN_DEFAULT_MAX.defaultValue;
                    }
                }
            }

            public static class Quality {
                @ConfigAnnotations.FileComment
                public static String _drawResolution = ILodConfigWrapperSingleton.IClient.IGraphics.IQuality.DRAW_RESOLUTION_DESC;
                @ConfigAnnotations.Entry
                public static HorizontalResolution drawResolution = ILodConfigWrapperSingleton.IClient.IGraphics.IQuality.DRAW_RESOLUTION_DEFAULT;
                @ConfigAnnotations.FileComment
                public static String _lodChunkRenderDistance = " The radius of the mod's render distance. (measured in chunks) \n";
                @ConfigAnnotations.Entry(minValue=32.0, maxValue=2048.0)
                public static int lodChunkRenderDistance = (Integer)ILodConfigWrapperSingleton.IClient.IGraphics.IQuality.LOD_CHUNK_RENDER_DISTANCE_MIN_DEFAULT_MAX.defaultValue;
                @ConfigAnnotations.FileComment
                public static String _verticalQuality = ILodConfigWrapperSingleton.IClient.IGraphics.IQuality.VERTICAL_QUALITY_DESC;
                @ConfigAnnotations.Entry
                public static VerticalQuality verticalQuality = ILodConfigWrapperSingleton.IClient.IGraphics.IQuality.VERTICAL_QUALITY_DEFAULT;
                @ConfigAnnotations.FileComment
                public static String _horizontalScale = " This indicates how quickly fake chunks decrease in quality the further away they are. \n Higher settings will render higher quality fake chunks farther away, \n but will increase memory and GPU usage.";
                @ConfigAnnotations.Entry(minValue=2.0, maxValue=64.0)
                public static int horizontalScale = (Integer)ILodConfigWrapperSingleton.IClient.IGraphics.IQuality.HORIZONTAL_SCALE_MIN_DEFAULT_MAX.defaultValue;
                @ConfigAnnotations.FileComment
                public static String _horizontalQuality = " This indicates how quickly fake chunks decrease in quality the further away they are. \n Higher settings will render higher quality fake chunks farther away, \n but will increase memory and GPU usage.";
                @ConfigAnnotations.Entry
                public static HorizontalQuality horizontalQuality = ILodConfigWrapperSingleton.IClient.IGraphics.IQuality.HORIZONTAL_QUALITY_DEFAULT;
                @ConfigAnnotations.FileComment
                public static String _dropoffQuality = ILodConfigWrapperSingleton.IClient.IGraphics.IQuality.DROPOFF_QUALITY_DESC;
                @ConfigAnnotations.Entry
                public static DropoffQuality dropoffQuality = ILodConfigWrapperSingleton.IClient.IGraphics.IQuality.DROPOFF_QUALITY_DEFAULT;
                @ConfigAnnotations.FileComment
                public static String _lodBiomeBlending = " This is the same as vanilla Biome Blending settings for Lod area. \n     Note that anything other than '0' will greatly effect Lod building time \n     and increase triangle count. The cost on chunk generation speed is also \n     quite large if set too high.\n\n     '0' equals to Vanilla Biome Blending of '1x1' or 'OFF', \n     '1' equals to Vanilla Biome Blending of '3x3', \n     '2' equals to Vanilla Biome Blending of '5x5'... \n";
                @ConfigAnnotations.Entry(minValue=0.0, maxValue=7.0)
                public static int lodBiomeBlending = (Integer)ILodConfigWrapperSingleton.IClient.IGraphics.IQuality.LOD_BIOME_BLENDING_MIN_DEFAULT_MAX.defaultValue;
            }
        }
    }
}

