/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.lod.forge;

import com.seibel.lod.core.api.ApiShared;
import com.seibel.lod.core.handlers.ReflectionHandler;
import com.seibel.lod.core.handlers.dependencyInjection.ModAccessorHandler;
import com.seibel.lod.core.wrapperInterfaces.modAccessor.IOptifineAccessor;
import com.seibel.lod.forge.ForgeClientProxy;
import com.seibel.lod.forge.wrappers.ForgeDependencySetup;
import com.seibel.lod.forge.wrappers.modAccessor.OptifineAccessor;
import forge.com.seibel.lod.common.LodCommonMain;
import forge.com.seibel.lod.common.forge.LodForgeMethodCaller;
import forge.com.seibel.lod.common.wrappers.config.ConfigGui;
import forge.com.seibel.lod.common.wrappers.minecraft.MinecraftClientWrapper;
import java.util.List;
import java.util.Random;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.core.Direction;
import net.minecraft.world.level.ColorResolver;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.ConfigGuiHandler;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.client.model.data.ModelDataMap;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLLoader;

@Mod(value="lod")
public class ForgeMain
implements LodForgeMethodCaller {
    public static ForgeClientProxy forgeClientProxy;
    private final ModelDataMap dataMap = new ModelDataMap.Builder().build();

    private void init(FMLCommonSetupEvent event) {
        LodCommonMain.initConfig();
        LodCommonMain.startup(this, !FMLLoader.getDist().isClient());
        ForgeDependencySetup.createInitialBindings();
        ForgeDependencySetup.finishBinding();
        ApiShared.LOGGER.info("Distant Horizons initializing...");
    }

    public ForgeMain() {
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::init);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::onClientStart);
    }

    private void onClientStart(FMLClientSetupEvent event) {
        if (ReflectionHandler.instance.optifinePresent()) {
            ModAccessorHandler.bind(IOptifineAccessor.class, new OptifineAccessor());
        }
        ModAccessorHandler.finishBinding();
        ModLoadingContext.get().registerExtensionPoint(ConfigGuiHandler.ConfigGuiFactory.class, () -> new ConfigGuiHandler.ConfigGuiFactory((client, parent) -> ConfigGui.getScreen(parent, "")));
        forgeClientProxy = new ForgeClientProxy();
        MinecraftForge.EVENT_BUS.register((Object)forgeClientProxy);
    }

    @Override
    public List<BakedQuad> getQuads(MinecraftClientWrapper mc, Block block, BlockState blockState, Direction direction, Random random) {
        return mc.getModelManager().m_119430_().m_110893_(block.m_49966_()).getQuads(blockState, direction, random, (IModelData)this.dataMap);
    }

    @Override
    public int colorResolverGetColor(ColorResolver resolver, Biome biome, double x, double z) {
        return resolver.m_130045_(biome, x, z);
    }
}

