/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.lod.core.util.gridList;

import com.seibel.lod.core.objects.Pos2D;
import java.util.ArrayList;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;

public class ArrayGridList<T>
extends ArrayList<T> {
    public final int gridSize;

    public ArrayGridList(int gridSize, BiFunction<Integer, Integer, T> filler) {
        super(gridSize * gridSize);
        this.gridSize = gridSize;
        this.forEachPos((x, y) -> super.add(filler.apply((Integer)x, (Integer)y)));
    }

    public ArrayGridList(int gridSize) {
        this(gridSize, (x, y) -> null);
    }

    public ArrayGridList(ArrayGridList<T> copy) {
        super(copy);
        this.gridSize = copy.gridSize;
    }

    public ArrayGridList(ArrayGridList<T> from, int minR, int maxR) {
        super(maxR - minR);
        if (minR > maxR) {
            throw new IndexOutOfBoundsException("minR greater than maxR");
        }
        if (minR < 0) {
            throw new IndexOutOfBoundsException("minR less than 0");
        }
        if (maxR > from.gridSize) {
            throw new IndexOutOfBoundsException("maxR greater than gridSize");
        }
        this.gridSize = maxR - minR;
        for (int oy = minR; oy < maxR; ++oy) {
            int begin = minR + oy * from.gridSize;
            int end = maxR + oy * from.gridSize;
            super.addAll(from.subList(begin, end));
        }
        if (super.size() != this.gridSize * this.gridSize) {
            throw new IllegalStateException("subgrid clone failure");
        }
    }

    protected int _indexOf(int x, int y) {
        return x + y * this.gridSize;
    }

    public final T get(Pos2D pos) {
        return this.get(pos.x, pos.y);
    }

    public final T set(Pos2D pos, T e) {
        return this.set(pos.x, pos.y, e);
    }

    public T get(int x, int y) {
        if (!this.inRange(x, y)) {
            return null;
        }
        return (T)this.get(this._indexOf(x, y));
    }

    public T set(int x, int y, T e) {
        if (!this.inRange(x, y)) {
            return null;
        }
        return this.set(this._indexOf(x, y), e);
    }

    public boolean inRange(int x, int y) {
        return x >= 0 && x < this.gridSize && y >= 0 && y < this.gridSize;
    }

    @Override
    public final void clear() {
        this.clear(null);
    }

    public final void fill(BiFunction<Integer, Integer, T> filler) {
        this.fill(null, filler);
    }

    public final void clear(Consumer<? super T> dealloc) {
        this.fill(dealloc, (x, y) -> null);
    }

    public final void fill(Consumer<? super T> dealloc, BiFunction<Integer, Integer, T> filler) {
        this.forEachPos((x, y) -> {
            Object t = this.set((int)x, (int)y, (T)filler.apply((Integer)x, (Integer)y));
            if (t != null) {
                dealloc.accept((T)t);
            }
        });
    }

    public void forEachPos(BiConsumer<Integer, Integer> consumer) {
        for (int y = 0; y < this.gridSize; ++y) {
            for (int x = 0; x < this.gridSize; ++x) {
                consumer.accept(x, y);
            }
        }
    }

    @Override
    public final void forEach(Consumer<? super T> consumer) {
        super.forEach(consumer);
    }

    @Override
    public String toString() {
        return this.getClass().toString() + " " + this.gridSize + "*" + this.gridSize + "[" + this.size() + "]";
    }

    public String toDetailString() {
        StringBuilder str = new StringBuilder("\n");
        int i = 0;
        str.append(this);
        str.append("\n");
        for (Object t : this) {
            str.append(t != null ? t.toString() : "NULL");
            str.append(", ");
            if (++i % this.gridSize != 0) continue;
            str.append("\n");
        }
        return str.toString();
    }
}

