/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.lod.core.util;

import com.seibel.lod.core.api.ApiShared;
import java.lang.ref.WeakReference;
import java.util.LinkedList;
import java.util.concurrent.ThreadFactory;

public class LodThreadFactory
implements ThreadFactory {
    public final String threadName;
    public final int priority;
    private int threadCount = 0;
    private LinkedList<WeakReference<Thread>> threads = new LinkedList();

    public LodThreadFactory(String newThreadName, int priority) {
        if (priority < 1 || priority > 10) {
            throw new IllegalArgumentException("Thread priority should be [1-10]!");
        }
        this.threadName = newThreadName + " Thread";
        this.priority = priority;
    }

    @Override
    public Thread newThread(Runnable r) {
        Thread t = new Thread(r, this.threadName + "[" + this.threadCount++ + "]");
        t.setPriority(this.priority);
        this.threads.add(new WeakReference<Thread>(t));
        return t;
    }

    private static String StackTraceToString(StackTraceElement[] e) {
        StringBuilder str = new StringBuilder();
        str.append(e[0]);
        str.append('\n');
        for (int i = 1; i < e.length; ++i) {
            str.append("  at ");
            str.append(e[i]);
            str.append('\n');
        }
        return str.toString();
    }

    public void dumpAllThreadStacks() {
        for (WeakReference weakReference : this.threads) {
            StackTraceElement[] stacks;
            Thread t = (Thread)weakReference.get();
            if (t == null || (stacks = t.getStackTrace()).length == 0) continue;
            ApiShared.LOGGER.info("===========================================\nThread: " + t.getName() + "\n" + LodThreadFactory.StackTraceToString(stacks));
        }
        this.threads.removeIf(weakRef -> weakRef.get() == null);
    }
}

