/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.lod.core.util;

import com.seibel.lod.core.util.LodUtil;

public class LevelPosUtil {
    public static int[] convert(int[] levelPos, byte newDetailLevel) {
        return LevelPosUtil.convert(LevelPosUtil.getDetailLevel(levelPos), LevelPosUtil.getPosX(levelPos), LevelPosUtil.getPosZ(levelPos), newDetailLevel);
    }

    public static int[] convert(byte detailLevel, int posX, int posZ, byte newDetailLevel) {
        if (newDetailLevel >= detailLevel) {
            int width = 1 << newDetailLevel - detailLevel;
            return LevelPosUtil.createLevelPos(newDetailLevel, Math.floorDiv(posX, width), Math.floorDiv(posZ, width));
        }
        int width = 1 << detailLevel - newDetailLevel;
        return LevelPosUtil.createLevelPos(newDetailLevel, posX * width, posZ * width);
    }

    public static int[] createLevelPos(byte detailLevel, int posX, int posZ) {
        return new int[]{detailLevel, posX, posZ};
    }

    public static int convert(byte detailLevel, int pos, byte newDetailLevel) {
        if (newDetailLevel >= detailLevel) {
            int width = 1 << newDetailLevel - detailLevel;
            return Math.floorDiv(pos, width);
        }
        int width = 1 << detailLevel - newDetailLevel;
        return pos * width;
    }

    public static int getRegion(byte detailLevel, int pos) {
        return Math.floorDiv(pos, 1 << 9 - detailLevel);
    }

    public static int getRegionModule(byte detailLevel, int pos) {
        return Math.floorMod(pos, 1 << 9 - detailLevel);
    }

    public static byte getDetailLevel(int[] levelPos) {
        return (byte)levelPos[0];
    }

    public static int getPosX(int[] levelPos) {
        return levelPos[1];
    }

    public static int getPosZ(int[] levelPos) {
        return levelPos[2];
    }

    public static int getDistance(int[] levelPos) {
        return levelPos[3];
    }

    public static int[] getRegionModule(int[] levelPos) {
        return LevelPosUtil.getRegionModule(LevelPosUtil.getDetailLevel(levelPos), LevelPosUtil.getPosX(levelPos), LevelPosUtil.getPosZ(levelPos));
    }

    public static int[] getRegionModule(byte detailLevel, int posX, int posZ) {
        int width = 1 << 9 - detailLevel;
        return LevelPosUtil.createLevelPos(detailLevel, Math.floorMod(posX, width), Math.floorMod(posZ, width));
    }

    public static int[] applyOffset(int[] levelPos, int xOffset, int zOffset) {
        return LevelPosUtil.createLevelPos(LevelPosUtil.getDetailLevel(levelPos), LevelPosUtil.getPosX(levelPos) + xOffset, LevelPosUtil.getPosZ(levelPos) + zOffset);
    }

    public static int[] applyLevelOffset(int[] levelPos, byte detailOffset, int xOffset, int zOffset) {
        return LevelPosUtil.createLevelPos(LevelPosUtil.getDetailLevel(levelPos), LevelPosUtil.getPosX(levelPos) + xOffset * (1 << detailOffset), LevelPosUtil.getPosZ(levelPos) + zOffset * (1 << detailOffset));
    }

    public static int getRegionPosX(int[] levelPos) {
        int width = 1 << 9 - LevelPosUtil.getDetailLevel(levelPos);
        return Math.floorDiv(LevelPosUtil.getPosX(levelPos), width);
    }

    public static int getRegionPosZ(int[] levelPos) {
        int width = 1 << 9 - LevelPosUtil.getDetailLevel(levelPos);
        return Math.floorDiv(LevelPosUtil.getPosZ(levelPos), width);
    }

    public static int getChunkPos(byte detailLevel, int pos) {
        return LevelPosUtil.convert(detailLevel, pos, (byte)4);
    }

    public static double centerDistance(byte detailLevel, int posX, int posZ, int playerPosX, int playerPosZ) {
        int width = 1 << detailLevel;
        double cPosX = (double)(posX * width) + (double)width / 2.0;
        double cPosZ = (double)(posZ * width) + (double)width / 2.0;
        cPosX = (double)playerPosX - cPosX;
        cPosZ = (double)playerPosZ - cPosZ;
        return Math.sqrt(LodUtil.pow2(cPosX) + LodUtil.pow2(cPosZ));
    }

    public static double maxDistance(byte detailLevel, int posX, int posZ, int playerPosX, int playerPosZ) {
        int width = 1 << detailLevel;
        double startPosX = posX * width;
        double startPosZ = posZ * width;
        double endPosX = LodUtil.pow2((double)playerPosX - startPosX - (double)width);
        double endPosZ = LodUtil.pow2((double)playerPosZ - startPosZ - (double)width);
        startPosX = LodUtil.pow2((double)playerPosX - startPosX);
        startPosZ = LodUtil.pow2((double)playerPosZ - startPosZ);
        double maxDistance = Math.sqrt(startPosX + startPosZ);
        maxDistance = Math.max(maxDistance, Math.sqrt(startPosX + endPosZ));
        maxDistance = Math.max(maxDistance, Math.sqrt(endPosX + startPosZ));
        maxDistance = Math.max(maxDistance, Math.sqrt(endPosX + endPosZ));
        return maxDistance;
    }

    public static double minDistance(byte detailLevel, int posX, int posZ, int playerPosX, int playerPosZ) {
        boolean inZArea;
        int width = 1 << detailLevel;
        int startPosX = posX * width;
        int startPosZ = posZ * width;
        int endPosX = startPosX + width;
        int endPosZ = startPosZ + width;
        boolean inXArea = playerPosX >= startPosX && playerPosX <= endPosX;
        boolean bl = inZArea = playerPosZ >= startPosZ && playerPosZ <= endPosZ;
        if (inXArea && inZArea) {
            return 0.0;
        }
        if (inXArea) {
            return Math.min(Math.abs(playerPosZ - startPosZ), Math.abs(playerPosZ - endPosZ));
        }
        if (inZArea) {
            return Math.min(Math.abs(playerPosX - startPosX), Math.abs(playerPosX - endPosX));
        }
        double startPosX2 = LodUtil.pow2(playerPosX - startPosX);
        double startPosZ2 = LodUtil.pow2(playerPosZ - startPosZ);
        double endPosX2 = LodUtil.pow2(playerPosX - endPosX);
        double endPosZ2 = LodUtil.pow2(playerPosZ - endPosZ);
        double minDistance = Math.sqrt(startPosX2 + startPosZ2);
        minDistance = Math.min(minDistance, Math.sqrt(startPosX2 + endPosZ2));
        minDistance = Math.min(minDistance, Math.sqrt(endPosX2 + startPosZ2));
        minDistance = Math.min(minDistance, Math.sqrt(endPosX2 + endPosZ2));
        return minDistance;
    }

    public static double compareLevelAndDistance(byte firstDetail, double firstDistance, byte secondDetail, double secondDistance) {
        int compareResult = Byte.compare(secondDetail, firstDetail);
        if (compareResult == 0) {
            compareResult = Double.compare(firstDistance, secondDistance);
        }
        return compareResult;
    }

    public static String toString(int[] levelPos) {
        return LevelPosUtil.getDetailLevel(levelPos) + " " + LevelPosUtil.getPosX(levelPos) + " " + LevelPosUtil.getPosZ(levelPos);
    }

    public static String toString(byte detailLevel, int posX, int posZ) {
        return detailLevel + " " + posX + " " + posZ;
    }
}

