/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.lod.core.util;

import com.seibel.lod.core.api.ApiShared;
import java.util.HashMap;
import java.util.function.Function;

public final class GLMessage {
    static final String HEADER = "[LWJGL] OpenGL debug message";
    public final Type type;
    public final Severity severity;
    public final Source source;
    public final String id;
    public final String message;

    static void initLoadClass() {
        Builder dummy = new Builder();
        dummy.add(HEADER);
        dummy.add("ID");
        dummy.add(":");
        dummy.add("dummyId");
        dummy.add("Source");
        dummy.add(":");
        dummy.add(Source.API.str);
        dummy.add("Type");
        dummy.add(":");
        dummy.add(Type.OTHER.str);
        dummy.add("Severity");
        dummy.add(":");
        dummy.add(Severity.LOW.str);
        dummy.add("Message");
        dummy.add(":");
        dummy.add("dummyMessage");
    }

    GLMessage(Type t, Severity s, Source sr, String id, String ms) {
        this.type = t;
        this.source = sr;
        this.severity = s;
        this.id = id;
        this.message = ms;
    }

    public String toString() {
        return "[level:" + (Object)((Object)this.severity) + ", type:" + (Object)((Object)this.type) + ", source:" + (Object)((Object)this.source) + ", id:" + this.id + ", msg:{" + this.message + "}]";
    }

    static {
        GLMessage.initLoadClass();
    }

    public static class Builder {
        Type type;
        Severity severity;
        Source source;
        Function<Type, Boolean> typeFilter;
        Function<Severity, Boolean> severityFilter;
        Function<Source, Boolean> sourceFilter;
        String id;
        String message;
        int stage = 0;

        public Builder() {
            this(null, null, null);
        }

        public Builder(Function<Type, Boolean> typeFilter, Function<Severity, Boolean> severityFilter, Function<Source, Boolean> sourceFilter) {
            this.typeFilter = typeFilter;
            this.severityFilter = severityFilter;
            this.sourceFilter = sourceFilter;
        }

        public GLMessage add(String str) {
            if ((str = str.trim()).isEmpty()) {
                return null;
            }
            boolean b = this.runStage(str);
            if (b && this.stage >= 16) {
                this.stage = 0;
                GLMessage msg = new GLMessage(this.type, this.severity, this.source, this.id, this.message);
                if (this.filterMessage(msg)) {
                    return msg;
                }
            } else if (!b) {
                ApiShared.LOGGER.warn("Failed to parse GLMessage line '{}' at stage {}", (Object)str, (Object)this.stage);
            }
            return null;
        }

        public void setTypeFilter(Function<Type, Boolean> typeFilter) {
            this.typeFilter = typeFilter;
        }

        public void setSeverityFilter(Function<Severity, Boolean> severityFilter) {
            this.severityFilter = severityFilter;
        }

        public void setSourceFilter(Function<Source, Boolean> sourceFilter) {
            this.sourceFilter = sourceFilter;
        }

        private boolean filterMessage(GLMessage msg) {
            if (this.sourceFilter != null && !this.sourceFilter.apply(msg.source).booleanValue()) {
                return false;
            }
            if (this.typeFilter != null && !this.typeFilter.apply(msg.type).booleanValue()) {
                return false;
            }
            return this.severityFilter == null || this.severityFilter.apply(msg.severity) != false;
        }

        private boolean runStage(String str) {
            switch (this.stage) {
                case 0: {
                    return this.checkAndIncStage(str, GLMessage.HEADER);
                }
                case 1: {
                    return this.checkAndIncStage(str, "ID");
                }
                case 2: {
                    return this.checkAndIncStage(str, ":");
                }
                case 3: {
                    this.id = str;
                    ++this.stage;
                    return true;
                }
                case 4: {
                    return this.checkAndIncStage(str, "Source");
                }
                case 5: {
                    return this.checkAndIncStage(str, ":");
                }
                case 6: {
                    this.source = Source.get(str);
                    ++this.stage;
                    return true;
                }
                case 7: {
                    return this.checkAndIncStage(str, "Type");
                }
                case 8: {
                    return this.checkAndIncStage(str, ":");
                }
                case 9: {
                    this.type = Type.get(str);
                    ++this.stage;
                    return true;
                }
                case 10: {
                    return this.checkAndIncStage(str, "Severity");
                }
                case 11: {
                    return this.checkAndIncStage(str, ":");
                }
                case 12: {
                    this.severity = Severity.get(str);
                    ++this.stage;
                    return true;
                }
                case 13: {
                    return this.checkAndIncStage(str, "Message");
                }
                case 14: {
                    return this.checkAndIncStage(str, ":");
                }
                case 15: {
                    this.message = str;
                    ++this.stage;
                    return true;
                }
            }
            return false;
        }

        private boolean checkAndIncStage(String str, String comp) {
            boolean result = str.equals(comp);
            if (result) {
                ++this.stage;
            }
            return result;
        }

        static {
            GLMessage.initLoadClass();
        }
    }

    public static enum Source {
        API,
        WINDOW_SYSTEM,
        SHADER_COMPILER,
        THIRD_PARTY,
        APPLICATION,
        OTHER;

        public final String str = super.toString().toUpperCase();
        static final HashMap<String, Source> toEnum;

        public static final Source get(String str) {
            return toEnum.get(str);
        }

        static {
            toEnum = new HashMap();
            for (Source t : Source.values()) {
                toEnum.put(t.str, t);
            }
        }
    }

    public static enum Type {
        ERROR,
        DEPRECATED_BEHAVIOR,
        UNDEFINED_BEHAVIOR,
        PORTABILITY,
        PERFORMANCE,
        MARKER,
        PUSH_GROUP,
        POP_GROUP,
        OTHER;

        public final String str = super.toString().toUpperCase();
        static final HashMap<String, Type> toEnum;

        public final String toString() {
            return this.str;
        }

        public static final Type get(String str) {
            return toEnum.get(str);
        }

        static {
            toEnum = new HashMap();
            for (Type t : Type.values()) {
                toEnum.put(t.str, t);
            }
        }
    }

    public static enum Severity {
        HIGH,
        MEDIUM,
        LOW,
        NOTIFICATION;

        public final String str = super.toString().toUpperCase();
        static final HashMap<String, Severity> toEnum;

        public static final Severity get(String str) {
            return toEnum.get(str);
        }

        static {
            toEnum = new HashMap();
            for (Severity t : Severity.values()) {
                toEnum.put(t.str, t);
            }
        }
    }
}

