/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.lod.core.objects.opengl;

import com.seibel.lod.core.api.ApiShared;
import com.seibel.lod.core.api.ClientApi;
import com.seibel.lod.core.builders.lodBuilding.bufferBuilding.LodBufferBuilderFactory;
import com.seibel.lod.core.builders.lodBuilding.bufferBuilding.LodQuadBuilder;
import com.seibel.lod.core.enums.config.GpuUploadMethod;
import com.seibel.lod.core.handlers.dependencyInjection.SingletonHandler;
import com.seibel.lod.core.objects.opengl.RenderBuffer;
import com.seibel.lod.core.render.GLProxy;
import com.seibel.lod.core.render.LodRenderProgram;
import com.seibel.lod.core.render.objects.GLVertexBuffer;
import com.seibel.lod.core.util.LodUtil;
import com.seibel.lod.core.util.StatsMap;
import com.seibel.lod.core.wrapperInterfaces.config.ILodConfigWrapperSingleton;
import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.concurrent.TimeUnit;
import org.lwjgl.opengl.GL32;

public class SimpleRenderBuffer
extends RenderBuffer {
    private static final ILodConfigWrapperSingleton CONFIG = SingletonHandler.get(ILodConfigWrapperSingleton.class);
    private static final long MAX_BUFFER_UPLOAD_TIMEOUT_NANOSECONDS = 1000000L;
    GLVertexBuffer[] vbos = new GLVertexBuffer[0];

    @Override
    protected boolean uploadBuffers(LodQuadBuilder builder, GpuUploadMethod method) {
        if (method.useEarlyMapping) {
            this._uploadBuffersMapped(builder, method);
        } else {
            this._uploadBuffersDirect(builder, method);
        }
        return true;
    }

    @Override
    public boolean render(LodRenderProgram shaderProgram) {
        boolean hasRendered = false;
        for (GLVertexBuffer vbo : this.vbos) {
            if (vbo == null || vbo.getVertexCount() == 0) continue;
            hasRendered = true;
            vbo.bind();
            shaderProgram.bindVertexBuffer(vbo.getId());
            GL32.glDrawElements((int)4, (int)(vbo.getVertexCount() / 4 * 6), (int)ClientApi.renderer.quadIBO.getType(), (long)0L);
        }
        return hasRendered;
    }

    @Override
    public void debugDumpStats(StatsMap statsMap) {
        statsMap.incStat("RenderBuffers");
        statsMap.incStat("SimpleRenderBuffers");
        for (GLVertexBuffer b : this.vbos) {
            if (b == null) continue;
            statsMap.incStat("VBOs");
            if (b.getSize() == LodBufferBuilderFactory.FULL_SIZED_BUFFER) {
                statsMap.incStat("FullsizedVBOs");
            }
            if (b.getSize() == 0) {
                GLProxy.GL_LOGGER.warn("VBO with size 0", new Object[0]);
            }
            statsMap.incBytesStat("TotalUsage", b.getSize());
        }
    }

    @Override
    public void close() {
        GLProxy.getInstance().recordOpenGlCall(() -> {
            for (GLVertexBuffer b : this.vbos) {
                b.destroy(false);
            }
        });
    }

    private void _uploadBuffersDirect(LodQuadBuilder builder, GpuUploadMethod method) {
        this.resize(builder.getCurrentNeededVertexBufferCount());
        long remainingNS = 0L;
        long BPerNS = CONFIG.client().advanced().buffers().getGpuUploadPerMegabyteInMilliseconds();
        int i = 0;
        Iterator<ByteBuffer> iter = builder.makeVertexBuffers();
        while (iter.hasNext()) {
            if (i >= this.vbos.length) {
                throw new RuntimeException("Too many vertex buffers!!");
            }
            ByteBuffer bb = iter.next();
            GLVertexBuffer vbo = this.getOrMakeVbo(i++, method.useBufferStorage);
            int size = bb.limit() - bb.position();
            try {
                vbo.bind();
                vbo.uploadBuffer(bb, size / LodUtil.LOD_VERTEX_FORMAT.getByteSize(), method, LodBufferBuilderFactory.FULL_SIZED_BUFFER);
            }
            catch (Exception e) {
                this.vbos[i - 1] = null;
                vbo.close();
                ApiShared.LOGGER.error("Failed to upload buffer: ", (Throwable)e);
            }
            if (BPerNS <= 0L || (remainingNS += (long)size * BPerNS) < TimeUnit.NANOSECONDS.convert(16L, TimeUnit.MILLISECONDS)) continue;
            if (remainingNS > 1000000L) {
                remainingNS = 1000000L;
            }
            try {
                Thread.sleep(remainingNS / 1000000L, (int)(remainingNS % 1000000L));
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            remainingNS = 0L;
        }
        if (i < this.vbos.length) {
            throw new RuntimeException("Too few vertex buffers!!");
        }
    }

    private void _uploadBuffersMapped(LodQuadBuilder builder, GpuUploadMethod method) {
        this.resize(builder.getCurrentNeededVertexBufferCount());
        for (int i = 0; i < this.vbos.length; ++i) {
            if (this.vbos[i] != null) continue;
            this.vbos[i] = new GLVertexBuffer(method.useBufferStorage);
        }
        LodQuadBuilder.BufferFiller func = builder.makeBufferFiller(method);
        int i = 0;
        while (i < this.vbos.length && func.fill(this.vbos[i++])) {
        }
    }

    private GLVertexBuffer getOrMakeVbo(int iIndex, boolean useBuffStorage) {
        if (this.vbos[iIndex] == null) {
            this.vbos[iIndex] = new GLVertexBuffer(useBuffStorage);
        }
        return this.vbos[iIndex];
    }

    private void resize(int size) {
        if (this.vbos.length != size) {
            int i;
            GLVertexBuffer[] newVbos = new GLVertexBuffer[size];
            if (this.vbos.length > size) {
                for (i = size; i < this.vbos.length; ++i) {
                    if (this.vbos[i] != null) {
                        this.vbos[i].close();
                    }
                    this.vbos[i] = null;
                }
            }
            for (i = 0; i < newVbos.length && i < this.vbos.length; ++i) {
                newVbos[i] = this.vbos[i];
                this.vbos[i] = null;
            }
            for (GLVertexBuffer b : this.vbos) {
                if (b == null) continue;
                throw new RuntimeException("LEAKING VBO!");
            }
            this.vbos = newVbos;
        }
    }
}

