/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.lod.core.objects.opengl;

import com.seibel.lod.core.api.ClientApi;
import com.seibel.lod.core.builders.lodBuilding.LodBuilder;
import com.seibel.lod.core.builders.lodBuilding.bufferBuilding.CubicLodTemplate;
import com.seibel.lod.core.builders.lodBuilding.bufferBuilding.LodQuadBuilder;
import com.seibel.lod.core.enums.LodDirection;
import com.seibel.lod.core.enums.config.GpuUploadMethod;
import com.seibel.lod.core.enums.rendering.DebugMode;
import com.seibel.lod.core.enums.rendering.GLProxyContext;
import com.seibel.lod.core.handlers.dependencyInjection.SingletonHandler;
import com.seibel.lod.core.objects.BoolType;
import com.seibel.lod.core.objects.PosToRenderContainer;
import com.seibel.lod.core.objects.lod.LodDimension;
import com.seibel.lod.core.objects.lod.LodRegion;
import com.seibel.lod.core.objects.lod.RegionPos;
import com.seibel.lod.core.objects.math.Vec3d;
import com.seibel.lod.core.objects.math.Vec3f;
import com.seibel.lod.core.objects.opengl.RenderBuffer;
import com.seibel.lod.core.objects.opengl.SimpleRenderBuffer;
import com.seibel.lod.core.render.GLProxy;
import com.seibel.lod.core.render.LodRenderProgram;
import com.seibel.lod.core.render.LodRenderer;
import com.seibel.lod.core.render.RenderUtil;
import com.seibel.lod.core.util.DataPointUtil;
import com.seibel.lod.core.util.LevelPosUtil;
import com.seibel.lod.core.util.StatsMap;
import com.seibel.lod.core.util.gridList.PosArrayGridList;
import com.seibel.lod.core.wrapperInterfaces.block.AbstractBlockPosWrapper;
import com.seibel.lod.core.wrapperInterfaces.config.ILodConfigWrapperSingleton;
import java.util.ConcurrentModificationException;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;

public class RenderRegion
implements AutoCloseable {
    private static final ILodConfigWrapperSingleton CONFIG = SingletonHandler.get(ILodConfigWrapperSingleton.class);
    private final AtomicInteger needRegen = new AtomicInteger(2);
    final RegionPos regionPos;
    RenderBuffer renderBufferBack = null;
    AtomicReference<BackState> backState = new AtomicReference<BackState>(BackState.Unused);
    AtomicReference<FrontState> frontState = new AtomicReference<FrontState>(FrontState.Unused);
    RenderBuffer renderBufferFront = null;
    final LodDimension lodDim;
    private static final int[][] ADJACENT8 = new int[][]{{-1, -1}, {-1, 0}, {-1, 1}, {0, -1}, {0, 1}, {1, -1}, {1, 0}, {1, 1}};

    public RenderRegion(RegionPos regPos, LodDimension lodDim) {
        this.regionPos = regPos;
        this.lodDim = lodDim;
    }

    public boolean canRender(LodDimension lodDim, RegionPos regPos) {
        return lodDim == this.lodDim && regPos.equals(this.regionPos);
    }

    public void setNeedRegen() {
        this.needRegen.set(2);
    }

    public Optional<CompletableFuture<Void>> updateStatus(Executor bufferUploader, Executor bufferBuilder, boolean alwaysRegen, int playerPosX, int playerPosZ, boolean doCaveCulling) {
        BackState state;
        if (alwaysRegen) {
            this.setNeedRegen();
        }
        if ((state = this.backState.get()) != BackState.Unused) {
            LodRenderer.EVENT_LOGGER.trace("{}: UpdateStatus rejected. Cause: BackState is {}", new Object[]{this.regionPos, state});
            return Optional.empty();
        }
        LodRegion r = this.lodDim.getRegion(this.regionPos.x, this.regionPos.z);
        if (r == null) {
            LodRenderer.EVENT_LOGGER.trace("{}: UpdateStatus rejected. Cause: Region is null", this.regionPos);
            return Optional.empty();
        }
        if (this.needRegen.get() == 0) {
            LodRenderer.EVENT_LOGGER.trace("{}: UpdateStatus rejected. Cause: Region doesn't need regen", this.regionPos);
            return Optional.empty();
        }
        if (!this.backState.compareAndSet(BackState.Unused, BackState.Building)) {
            LodRenderer.EVENT_LOGGER.trace("{}: UpdateStatus rejected. Cause: CAS on BackState failed: ", new Object[]{this.backState.get()});
            return Optional.empty();
        }
        this.needRegen.decrementAndGet();
        return Optional.of(this.startBuid(bufferUploader, bufferBuilder, r, this.lodDim, playerPosX, playerPosZ, doCaveCulling));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean render(LodDimension renderDim, Vec3d cameraPos, AbstractBlockPosWrapper cameraBlockPos, Vec3f cameraDir, boolean enableDirectionalCulling, LodRenderProgram program) {
        if (!this.frontState.compareAndSet(FrontState.Unused, FrontState.Rendering)) {
            return false;
        }
        try {
            boolean bl;
            if (renderDim != this.lodDim) {
                boolean bl2 = false;
                return bl2;
            }
            if (enableDirectionalCulling && !RenderUtil.isRegionInViewFrustum(cameraBlockPos, cameraDir, this.regionPos.x, this.regionPos.z)) {
                boolean bl3 = false;
                return bl3;
            }
            BackState state = this.backState.get();
            if (state == BackState.Complete) {
                if (this.renderBufferBack != null) {
                    LodRenderer.EVENT_LOGGER.debug("RenderRegion swap @ {}", this.regionPos);
                    boolean shouldKeep = this.renderBufferFront != null && this.renderBufferFront.onSwapToBack();
                    RenderBuffer temp = shouldKeep ? this.renderBufferFront : null;
                    this.renderBufferFront = this.renderBufferBack;
                    this.renderBufferBack = temp;
                    if (this.renderBufferFront != null) {
                        this.renderBufferFront.onSwapToFront();
                    }
                }
                if (!this.backState.compareAndSet(BackState.Complete, BackState.Unused)) {
                    LodRenderer.EVENT_LOGGER.error("RenderRegion.render() got illegal state on swapping buffer!", new Object[0]);
                }
            }
            if (this.renderBufferFront == null) {
                bl = false;
                return bl;
            }
            program.setModelPos(new Vec3f((float)((double)(this.regionPos.x * 512) - cameraPos.x), (float)((double)LodBuilder.MIN_WORLD_HEIGHT - cameraPos.y), (float)((double)(this.regionPos.z * 512) - cameraPos.z)));
            bl = this.renderBufferFront.render(program);
            return bl;
        }
        finally {
            this.frontState.compareAndSet(FrontState.Rendering, FrontState.Unused);
        }
    }

    private void recreateBuffer(LodQuadBuilder builder) {
        boolean useSimpleBuffer;
        if (this.renderBufferBack != null) {
            throw new RuntimeException("Assert Error");
        }
        if (builder.getCurrentNeededVertexBufferCount() > 6) {
            // empty if block
        }
        this.renderBufferBack = (useSimpleBuffer = true) ? new SimpleRenderBuffer() : null;
    }

    private CompletableFuture<Void> startBuid(Executor bufferUploader, Executor bufferBuilder, LodRegion region, LodDimension lodDim, int playerPosX, int playerPosZ, boolean doCaveCulling) {
        LodRenderer.EVENT_LOGGER.trace("RenderRegion startBuild @ {}", this.regionPos);
        LodRegion[] adjRegions = new LodRegion[4];
        try {
            if (this.renderBufferBack != null) {
                this.renderBufferBack.onReuse();
            }
            for (LodDirection dir : LodDirection.ADJ_DIRECTIONS) {
                adjRegions[dir.ordinal() - 2] = lodDim.getRegion(this.regionPos.x + dir.getNormal().x, this.regionPos.z + dir.getNormal().z);
            }
        }
        catch (ArrayIndexOutOfBoundsException | NullPointerException e2) {
            this.setNeedRegen();
            if (!this.backState.compareAndSet(BackState.Building, BackState.Unused)) {
                LodRenderer.EVENT_LOGGER.error("\"Lod Builder Starter\" encountered error on catching exceptions and fallback on starting build task: ", new ConcurrentModificationException("RenderRegion Illegal State"));
            }
            LodRenderer.EVENT_LOGGER.info("\"Lod Builder Starter\" failed due to possible known concurrency issue: ", e2);
            return CompletableFuture.completedFuture(null);
        }
        catch (Throwable t) {
            this.setNeedRegen();
            if (!this.backState.compareAndSet(BackState.Building, BackState.Unused)) {
                LodRenderer.EVENT_LOGGER.error("\"Lod Builder Starter\" encountered error on catching exceptions and fallback on starting build task: ", new ConcurrentModificationException("RenderRegion Illegal State"));
            }
            throw t;
        }
        return ((CompletableFuture)CompletableFuture.supplyAsync(() -> {
            try {
                LodRenderer.EVENT_LOGGER.trace("RenderRegion start QuadBuild @ {}", this.regionPos);
                int skyLightCullingBelow = CONFIG.client().graphics().advancedGraphics().getCaveCullingHeight();
                skyLightCullingBelow = Math.max(skyLightCullingBelow, LodBuilder.MIN_WORLD_HEIGHT);
                LodQuadBuilder builder = new LodQuadBuilder(doCaveCulling, skyLightCullingBelow);
                Runnable buildRun = () -> RenderRegion.makeLodRenderData(builder, region, adjRegions, playerPosX, playerPosZ);
                if (this.renderBufferBack != null) {
                    this.renderBufferBack.build(buildRun);
                } else {
                    buildRun.run();
                }
                LodRenderer.EVENT_LOGGER.trace("RenderRegion end QuadBuild @ {}", this.regionPos);
                return builder;
            }
            catch (ArrayIndexOutOfBoundsException | NullPointerException e) {
                LodRenderer.EVENT_LOGGER.info("\"LodNodeBufferBuilder\" failed due to possible known concurrency issue: ", e);
                throw e;
            }
            catch (Throwable e3) {
                LodRenderer.EVENT_LOGGER.error("\"LodNodeBufferBuilder\" was unable to build quads: ", e3);
                throw e3;
            }
        }, bufferBuilder).thenAcceptAsync(builder -> {
            try {
                LodRenderer.EVENT_LOGGER.trace("RenderRegion start Upload @ {}", this.regionPos);
                GLProxy glProxy = GLProxy.getInstance();
                GpuUploadMethod method = GLProxy.getInstance().getGpuUploadMethod();
                GLProxyContext oldContext = glProxy.getGlContext();
                glProxy.setGlContext(GLProxyContext.LOD_BUILDER);
                try {
                    if (this.renderBufferBack == null) {
                        this.recreateBuffer((LodQuadBuilder)builder);
                    }
                    if (!this.renderBufferBack.tryUploadBuffers((LodQuadBuilder)builder, method)) {
                        this.renderBufferBack = null;
                        this.recreateBuffer((LodQuadBuilder)builder);
                        if (!this.renderBufferBack.tryUploadBuffers((LodQuadBuilder)builder, method)) {
                            throw new RuntimeException("Newly created renderBuffer is still returning false on tryUploadBuffers!");
                        }
                    }
                }
                finally {
                    glProxy.setGlContext(oldContext);
                }
                LodRenderer.EVENT_LOGGER.trace("RenderRegion end Upload @ {}", this.regionPos);
            }
            catch (Throwable e3) {
                LodRenderer.EVENT_LOGGER.error("\"LodNodeBufferBuilder\" was unable to upload buffer: ", e3);
                throw e3;
            }
        }, bufferUploader)).handle((v, e) -> {
            if (e != null) {
                this.setNeedRegen();
                if (!this.backState.compareAndSet(BackState.Building, BackState.Unused)) {
                    LodRenderer.EVENT_LOGGER.error("\"LodNodeBufferBuilder\" encountered error on exit: ", new ConcurrentModificationException("RenderRegion Illegal State"));
                }
            } else if (!this.backState.compareAndSet(BackState.Building, BackState.Complete)) {
                LodRenderer.EVENT_LOGGER.error("\"LodNodeBufferBuilder\" encountered error on exit: ", new ConcurrentModificationException("RenderRegion Illegal State"));
            }
            return null;
        });
    }

    private static void makeLodRenderData(LodQuadBuilder quadBuilder, LodRegion region, LodRegion[] adjRegions, int playerX, int playerZ) {
        byte minDetail = region.getMinDetailLevel();
        DebugMode debugMode = CONFIG.client().advanced().debugging().getDebugMode();
        PosToRenderContainer posToRender = new PosToRenderContainer(minDetail, region.regionPosX, region.regionPosZ);
        region.getPosToRender(posToRender, playerX, playerZ);
        PosArrayGridList<BoolType> chunkGrid = ClientApi.renderer.vanillaChunks;
        for (int index = 0; index < posToRender.getNumberOfPos(); ++index) {
            long data;
            long[] posData;
            byte detailLevel = posToRender.getNthDetailLevel(index);
            int posX = posToRender.getNthPosX(index);
            int posZ = posToRender.getNthPosZ(index);
            if (detailLevel <= 4) {
                int chunkX = LevelPosUtil.getChunkPos(detailLevel, posX);
                int chunkZ = LevelPosUtil.getChunkPos(detailLevel, posZ);
                if (chunkGrid != null && chunkGrid.get(chunkX, chunkZ) != null) continue;
            }
            if ((posData = region.getAllData(detailLevel, posX, posZ)) == null || posData.length == 0 || !DataPointUtil.doesItExist(posData[0]) || DataPointUtil.isVoid(posData[0])) continue;
            long[][][] adjData = new long[4][][];
            boolean[] adjUseBlack = new boolean[4];
            for (LodDirection lodDirection : LodDirection.ADJ_DIRECTIONS) {
                try {
                    byte adjDetail;
                    LodRegion adjRegion;
                    int xAdj = posX + lodDirection.getNormal().x;
                    int zAdj = posZ + lodDirection.getNormal().z;
                    int chunkXAdj = LevelPosUtil.getChunkPos(detailLevel, xAdj);
                    int chunkZAdj = LevelPosUtil.getChunkPos(detailLevel, zAdj);
                    if (chunkGrid != null && chunkGrid.get(chunkXAdj, chunkZAdj) != null) {
                        adjUseBlack[lodDirection.ordinal() - 2] = true;
                    }
                    boolean isCrossRegionBoundary = LevelPosUtil.getRegion(detailLevel, xAdj) != region.regionPosX || LevelPosUtil.getRegion(detailLevel, zAdj) != region.regionPosZ;
                    int childXAdj = xAdj * 2 + (lodDirection.getNormal().x < 0 ? 1 : 0);
                    int childZAdj = zAdj * 2 + (lodDirection.getNormal().z < 0 ? 1 : 0);
                    if (isCrossRegionBoundary) {
                        adjRegion = adjRegions[lodDirection.ordinal() - 2];
                        if (adjRegion == null) continue;
                        adjDetail = adjRegion.getRenderDetailLevelAt(playerX, playerZ, detailLevel, xAdj, zAdj);
                    } else {
                        adjRegion = region;
                        if (posToRender.contains(detailLevel, xAdj, zAdj)) {
                            adjDetail = detailLevel;
                        } else if (detailLevel > 0 && posToRender.contains((byte)(detailLevel - 1), childXAdj, childZAdj)) {
                            adjDetail = (byte)(detailLevel - 1);
                        } else {
                            if (detailLevel >= 9 || !posToRender.contains((byte)(detailLevel + 1), xAdj / 2, zAdj / 2)) continue;
                            adjDetail = (byte)(detailLevel + 1);
                        }
                    }
                    if (adjDetail < detailLevel - 1 || adjDetail > detailLevel + 1) continue;
                    if (adjDetail == detailLevel || adjDetail > detailLevel) {
                        adjData[lodDirection.ordinal() - 2] = new long[1][];
                        adjData[lodDirection.ordinal() - 2][0] = adjRegion.getAllData(adjDetail, LevelPosUtil.convert(detailLevel, xAdj, adjDetail), LevelPosUtil.convert(detailLevel, zAdj, adjDetail));
                        continue;
                    }
                    adjData[lodDirection.ordinal() - 2] = new long[2][];
                    adjData[lodDirection.ordinal() - 2][0] = adjRegion.getAllData(adjDetail, childXAdj, childZAdj);
                    adjData[lodDirection.ordinal() - 2][1] = adjRegion.getAllData(adjDetail, childXAdj + (lodDirection.getAxis() == LodDirection.Axis.X ? 0 : 1), childZAdj + (lodDirection.getAxis() == LodDirection.Axis.Z ? 0 : 1));
                }
                catch (RuntimeException e) {
                    LodRenderer.EVENT_LOGGER.warn("Failed to get adj data for [{}:{},{}] at [{}]", new Object[]{detailLevel, posX, posZ, lodDirection});
                    LodRenderer.EVENT_LOGGER.warn("Detail exception: ", e);
                }
            }
            for (int i = 0; i < posData.length && !DataPointUtil.isVoid(data = posData[i]) && DataPointUtil.doesItExist(data); ++i) {
                long adjDataTop = i - 1 >= 0 ? posData[i - 1] : 0L;
                long adjDataBot = i + 1 < posData.length ? posData[i + 1] : 0L;
                CubicLodTemplate.addLodToBuffer(data, adjDataTop, adjDataBot, adjData, adjUseBlack, detailLevel, LevelPosUtil.getRegionModule(detailLevel, posX), LevelPosUtil.getRegionModule(detailLevel, posZ), quadBuilder, debugMode);
            }
        }
        quadBuilder.mergeQuads();
    }

    @Override
    public void close() {
        if (this.renderBufferBack != null) {
            this.renderBufferBack.close();
        }
        while (this.frontState.get() != FrontState.Invalidated && !this.frontState.compareAndSet(FrontState.Unused, FrontState.Invalidated)) {
            Thread.yield();
        }
        if (this.renderBufferFront != null) {
            this.renderBufferFront.close();
        }
    }

    public void debugDumpStats(StatsMap statsMap) {
        RenderBuffer back;
        statsMap.incStat("RenderRegions");
        RenderBuffer front = this.renderBufferFront;
        if (front != null) {
            statsMap.incStat("FrontBuffers");
            front.debugDumpStats(statsMap);
        }
        if ((back = this.renderBufferBack) != null) {
            statsMap.incStat("BackBuffers");
            back.debugDumpStats(statsMap);
        }
    }

    private static enum BackState {
        Unused,
        Building,
        Complete;

    }

    private static enum FrontState {
        Unused,
        Rendering,
        Invalidated;

    }
}

