/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.lod.core.objects.lod;

import com.seibel.lod.core.handlers.dependencyInjection.SingletonHandler;
import com.seibel.lod.core.objects.lod.LevelContainer;
import com.seibel.lod.core.util.DataPointUtil;
import com.seibel.lod.core.util.DetailDistanceUtil;
import com.seibel.lod.core.wrapperInterfaces.minecraft.IMinecraftClientWrapper;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;

public class VerticalLevelContainer
implements LevelContainer {
    private final short minHeight;
    public final byte detailLevel;
    public final int size;
    public final int verticalSize;
    public final long[] dataContainer;
    public final int[] verticalDataContainer = null;
    public final int[] colorDataContainer = null;
    public final byte[] lightDataContainer = null;
    public final short[] positionDataContainer = null;
    private static final ThreadLocal<long[][]> tLocalVerticalUpdateArrays = ThreadLocal.withInitial(() -> new long[9][]);

    public VerticalLevelContainer(byte detailLevel) {
        this.detailLevel = detailLevel;
        this.size = 1 << 9 - detailLevel;
        this.verticalSize = DetailDistanceUtil.getMaxVerticalData(detailLevel);
        this.dataContainer = new long[this.size * this.size * DetailDistanceUtil.getMaxVerticalData(detailLevel)];
        this.minHeight = SingletonHandler.get(IMinecraftClientWrapper.class).getWrappedClientWorld().getMinHeight();
    }

    @Override
    public byte getDetailLevel() {
        return this.detailLevel;
    }

    @Override
    public void clear(int posX, int posZ) {
        for (int verticalIndex = 0; verticalIndex < this.verticalSize; ++verticalIndex) {
            this.dataContainer[posX * this.size * this.verticalSize + posZ * this.verticalSize + verticalIndex] = 0L;
        }
    }

    @Override
    public boolean addData(long data, int posX, int posZ, int verticalIndex) {
        this.dataContainer[posX * this.size * this.verticalSize + posZ * this.verticalSize + verticalIndex] = data;
        return true;
    }

    private void forceWriteVerticalData(long[] data, int posX, int posZ) {
        int index = posX * this.size * this.verticalSize + posZ * this.verticalSize;
        if (this.verticalSize >= 0) {
            System.arraycopy(data, 0, this.dataContainer, index + 0, this.verticalSize);
        }
    }

    @Override
    public boolean addVerticalData(long[] data, int posX, int posZ, boolean override) {
        int index = posX * this.size * this.verticalSize + posZ * this.verticalSize;
        int compare = DataPointUtil.compareDatapointPriority(data[0], this.dataContainer[index]);
        if (override ? compare < 0 : compare <= 0) {
            return false;
        }
        this.forceWriteVerticalData(data, posX, posZ);
        return true;
    }

    @Override
    public boolean addChunkOfData(long[] data, int posX, int posZ, int widthX, int widthZ, boolean override) {
        boolean anyChange = false;
        if (posX + widthX > this.size || posZ + widthZ > this.size) {
            throw new IndexOutOfBoundsException("addChunkOfData param not inside valid range");
        }
        if (widthX * widthZ * this.verticalSize > data.length) {
            throw new IndexOutOfBoundsException("addChunkOfData data array not long enough to contain the data to be copied");
        }
        if (posX < 0 || posZ < 0 || widthX < 0 || widthZ < 0) {
            throw new IndexOutOfBoundsException("addChunkOfData param is negative");
        }
        for (int ox = 0; ox < widthX; ++ox) {
            anyChange = DataPointUtil.mergeTwoDataArray(this.dataContainer, ((ox + posX) * this.size + posZ) * this.verticalSize, data, ox * widthX * this.verticalSize, widthZ, this.verticalSize, override);
        }
        return anyChange;
    }

    @Override
    public boolean addSingleData(long data, int posX, int posZ) {
        return this.addData(data, posX, posZ, 0);
    }

    @Override
    public long getData(int posX, int posZ, int verticalIndex) {
        return this.dataContainer[posX * this.size * this.verticalSize + posZ * this.verticalSize + verticalIndex];
    }

    public short getPositionData(int posX, int posZ) {
        return this.positionDataContainer[posX * this.size + posZ];
    }

    public int getVerticalData(int posX, int posZ, int verticalIndex) {
        return this.verticalDataContainer[posX * this.size * this.verticalSize + posZ * this.verticalSize + verticalIndex];
    }

    public int getColorData(int posX, int posZ, int verticalIndex) {
        return this.colorDataContainer[posX * this.size * this.verticalSize + posZ * this.verticalSize + verticalIndex];
    }

    public byte getLightData(int posX, int posZ, int verticalIndex) {
        return this.lightDataContainer[posX * this.size * this.verticalSize + posZ * this.verticalSize + verticalIndex];
    }

    public void setPositionData(short positionData, int posX, int posZ) {
        this.positionDataContainer[posX * this.size + posZ] = positionData;
    }

    public void setVerticalData(int verticalData, int posX, int posZ, int verticalIndex) {
        this.verticalDataContainer[posX * this.size * this.verticalSize + posZ * this.verticalSize + verticalIndex] = verticalData;
    }

    public void setColorData(int colorData, int posX, int posZ, int verticalIndex) {
        this.colorDataContainer[posX * this.size * this.verticalSize + posZ * this.verticalSize + verticalIndex] = colorData;
    }

    public void setLightData(byte lightData, int posX, int posZ, int verticalIndex) {
        this.lightDataContainer[posX * this.size * this.verticalSize + posZ * this.verticalSize + verticalIndex] = lightData;
    }

    @Override
    public long getSingleData(int posX, int posZ) {
        return this.dataContainer[posX * this.size * this.verticalSize + posZ * this.verticalSize];
    }

    @Override
    public long[] getAllData(int posX, int posZ) {
        long[] result = new long[this.verticalSize];
        int index = posX * this.size * this.verticalSize + posZ * this.verticalSize;
        System.arraycopy(this.dataContainer, index, result, 0, this.verticalSize);
        return result;
    }

    @Override
    public int getVerticalSize() {
        return this.verticalSize;
    }

    public int getSize() {
        return this.size;
    }

    @Override
    public boolean doesItExist(int posX, int posZ) {
        return DataPointUtil.doesItExist(this.getSingleData(posX, posZ));
    }

    private long[] readDataVersion6(DataInputStream inputData, int tempMaxVerticalData) throws IOException {
        int x = this.size * this.size * tempMaxVerticalData;
        byte[] data = new byte[x * 8];
        ByteBuffer bb = ByteBuffer.wrap(data).order(ByteOrder.LITTLE_ENDIAN);
        inputData.readFully(data);
        long[] result = new long[x];
        bb.asLongBuffer().get(result);
        VerticalLevelContainer.patchVersion9Reorder(result);
        VerticalLevelContainer.patchHeightAndDepth(result, -this.minHeight);
        return result;
    }

    private long[] readDataVersion7(DataInputStream inputData, int tempMaxVerticalData) throws IOException {
        int x = this.size * this.size * tempMaxVerticalData;
        byte[] data = new byte[x * 8];
        ByteBuffer bb = ByteBuffer.wrap(data).order(ByteOrder.LITTLE_ENDIAN);
        inputData.readFully(data);
        long[] result = new long[x];
        bb.asLongBuffer().get(result);
        VerticalLevelContainer.patchVersion9Reorder(result);
        VerticalLevelContainer.patchHeightAndDepth(result, 64 - this.minHeight);
        return result;
    }

    private long[] readDataVersion8(DataInputStream inputData, int tempMaxVerticalData) throws IOException {
        int x = this.size * this.size * tempMaxVerticalData;
        byte[] data = new byte[x * 8];
        short tempMinHeight = Short.reverseBytes(inputData.readShort());
        ByteBuffer bb = ByteBuffer.wrap(data).order(ByteOrder.LITTLE_ENDIAN);
        inputData.readFully(data);
        long[] result = new long[x];
        bb.asLongBuffer().get(result);
        VerticalLevelContainer.patchVersion9Reorder(result);
        if (tempMinHeight != this.minHeight) {
            VerticalLevelContainer.patchHeightAndDepth(result, tempMinHeight - this.minHeight);
        }
        return result;
    }

    private long[] readDataVersion9(DataInputStream inputData, int tempMaxVerticalData) throws IOException {
        int x = this.size * this.size * tempMaxVerticalData;
        byte[] data = new byte[x * 8];
        short tempMinHeight = Short.reverseBytes(inputData.readShort());
        ByteBuffer bb = ByteBuffer.wrap(data).order(ByteOrder.LITTLE_ENDIAN);
        inputData.readFully(data);
        long[] result = new long[x];
        bb.asLongBuffer().get(result);
        if (tempMinHeight != this.minHeight) {
            VerticalLevelContainer.patchHeightAndDepth(result, tempMinHeight - this.minHeight);
        }
        return result;
    }

    private static void patchHeightAndDepth(long[] data, int offset) {
        for (int i = 0; i < data.length; ++i) {
            data[i] = DataPointUtil.shiftHeightAndDepth(data[i], (short)offset);
        }
    }

    private static void patchVersion9Reorder(long[] data) {
        for (int i = 0; i < data.length; ++i) {
            data[i] = DataPointUtil.version9Reorder(data[i]);
        }
    }

    public VerticalLevelContainer(DataInputStream inputData, int version, byte expectedDetailLevel) throws IOException {
        int targetMaxVerticalData;
        this.minHeight = SingletonHandler.get(IMinecraftClientWrapper.class).getWrappedClientWorld().getMinHeight();
        this.detailLevel = inputData.readByte();
        if (this.detailLevel != expectedDetailLevel) {
            throw new IOException("Invalid Data: The expected detail level should be " + expectedDetailLevel + " but the data header say it's " + this.detailLevel);
        }
        this.size = 1 << 9 - this.detailLevel;
        int fileMaxVerticalData = inputData.readByte() & 0x7F;
        long[] tempDataContainer = null;
        switch (version) {
            case 6: {
                tempDataContainer = this.readDataVersion6(inputData, fileMaxVerticalData);
                break;
            }
            case 7: {
                tempDataContainer = this.readDataVersion7(inputData, fileMaxVerticalData);
                break;
            }
            case 8: {
                tempDataContainer = this.readDataVersion8(inputData, fileMaxVerticalData);
                break;
            }
            case 9: {
                tempDataContainer = this.readDataVersion9(inputData, fileMaxVerticalData);
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        this.verticalSize = targetMaxVerticalData = DetailDistanceUtil.getMaxVerticalData(this.detailLevel);
        this.dataContainer = DataPointUtil.changeMaxVertSize(tempDataContainer, fileMaxVerticalData, this.verticalSize);
    }

    @Override
    public LevelContainer expand() {
        return new VerticalLevelContainer((byte)(this.getDetailLevel() - 1));
    }

    @Override
    public void updateData(LevelContainer lowerLevelContainer, int posX, int posZ) {
        long[][] verticalUpdateArrays = tLocalVerticalUpdateArrays.get();
        long[] dataToMerge = verticalUpdateArrays[this.detailLevel - 1];
        int arrayLength = DetailDistanceUtil.getMaxVerticalData(this.detailLevel - 1) * 4;
        if (dataToMerge == null || dataToMerge.length != arrayLength) {
            dataToMerge = new long[arrayLength];
            verticalUpdateArrays[this.detailLevel - 1] = dataToMerge;
        } else {
            Arrays.fill(dataToMerge, 0L);
        }
        int lowerMaxVertical = dataToMerge.length / 4;
        boolean anyDataExist = false;
        for (int x = 0; x <= 1; ++x) {
            for (int z = 0; z <= 1; ++z) {
                int childPosX = 2 * posX + x;
                int childPosZ = 2 * posZ + z;
                if (lowerLevelContainer.doesItExist(childPosX, childPosZ)) {
                    anyDataExist = true;
                }
                for (int verticalIndex = 0; verticalIndex < lowerMaxVertical; ++verticalIndex) {
                    dataToMerge[(z * 2 + x) * lowerMaxVertical + verticalIndex] = lowerLevelContainer.getData(childPosX, childPosZ, verticalIndex);
                }
            }
        }
        long[] data = DataPointUtil.mergeMultiData(dataToMerge, lowerMaxVertical, this.getVerticalSize());
        if (!anyDataExist) {
            throw new RuntimeException("Update data called but no child datapoint exist!");
        }
        if (!DataPointUtil.doesItExist(data[0]) && anyDataExist) {
            throw new RuntimeException("Update data called but higher level datapoint doesn't exist even though child data does exist!");
        }
        if (DataPointUtil.getGenerationMode(data[0]) != DataPointUtil.getGenerationMode(lowerLevelContainer.getSingleData(posX * 2, posZ * 2))) {
            throw new RuntimeException("Update data called but higher level datapoint does not have the same GenerationMode as the top left corner child datapoint!");
        }
        this.forceWriteVerticalData(data, posX, posZ);
    }

    @Override
    public boolean writeData(DataOutputStream output) throws IOException {
        output.writeByte(this.detailLevel);
        output.writeByte((byte)this.verticalSize);
        output.writeByte((byte)(this.minHeight & 0xFF));
        output.writeByte((byte)(this.minHeight >> 8 & 0xFF));
        boolean allGenerated = true;
        int x = this.size * this.size;
        for (int i = 0; i < x; ++i) {
            for (int j = 0; j < this.verticalSize; ++j) {
                long current = this.dataContainer[i * this.verticalSize + j];
                output.writeLong(Long.reverseBytes(current));
            }
            if (DataPointUtil.doesItExist(this.dataContainer[i])) continue;
            allGenerated = false;
        }
        return allGenerated;
    }

    public String toString() {
        String LINE_DELIMITER = "\n";
        String DATA_DELIMITER = " ";
        String SUBDATA_DELIMITER = ",";
        StringBuilder stringBuilder = new StringBuilder();
        int size = 1 << 9 - this.detailLevel;
        stringBuilder.append(this.detailLevel);
        stringBuilder.append(LINE_DELIMITER);
        for (int z = 0; z < size; ++z) {
            for (int x = 0; x < size; ++x) {
                for (int y = 0; y < this.verticalSize; ++y) {
                    stringBuilder.append(Long.toHexString(this.getData(x, z, y)));
                    if (y == this.verticalSize) continue;
                    stringBuilder.append(SUBDATA_DELIMITER);
                }
                if (x == size) continue;
                stringBuilder.append(DATA_DELIMITER);
            }
            if (z == size) continue;
            stringBuilder.append(LINE_DELIMITER);
        }
        return stringBuilder.toString();
    }

    @Override
    public int getMaxNumberOfLods() {
        return this.size * this.size * this.getVerticalSize();
    }

    @Override
    public long getRoughRamUsage() {
        return this.dataContainer.length * 8;
    }
}

