/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.lod.core.logging;

import com.seibel.lod.core.api.ClientApi;
import com.seibel.lod.core.enums.config.LoggerMode;
import java.lang.ref.WeakReference;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Supplier;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;

public class ConfigBasedLogger {
    public static final List<WeakReference<ConfigBasedLogger>> loggers = Collections.synchronizedList(new LinkedList());
    private LoggerMode mode;
    private final Supplier<LoggerMode> getter;
    private final Logger logger;

    public static synchronized void updateAll() {
        loggers.removeIf(logger -> logger.get() == null);
        loggers.forEach(logger -> {
            ConfigBasedLogger l = (ConfigBasedLogger)logger.get();
            if (l != null) {
                l.update();
            }
        });
    }

    public ConfigBasedLogger(Logger logger, Supplier<LoggerMode> configQuery) {
        this.getter = configQuery;
        this.mode = this.getter.get();
        this.logger = logger;
        loggers.add(new WeakReference<ConfigBasedLogger>(this));
    }

    public void update() {
        this.mode = this.getter.get();
    }

    public boolean canMaybeLog() {
        return this.mode != LoggerMode.DISABLED;
    }

    public void log(Level level, String str, Object ... param) {
        Message msg = this.logger.getMessageFactory().newMessage(str, param);
        String msgStr = msg.getFormattedMessage();
        if (this.mode.levelForFile.isLessSpecificThan(level)) {
            Level logLevel;
            Level level2 = logLevel = level.isLessSpecificThan(Level.INFO) ? Level.INFO : level;
            if (param.length > 0 && param[param.length - 1] instanceof Throwable) {
                this.logger.log(logLevel, msgStr, (Throwable)param[param.length - 1]);
            } else {
                this.logger.log(logLevel, msgStr);
            }
        }
        if (this.mode.levelForChat.isLessSpecificThan(level)) {
            if (param.length > 0 && param[param.length - 1] instanceof Throwable) {
                ClientApi.logToChat(level, msgStr + "\nat\n" + Arrays.toString(((Throwable)param[param.length - 1]).getStackTrace()));
            } else {
                ClientApi.logToChat(level, msgStr);
            }
        }
    }

    public void error(String str, Object ... param) {
        this.log(Level.ERROR, str, param);
    }

    public void warn(String str, Object ... param) {
        this.log(Level.WARN, str, param);
    }

    public void info(String str, Object ... param) {
        this.log(Level.INFO, str, param);
    }

    public void debug(String str, Object ... param) {
        this.log(Level.DEBUG, str, param);
    }

    public void trace(String str, Object ... param) {
        this.log(Level.TRACE, str, param);
    }
}

