/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.lod.core.handlers.dependencyInjection;

import com.seibel.lod.core.handlers.dependencyInjection.DependencyHandler;

public class SingletonHandler {
    private static final DependencyHandler dependencyHandler = new DependencyHandler();

    public static void bind(Class<?> interfaceClass, Object singletonReference) throws IllegalStateException {
        dependencyHandler.bind(interfaceClass, singletonReference);
    }

    public static <T> T get(Class<T> interfaceClass) throws NullPointerException, ClassCastException {
        Object foundObject = dependencyHandler.get(interfaceClass);
        if (foundObject == null) {
            throw new NullPointerException("The singleton [" + interfaceClass.getSimpleName() + "] was never bound. If you are calling [bind], make sure it is happening before you call [get].");
        }
        return foundObject;
    }

    public static void finishBinding() {
        dependencyHandler.finishBinding();
    }

    public static boolean getBindingFinished() {
        return dependencyHandler.getBindingFinished();
    }
}

