/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.lod.core.handlers;

import com.seibel.lod.core.api.ApiShared;
import com.seibel.lod.core.enums.config.VerticalQuality;
import com.seibel.lod.core.handlers.LodDimensionFileHandler;
import com.seibel.lod.core.objects.lod.RegionPos;
import com.seibel.lod.core.objects.lod.VerticalLevelContainer;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import shaded.apache.commons.compress.compressors.xz.XZCompressorInputStream;

public class LodDimensionOldFileStructureHandler {
    private final File dimensionDataSaveFolder;
    private final LodDimensionFileHandler newFileHandler;
    private static final String FILE_NAME_PREFIX = "lod";
    private static final String FILE_EXTENSION = ".xz";
    private static final String DETAIL_FOLDER_NAME_PREFIX = "detail-";
    private static final String RETIRED_OLD_STRUCT_POSTFIX = "-RETIRED-CAN-BE-DELETED";
    public static final int LOD_SAVE_FILE_VERSION = 8;
    public static final ExecutorService mergerThreads = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors());

    public LodDimensionOldFileStructureHandler(LodDimensionFileHandler fileHandler) {
        this.dimensionDataSaveFolder = fileHandler.dimensionDataSaveFolder;
        this.newFileHandler = fileHandler;
    }

    private void loadGenModeToRegion(TempLodRegion region, OldDistanceGenerationMode genMode) {
        int regionX = region.posX;
        int regionZ = region.posZ;
        for (byte detail = 9; detail >= 0; detail = (byte)((byte)(detail - 1))) {
            long fileSize;
            File file = new File(this.getFileBasePath() + (Object)((Object)region.vertQual) + File.separatorChar + (Object)((Object)genMode) + File.separatorChar + DETAIL_FOLDER_NAME_PREFIX + detail + File.separatorChar + FILE_NAME_PREFIX + "." + regionX + "." + regionZ + FILE_EXTENSION);
            if (!file.exists() || !file.isFile() || (fileSize = file.length()) == 0L) continue;
            try (FileInputStream fileInStream = new FileInputStream(file);){
                XZCompressorInputStream inputStream = new XZCompressorInputStream(fileInStream);
                int fileVersion = inputStream.read();
                if (fileVersion < 6) {
                    inputStream.close();
                    ApiShared.LOGGER.info("Outdated LOD region file for region: (" + regionX + "," + regionZ + ") version found: " + fileVersion + ", version requested: " + 8 + ". this region file will not be read and merged into the new save structure.");
                    continue;
                }
                if (fileVersion > 8) {
                    inputStream.close();
                    ApiShared.LOGGER.info("Unexpected newer LOD region file for region: (" + regionX + "," + regionZ + ") version found: " + fileVersion + ", version requested: " + 8 + " this region file will not be read and merged into the new save structure.");
                    continue;
                }
                if (fileVersion < 8) {
                    ApiShared.LOGGER.debug("Old LOD region file for region: (" + regionX + "," + regionZ + ") version found: " + fileVersion + ", version requested: " + 8 + ". this region file be read, updated, and merged into the new save structure.");
                }
                VerticalLevelContainer data = new VerticalLevelContainer(new DataInputStream(inputStream), fileVersion, detail);
                if (region.containers[detail] == null) {
                    region.containers[detail] = data;
                } else {
                    region.containers[detail].addChunkOfData(data.dataContainer, 0, 0, data.size, data.size, false);
                }
                inputStream.close();
                continue;
            }
            catch (IOException ioEx) {
                ApiShared.LOGGER.error("LOD file read error. Unable to read xz compressed file [" + file + "] error [" + ioEx.getMessage() + "]: ");
                ioEx.printStackTrace();
            }
        }
    }

    private void saveRegion(TempLodRegion region) {
        for (int detail = 0; detail <= 9; ++detail) {
            if (region.containers[detail] == null) continue;
            this.newFileHandler.saveDirect(region.posX, region.posZ, region.vertQual, region.containers[detail]);
        }
    }

    private void loadAndMergeAndSaveRegion(VerticalQuality verticalQuality, RegionPos regionPos) {
        ApiShared.LOGGER.info("Merging region " + regionPos + " at " + (Object)((Object)verticalQuality) + "...");
        TempLodRegion region = new TempLodRegion(verticalQuality, regionPos);
        ApiShared.LOGGER.info("Reading data...");
        this.loadGenModeToRegion(region, OldDistanceGenerationMode.FULL);
        this.loadGenModeToRegion(region, OldDistanceGenerationMode.FEATURES);
        this.loadGenModeToRegion(region, OldDistanceGenerationMode.SURFACE);
        this.loadGenModeToRegion(region, OldDistanceGenerationMode.BIOME_ONLY_SIMULATE_HEIGHT);
        this.loadGenModeToRegion(region, OldDistanceGenerationMode.BIOME_ONLY);
        this.loadGenModeToRegion(region, OldDistanceGenerationMode.NONE);
        ApiShared.LOGGER.info("Writing data...");
        this.saveRegion(region);
        ApiShared.LOGGER.info("region " + regionPos + " at " + (Object)((Object)verticalQuality) + " merged");
    }

    private RegionPos parseFileName(String fileName) {
        if (!fileName.endsWith(FILE_EXTENSION)) {
            return null;
        }
        if (!fileName.startsWith(FILE_NAME_PREFIX)) {
            return null;
        }
        String[] array = fileName.split("\\.");
        if (array.length != 4) {
            return null;
        }
        try {
            return new RegionPos(Integer.parseInt(array[1]), Integer.parseInt(array[2]));
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    private HashSet<RegionPos> scanOldRegionFiles(VerticalQuality vertQual, OldDistanceGenerationMode genMode) {
        HashSet<RegionPos> result = new HashSet<RegionPos>();
        File baseBaseFolder = new File(this.getFileBasePath() + (Object)((Object)vertQual) + File.separatorChar + (Object)((Object)genMode));
        if (!baseBaseFolder.exists()) {
            return result;
        }
        for (int detail = 0; detail <= 9; detail = (int)((byte)(detail + 1))) {
            File[] subFiles;
            File baseFolder = new File(this.getFileBasePath() + (Object)((Object)vertQual) + File.separatorChar + (Object)((Object)genMode) + File.separatorChar + DETAIL_FOLDER_NAME_PREFIX + detail);
            if (!baseFolder.exists() || !baseFolder.isDirectory()) continue;
            for (File subFile : subFiles = baseFolder.listFiles()) {
                RegionPos pos;
                if (!subFile.isFile() || !subFile.canRead() || (pos = this.parseFileName(subFile.getName())) == null) continue;
                result.add(pos);
            }
        }
        return result;
    }

    private void renameOldFileStructure(VerticalQuality vertQual, OldDistanceGenerationMode genMode) {
        File baseBaseFolder = new File(this.getFileBasePath() + (Object)((Object)vertQual) + File.separatorChar + (Object)((Object)genMode));
        if (!baseBaseFolder.exists()) {
            return;
        }
        baseBaseFolder.renameTo(new File(this.getFileBasePath() + (Object)((Object)vertQual) + File.separatorChar + (Object)((Object)genMode) + RETIRED_OLD_STRUCT_POSTFIX));
    }

    public void mergeOldFileStructureForVertQuality(VerticalQuality vertQual) {
        File baseFile = new File(this.getFileBasePath() + (Object)((Object)vertQual));
        if (!baseFile.exists()) {
            return;
        }
        if (!baseFile.isDirectory()) {
            return;
        }
        HashSet<RegionPos> totalPos = new HashSet<RegionPos>();
        totalPos.addAll(this.scanOldRegionFiles(vertQual, OldDistanceGenerationMode.NONE));
        totalPos.addAll(this.scanOldRegionFiles(vertQual, OldDistanceGenerationMode.BIOME_ONLY));
        totalPos.addAll(this.scanOldRegionFiles(vertQual, OldDistanceGenerationMode.BIOME_ONLY_SIMULATE_HEIGHT));
        totalPos.addAll(this.scanOldRegionFiles(vertQual, OldDistanceGenerationMode.SURFACE));
        totalPos.addAll(this.scanOldRegionFiles(vertQual, OldDistanceGenerationMode.FEATURES));
        totalPos.addAll(this.scanOldRegionFiles(vertQual, OldDistanceGenerationMode.FULL));
        ArrayList<Future> futures = new ArrayList<Future>();
        for (RegionPos pos : totalPos) {
            futures.add(mergerThreads.submit(() -> {
                this.loadAndMergeAndSaveRegion(vertQual, pos);
                return true;
            }));
        }
        futures.forEach(t -> {
            try {
                t.get();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
        this.renameOldFileStructure(vertQual, OldDistanceGenerationMode.NONE);
        this.renameOldFileStructure(vertQual, OldDistanceGenerationMode.BIOME_ONLY);
        this.renameOldFileStructure(vertQual, OldDistanceGenerationMode.BIOME_ONLY_SIMULATE_HEIGHT);
        this.renameOldFileStructure(vertQual, OldDistanceGenerationMode.SURFACE);
        this.renameOldFileStructure(vertQual, OldDistanceGenerationMode.FEATURES);
        this.renameOldFileStructure(vertQual, OldDistanceGenerationMode.FULL);
    }

    private String getFileBasePath() {
        try {
            return this.dimensionDataSaveFolder.getCanonicalPath() + File.separatorChar;
        }
        catch (IOException e) {
            ApiShared.LOGGER.warn("Unable to get the base save file path. Error: " + e.getMessage(), (Throwable)e);
            throw new RuntimeException("DistantHorizons Get Save File Path Failure");
        }
    }

    private static class TempLodRegion {
        final VerticalLevelContainer[] containers;
        final VerticalQuality vertQual;
        final int posX;
        final int posZ;

        TempLodRegion(VerticalQuality vertQual, RegionPos pos) {
            this.vertQual = vertQual;
            this.posX = pos.x;
            this.posZ = pos.z;
            this.containers = new VerticalLevelContainer[10];
        }
    }

    static enum OldDistanceGenerationMode {
        NONE,
        BIOME_ONLY,
        BIOME_ONLY_SIMULATE_HEIGHT,
        SURFACE,
        FEATURES,
        FULL;

    }
}

