/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.lod.core.dataFormat;

public class VerticalDataFormat {
    public static final short MIN_WORLD_HEIGHT = -2048;
    public static final short MAX_WORLD_HEIGHT = 2047;
    public static final byte HEIGHT_SHIFT = 20;
    public static final byte DEPTH_SHIFT = 8;
    public static final byte LEVEL_SHIFT = 3;
    public static final byte BOTTOM_TYPE_SHIFT = 2;
    public static final byte TRANSPARENCY_SHIFT = 1;
    public static final byte EXISTENCE_SHIFT = 0;
    public static final int FULL_MASK = -1;
    public static final int HEIGHT_MASK = 4095;
    public static final int DEPTH_MASK = 4095;
    public static final int LEVEL_MASK = 7;
    public static final int TRANSPARENCY_MASK = 1;
    public static final int BOTTOM_TYPE_MASK = 1;
    public static final int EXISTENCE_MASK = 1;
    public static final int HEIGHT_RESET = 1048575;
    public static final int DEPTH_RESET = -1048321;
    public static final int LEVEL_RESET = -57;
    public static final int TRANSPARENCY_RESET = -5;
    public static final int BOTTOM_TYPE_RESET = -3;
    public static final int EXISTENCE_RESET = -2;
    public static final int EMPTY_LOD = 0;

    public static int createVerticalData(int height, int depth, int level, boolean transparent, boolean bottom) {
        int verticalData = 0;
        verticalData |= (height & 0xFFF) << 20;
        verticalData |= (depth & 0xFFF) << 8;
        verticalData |= (level & 7) << 3;
        if (bottom) {
            verticalData |= 4;
        }
        if (transparent) {
            verticalData |= 2;
        }
        return verticalData |= 1;
    }

    public static short getHeight(int verticalData) {
        return (short)(verticalData >>> 20 & 0xFFF);
    }

    public static short getDepth(int verticalData) {
        return (short)(verticalData >>> 8 & 0xFFF);
    }

    public static byte getLevel(int verticalData) {
        return (byte)(verticalData >>> 3 & 7);
    }

    public static boolean isTransparent(int verticalData) {
        return (verticalData >>> 1 & 1) == 1;
    }

    public static boolean isBottom(int verticalData) {
        return (verticalData >>> 2 & 1) == 1;
    }

    public static boolean doesItExist(int verticalData) {
        return (verticalData >>> 0 & 1) == 1;
    }

    public static int setHeight(int verticalData, int height) {
        return verticalData | (height & 0xFFF) << 20;
    }

    public static int setDepth(int verticalData, int depth) {
        return verticalData | (depth & 0xFFF) << 8;
    }

    public static int setLevel(int verticalData, int level) {
        return verticalData | (level & 7) << 3;
    }

    public static int setTransparency(int verticalData) {
        return verticalData | 2;
    }

    public static int setBottom(int verticalData) {
        return verticalData | 4;
    }

    public static int setExistence(int verticalData) {
        return verticalData | 1;
    }
}

