/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.lod.core.builders.lodBuilding.bufferBuilding;

import com.seibel.lod.core.builders.lodBuilding.LodBuilder;
import com.seibel.lod.core.builders.lodBuilding.bufferBuilding.BufferMergeDirectionEnum;
import com.seibel.lod.core.builders.lodBuilding.bufferBuilding.BufferQuad;
import com.seibel.lod.core.builders.lodBuilding.bufferBuilding.LodBufferBuilderFactory;
import com.seibel.lod.core.enums.LodDirection;
import com.seibel.lod.core.enums.config.GpuUploadMethod;
import com.seibel.lod.core.handlers.dependencyInjection.SingletonHandler;
import com.seibel.lod.core.render.LodRenderer;
import com.seibel.lod.core.render.objects.GLVertexBuffer;
import com.seibel.lod.core.util.ColorUtil;
import com.seibel.lod.core.util.LodUtil;
import com.seibel.lod.core.wrapperInterfaces.config.ILodConfigWrapperSingleton;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.ListIterator;

public class LodQuadBuilder {
    static final ILodConfigWrapperSingleton CONFIG = SingletonHandler.get(ILodConfigWrapperSingleton.class);
    public final boolean skipQuadsWithZeroSkylight;
    public final short skyLightCullingBelow;
    final ArrayList<BufferQuad>[] quads = new ArrayList[6];
    public static final int[][][] DIRECTION_VERTEX_IBO_QUAD = new int[][][]{new int[][]{{1, 0}, {1, 1}, {0, 1}, {0, 0}}, new int[][]{{0, 0}, {0, 1}, {1, 1}, {1, 0}}, new int[][]{{0, 0}, {0, 1}, {1, 1}, {1, 0}}, new int[][]{{1, 0}, {1, 1}, {0, 1}, {0, 0}}, new int[][]{{0, 0}, {1, 0}, {1, 1}, {0, 1}}, new int[][]{{0, 1}, {1, 1}, {1, 0}, {0, 0}}};
    public static final int[][][] DIRECTION_VERTEX_QUAD = new int[][][]{new int[][]{{1, 0}, {1, 1}, {0, 1}, {1, 0}, {0, 1}, {0, 0}}, new int[][]{{0, 0}, {0, 1}, {1, 1}, {0, 0}, {1, 1}, {1, 0}}, new int[][]{{0, 0}, {0, 1}, {1, 1}, {0, 0}, {1, 1}, {1, 0}}, new int[][]{{1, 0}, {1, 1}, {0, 1}, {1, 0}, {0, 1}, {0, 0}}, new int[][]{{0, 0}, {1, 0}, {1, 1}, {0, 0}, {1, 1}, {0, 1}}, new int[][]{{0, 1}, {1, 1}, {1, 0}, {0, 1}, {1, 0}, {0, 0}}};

    public LodQuadBuilder(boolean enableSkylightCulling, int skyLightCullingBelow) {
        for (int i = 0; i < 6; ++i) {
            this.quads[i] = new ArrayList();
        }
        this.skipQuadsWithZeroSkylight = enableSkylightCulling;
        this.skyLightCullingBelow = (short)(skyLightCullingBelow - LodBuilder.MIN_WORLD_HEIGHT);
    }

    public void addQuadAdj(LodDirection dir, short x, short y, short z, short widthEastWest, short widthNorthSouthOrUpDown, int color, byte skylight, byte blocklight) {
        if (dir.ordinal() <= LodDirection.DOWN.ordinal()) {
            throw new IllegalArgumentException("addQuadAdj() is only for adj direction! Not UP or Down!");
        }
        if (this.skipQuadsWithZeroSkylight && skylight == 0 && y < this.skyLightCullingBelow) {
            return;
        }
        this.quads[dir.ordinal()].add(new BufferQuad(x, y, z, widthEastWest, widthNorthSouthOrUpDown, color, skylight, blocklight, dir));
    }

    public void addQuadUp(short x, short y, short z, short width, short wz, int color, byte skylight, byte blocklight) {
        if (this.skipQuadsWithZeroSkylight && skylight == 0 && y < this.skyLightCullingBelow) {
            return;
        }
        this.quads[LodDirection.UP.ordinal()].add(new BufferQuad(x, y, z, width, wz, color, skylight, blocklight, LodDirection.UP));
    }

    public void addQuadDown(short x, short y, short z, short width, short wz, int color, byte skylight, byte blocklight) {
        if (this.skipQuadsWithZeroSkylight && skylight == 0 && y < this.skyLightCullingBelow) {
            return;
        }
        this.quads[LodDirection.DOWN.ordinal()].add(new BufferQuad(x, y, z, width, wz, color, skylight, blocklight, LodDirection.DOWN));
    }

    public void addQuadN(short x, short y, short z, short width, short wy, int color, byte skylight, byte blocklight) {
        if (this.skipQuadsWithZeroSkylight && skylight == 0 && y < this.skyLightCullingBelow) {
            return;
        }
        this.quads[LodDirection.NORTH.ordinal()].add(new BufferQuad(x, y, z, width, wy, color, skylight, blocklight, LodDirection.NORTH));
    }

    public void addQuadS(short x, short y, short z, short width, short wy, int color, byte skylight, byte blocklight) {
        if (this.skipQuadsWithZeroSkylight && skylight == 0 && y < this.skyLightCullingBelow) {
            return;
        }
        this.quads[LodDirection.SOUTH.ordinal()].add(new BufferQuad(x, y, z, width, wy, color, skylight, blocklight, LodDirection.SOUTH));
    }

    public void addQuadW(short x, short y, short z, short width, short wy, int color, byte skylight, byte blocklight) {
        if (this.skipQuadsWithZeroSkylight && skylight == 0 && y < this.skyLightCullingBelow) {
            return;
        }
        this.quads[LodDirection.WEST.ordinal()].add(new BufferQuad(x, y, z, width, wy, color, skylight, blocklight, LodDirection.WEST));
    }

    public void addQuadE(short x, short y, short z, short width, short wy, int color, byte skylight, byte blocklight) {
        if (this.skipQuadsWithZeroSkylight && skylight == 0 && y < this.skyLightCullingBelow) {
            return;
        }
        this.quads[LodDirection.EAST.ordinal()].add(new BufferQuad(x, y, z, width, wy, color, skylight, blocklight, LodDirection.EAST));
    }

    private static void putVertex(ByteBuffer bb, short x, short y, short z, int color, byte skylight, byte blocklight, int mx, int my, int mz) {
        skylight = (byte)(skylight % 16);
        blocklight = (byte)(blocklight % 16);
        bb.putShort(x);
        bb.putShort(y);
        bb.putShort(z);
        short meta = 0;
        meta = (short)(meta | (skylight | blocklight << 4));
        int mirco = 0;
        if (mx != 0) {
            mirco = (byte)(mirco | (mx > 0 ? 1 : 3));
        }
        if (my != 0) {
            mirco = (byte)(mirco | (my > 0 ? 4 : 12));
        }
        if (mz != 0) {
            mirco = (byte)(mirco | (mz > 0 ? 16 : 48));
        }
        meta = (short)(meta | mirco << 8);
        bb.putShort(meta);
        byte r = (byte)ColorUtil.getRed(color);
        byte g = (byte)ColorUtil.getGreen(color);
        byte b = (byte)ColorUtil.getBlue(color);
        byte a = (byte)ColorUtil.getAlpha(color);
        bb.put(r);
        bb.put(g);
        bb.put(b);
        bb.put(a);
    }

    private static void putQuad(ByteBuffer bb, BufferQuad quad) {
        int[][] quadBase = DIRECTION_VERTEX_IBO_QUAD[quad.direction.ordinal()];
        short widthEastWest = quad.widthEastWest;
        short widthNorthSouth = quad.widthNorthSouthOrUpDown;
        LodDirection.Axis axis = quad.direction.getAxis();
        for (int i = 0; i < quadBase.length; ++i) {
            int mz;
            int my;
            int mx;
            short dz;
            short dy;
            short dx;
            switch (axis) {
                case X: {
                    dx = 0;
                    dy = quadBase[i][1] == 1 ? widthNorthSouth : (short)0;
                    dz = quadBase[i][0] == 1 ? widthEastWest : (short)0;
                    mx = 0;
                    my = quadBase[i][1] == 1 ? 1 : -1;
                    mz = quadBase[i][0] == 1 ? 1 : -1;
                    break;
                }
                case Y: {
                    dx = quadBase[i][0] == 1 ? widthEastWest : (short)0;
                    dy = 0;
                    dz = quadBase[i][1] == 1 ? widthNorthSouth : (short)0;
                    mx = quadBase[i][0] == 1 ? 1 : -1;
                    my = 0;
                    mz = quadBase[i][1] == 1 ? 1 : -1;
                    break;
                }
                case Z: {
                    dx = quadBase[i][0] == 1 ? widthEastWest : (short)0;
                    dy = quadBase[i][1] == 1 ? widthNorthSouth : (short)0;
                    dz = 0;
                    mx = quadBase[i][0] == 1 ? 1 : -1;
                    my = quadBase[i][1] == 1 ? 1 : -1;
                    mz = 0;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Invalid Axis enum: " + axis);
                }
            }
            LodQuadBuilder.putVertex(bb, (short)(quad.x + dx), (short)(quad.y + dy), (short)(quad.z + dz), quad.hasError ? ColorUtil.RED : quad.color, quad.hasError ? (byte)15 : (byte)quad.skyLight, quad.hasError ? (byte)15 : (byte)quad.blockLight, mx, my, mz);
        }
    }

    public void mergeQuads() {
        long mergeCount = 0L;
        long preQuadsCount = this.getCurrentQuadsCount();
        if (preQuadsCount <= 1L) {
            return;
        }
        for (int directionIndex = 0; directionIndex < 6; ++directionIndex) {
            mergeCount += this.mergeQuadsInternal(directionIndex, BufferMergeDirectionEnum.EastWest);
            if (directionIndex != 1) continue;
            long pass2 = this.mergeQuadsInternal(directionIndex, BufferMergeDirectionEnum.NorthSouthOrUpDown);
            mergeCount += pass2;
        }
        long postQuadsCount = this.getCurrentQuadsCount();
        LodRenderer.EVENT_LOGGER.debug("Merged {}/{}({}) quads", mergeCount, preQuadsCount, (double)mergeCount / (double)preQuadsCount);
    }

    private long mergeQuadsInternal(int directionIndex, BufferMergeDirectionEnum mergeDirection) {
        if (this.quads[directionIndex].size() <= 1) {
            return 0L;
        }
        this.quads[directionIndex].sort((objOne, objTwo) -> objOne.compare((BufferQuad)objTwo, mergeDirection));
        long mergeCount = 0L;
        ListIterator<BufferQuad> iter = this.quads[directionIndex].listIterator();
        BufferQuad currentQuad = iter.next();
        while (iter.hasNext()) {
            BufferQuad nextQuad = iter.next();
            if (currentQuad.tryMerge(nextQuad, mergeDirection)) {
                ++mergeCount;
                iter.set(null);
                continue;
            }
            currentQuad = nextQuad;
        }
        this.quads[directionIndex].removeIf(o -> o == null);
        return mergeCount;
    }

    public Iterator<ByteBuffer> makeVertexBuffers() {
        return new Iterator<ByteBuffer>(){
            final ByteBuffer bb = ByteBuffer.allocateDirect(LodBufferBuilderFactory.FULL_SIZED_BUFFER).order(ByteOrder.nativeOrder());
            int dir = this.skipEmpty(0);
            int quad = 0;

            private int skipEmpty(int d) {
                while (d < 6 && LodQuadBuilder.this.quads[d].isEmpty()) {
                    ++d;
                }
                return d;
            }

            @Override
            public boolean hasNext() {
                return this.dir < 6;
            }

            @Override
            public ByteBuffer next() {
                if (this.dir >= 6) {
                    return null;
                }
                this.bb.clear();
                this.bb.limit(LodBufferBuilderFactory.FULL_SIZED_BUFFER);
                while (this.bb.hasRemaining() && this.dir < 6) {
                    this.writeData();
                }
                this.bb.limit(this.bb.position());
                this.bb.rewind();
                return this.bb;
            }

            private void writeData() {
                int i;
                for (i = this.quad; i < LodQuadBuilder.this.quads[this.dir].size() && this.bb.hasRemaining(); ++i) {
                    LodQuadBuilder.putQuad(this.bb, LodQuadBuilder.this.quads[this.dir].get(i));
                }
                if (i >= LodQuadBuilder.this.quads[this.dir].size()) {
                    this.quad = 0;
                    ++this.dir;
                    this.dir = this.skipEmpty(this.dir);
                } else {
                    this.quad = i;
                }
            }
        };
    }

    public BufferFiller makeBufferFiller(final GpuUploadMethod method) {
        return new BufferFiller(){
            int dir = 0;
            int quad = 0;

            @Override
            public boolean fill(GLVertexBuffer vbo) {
                if (this.dir >= 6) {
                    vbo.setVertexCount(0);
                    return false;
                }
                int numOfQuads = this._countRemainingQuads();
                if (numOfQuads > LodBufferBuilderFactory.MAX_QUADS_PER_BUFFER) {
                    numOfQuads = LodBufferBuilderFactory.MAX_QUADS_PER_BUFFER;
                }
                if (numOfQuads == 0) {
                    vbo.setVertexCount(0);
                    return false;
                }
                ByteBuffer bb = vbo.mapBuffer(numOfQuads * LodBufferBuilderFactory.QUADS_BYTE_SIZE, method, LodBufferBuilderFactory.FULL_SIZED_BUFFER);
                if (bb == null) {
                    throw new NullPointerException("mapBuffer returned null");
                }
                bb.clear();
                bb.limit(numOfQuads * LodBufferBuilderFactory.QUADS_BYTE_SIZE);
                while (bb.hasRemaining() && this.dir < 6) {
                    this.writeData(bb);
                }
                bb.rewind();
                vbo.unmapBuffer();
                vbo.setVertexCount(numOfQuads * 4);
                return this.dir < 6;
            }

            private int _countRemainingQuads() {
                int a = LodQuadBuilder.this.quads[this.dir].size() - this.quad;
                for (int i = this.dir + 1; i < LodQuadBuilder.this.quads.length; ++i) {
                    a += LodQuadBuilder.this.quads[i].size();
                }
                return a;
            }

            private void writeData(ByteBuffer bb) {
                int startQ;
                int i = startQ = this.quad;
                for (i = startQ; i < LodQuadBuilder.this.quads[this.dir].size() && bb.hasRemaining(); ++i) {
                    LodQuadBuilder.putQuad(bb, LodQuadBuilder.this.quads[this.dir].get(i));
                }
                if (i >= LodQuadBuilder.this.quads[this.dir].size()) {
                    this.quad = 0;
                    ++this.dir;
                    while (this.dir < 6 && LodQuadBuilder.this.quads[this.dir].isEmpty()) {
                        ++this.dir;
                    }
                } else {
                    this.quad = i;
                }
            }
        };
    }

    public int getCurrentQuadsCount() {
        int i = 0;
        for (ArrayList<BufferQuad> qs : this.quads) {
            i += qs.size();
        }
        return i;
    }

    public int getCurrentNeededVertexBufferCount() {
        return LodUtil.ceilDiv(this.getCurrentQuadsCount(), LodBufferBuilderFactory.MAX_QUADS_PER_BUFFER);
    }

    public static interface BufferFiller {
        public boolean fill(GLVertexBuffer var1);
    }
}

