/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.yungsapi.world;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.yungnickyoung.minecraft.yungsapi.YungsApiCommon;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.class_156;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2680;

public class BlockStateRandomizer {
    public static final Codec<BlockStateRandomizer> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Entry.CODEC.listOf().fieldOf("entries").forGetter(selector -> selector.entries), (App)class_2680.field_24734.fieldOf("defaultBlockState").forGetter(selector -> selector.defaultBlockState)).apply((Applicative)instance, BlockStateRandomizer::new));
    private List<Entry> entries = new ArrayList<Entry>();
    private class_2680 defaultBlockState = class_2246.field_10124.method_9564();

    public class_2487 saveTag() {
        class_2487 compoundTag = new class_2487();
        compoundTag.method_10569("defaultBlockStateId", class_2248.field_10651.method_10206((Object)this.defaultBlockState));
        class_2499 entriesTag = (class_2499)class_156.method_654((Object)new class_2499(), tag -> this.entries.forEach(entry -> {
            class_2487 entryTag = new class_2487();
            entryTag.method_10569("entryBlockStateId", class_2248.field_10651.method_10206((Object)entry.blockState));
            entryTag.method_10548("entryChance", entry.probability);
            tag.add((Object)entryTag);
        }));
        compoundTag.method_10566("entries", (class_2520)entriesTag);
        return compoundTag;
    }

    public BlockStateRandomizer(class_2487 compoundTag) {
        this.defaultBlockState = (class_2680)class_2248.field_10651.method_10200(compoundTag.method_10550("defaultBlockStateId"));
        this.entries = new ArrayList<Entry>();
        class_2499 entriesTag = compoundTag.method_10554("entries", 10);
        entriesTag.forEach(entryTag -> {
            class_2487 entryCompoundTag = (class_2487)entryTag;
            class_2680 blockState = (class_2680)class_2248.field_10651.method_10200(entryCompoundTag.method_10550("entryBlockStateId"));
            float chance = entryCompoundTag.method_10583("entryChance");
            this.addBlock(blockState, chance);
        });
    }

    public BlockStateRandomizer(Map<class_2680, Float> entries, class_2680 defaultBlockState) {
        this.entries = new ArrayList<Entry>();
        entries.forEach(this::addBlock);
        this.defaultBlockState = defaultBlockState;
    }

    public BlockStateRandomizer(List<Entry> entries, class_2680 defaultBlockState) {
        this.entries = entries;
        this.defaultBlockState = defaultBlockState;
    }

    public BlockStateRandomizer(class_2680 defaultBlockState) {
        this.defaultBlockState = defaultBlockState;
    }

    public BlockStateRandomizer() {
    }

    public static BlockStateRandomizer from(class_2680 ... blockStates) {
        BlockStateRandomizer selector = new BlockStateRandomizer();
        float chance = 1.0f / (float)blockStates.length;
        for (class_2680 state : blockStates) {
            selector.addBlock(state, chance);
        }
        return selector;
    }

    public BlockStateRandomizer addBlock(class_2680 blockState, float chance) {
        if (this.entries.stream().anyMatch(entry -> entry.blockState.equals(blockState))) {
            YungsApiCommon.LOGGER.warn("WARNING: duplicate block {} added to BlockSelector!", (Object)blockState.toString());
            return this;
        }
        float currTotal = this.entries.stream().map(entry -> Float.valueOf(entry.probability)).reduce(Float::sum).orElse(Float.valueOf(0.0f)).floatValue();
        float newTotal = currTotal + chance;
        if (newTotal > 1.0f) {
            YungsApiCommon.LOGGER.warn("WARNING: block {} added to BlockSelector exceeds max probabiltiy of 1!", (Object)blockState.toString());
            return this;
        }
        this.entries.add(new Entry(blockState, chance));
        return this;
    }

    public class_2680 get(Random random) {
        float target = random.nextFloat();
        float currBottom = 0.0f;
        for (Entry entry : this.entries) {
            if (currBottom <= target && target < currBottom + entry.probability) {
                return entry.blockState;
            }
            currBottom += entry.probability;
        }
        return this.defaultBlockState;
    }

    public void setDefaultBlockState(class_2680 blockState) {
        this.defaultBlockState = blockState;
    }

    public Map<class_2680, Float> getEntriesAsMap() {
        HashMap<class_2680, Float> map = new HashMap<class_2680, Float>();
        this.entries.forEach(entry -> map.put(entry.blockState, Float.valueOf(entry.probability)));
        return map;
    }

    public List<Entry> getEntries() {
        return this.entries;
    }

    public class_2680 getDefaultBlockState() {
        return this.defaultBlockState;
    }

    public static class Entry {
        public static Codec<Entry> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_2680.field_24734.fieldOf("blockState").forGetter(entry -> entry.blockState), (App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("probability").forGetter(entry -> Float.valueOf(entry.probability))).apply((Applicative)instance, Entry::new));
        public class_2680 blockState;
        public float probability;

        public Entry(class_2680 blockState, float probability) {
            this.blockState = blockState;
            this.probability = probability;
        }

        public boolean equals(Object obj) {
            if (obj instanceof Entry) {
                return this.blockState.equals(((Entry)obj).blockState);
            }
            if (obj instanceof class_2680) {
                return this.blockState.equals(obj);
            }
            return false;
        }
    }
}

